/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.BrowserManageAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewCmd;
import org.openmicroscopy.shoola.agents.treeviewer.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.PartialNameVisitor;
import org.openmicroscopy.shoola.agents.util.browser.SmartFolder;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.util.dnd.DnDTree;
import org.openmicroscopy.shoola.agents.util.dnd.ObjectToTransfer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class BrowserUI
extends JPanel
implements PropertyChangeListener {
    private static final int[] VALUES = new int[]{2, 3};
    private DnDTree treeDisplay;
    private JToolBar rightMenuBar;
    private JToolBar leftMenuBar;
    private BrowserControl controller;
    private BrowserModel model;
    private ViewerSorter sorter;
    private TreeExpansionListener listener;
    private TreeSelectionListener selectionListener;
    private Set<TreeImageDisplay> nodesToReset;
    private JToggleButton partialButton;
    private boolean ctrl;
    private boolean leftMouseButton;
    private JComponent bottomComponent;
    private TreeSelectionEvent event;
    private long eventHandledTime = Long.MIN_VALUE;
    private long mousePressedTime;
    private boolean delayedHandlingTreeSelection = false;
    private boolean rightClickButton;
    private boolean rightClickPad;
    private int keyEvent;
    private String typePriority;

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.setBorder(null);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.setBorder(null);
        p.add(this.leftMenuBar);
        p.setPreferredSize(this.leftMenuBar.getPreferredSize());
        bar.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout(2, 0, 0));
        p.setBorder(null);
        p.add(this.rightMenuBar);
        p.setPreferredSize(this.rightMenuBar.getPreferredSize());
        bar.add(p);
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.buildToolBar(), "North");
        this.add((Component)new JScrollPane(this.treeDisplay), "Center");
    }

    private void createMenuBars() {
        JButton button;
        this.rightMenuBar = new JToolBar();
        this.rightMenuBar.setBorder(null);
        this.rightMenuBar.setRollover(true);
        this.rightMenuBar.setFloatable(false);
        this.leftMenuBar = new JToolBar();
        this.leftMenuBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.leftMenuBar.setRollover(true);
        this.leftMenuBar.setFloatable(false);
        int type = this.model.getBrowserType();
        switch (type) {
            case 0: 
            case 1: {
                BrowserManageAction a = (BrowserManageAction)this.controller.getAction(BrowserControl.NEW_CONTAINER);
                button = new JButton(a);
                button.setName("new container button");
                button.setBorderPainted(false);
                button.addMouseListener(a);
                this.rightMenuBar.add(button);
                break;
            }
            case 6: {
                BrowserManageAction a = (BrowserManageAction)this.controller.getAction(BrowserControl.NEW_ADMIN);
                button = new JButton(a);
                button.setName("new group or user button");
                button.setBorderPainted(false);
                button.addMouseListener(a);
                this.rightMenuBar.add(button);
                break;
            }
            case 2: {
                BrowserManageAction a = (BrowserManageAction)this.controller.getAction(BrowserControl.NEW_TAG);
                button = new JButton(a);
                button.setName("new tag button");
                button.setBorderPainted(false);
                button.addMouseListener(a);
                this.rightMenuBar.add(button);
            }
        }
        button = new JButton(this.controller.getAction(BrowserControl.CUT));
        button.setName("cut button");
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        button = new JButton(this.controller.getAction(BrowserControl.COPY));
        button.setName("copy button");
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        button = new JButton(this.controller.getAction(BrowserControl.PASTE));
        button.setName("paste button");
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        button = new JButton(this.controller.getAction(BrowserControl.DELETE));
        button.setName("delete button");
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        button = new JButton(this.controller.getAction(BrowserControl.REFRESH));
        button.setName("refresh button");
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
        if (type == 6) {
            button = new JButton(this.controller.getAction(BrowserControl.RESET_PASSWORD));
            button.setBorderPainted(false);
            this.rightMenuBar.add(button);
        } else {
            button = new JButton(this.controller.getAction(BrowserControl.IMPORT));
            button.setBorderPainted(false);
        }
        this.rightMenuBar.add(Box.createHorizontalStrut(6));
        this.rightMenuBar.add(new JSeparator());
        this.rightMenuBar.add(Box.createHorizontalStrut(6));
        ButtonGroup group = new ButtonGroup();
        JToggleButton b = new JToggleButton();
        group.add(b);
        b.setBorderPainted(true);
        b.setSelected(true);
        b.setAction(this.controller.getAction(BrowserControl.SORT));
        this.rightMenuBar.add(b);
        b = new JToggleButton(this.controller.getAction(BrowserControl.SORT_DATE));
        b.setBorderPainted(true);
        group.add(b);
        this.rightMenuBar.add(b);
        this.partialButton = new JToggleButton(this.controller.getAction(BrowserControl.PARTIAL_NAME));
        this.partialButton.setBorderPainted(true);
        this.rightMenuBar.add(this.partialButton);
        this.rightMenuBar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(BrowserControl.COLLAPSE));
        button.setBorderPainted(false);
        this.rightMenuBar.add(button);
    }

    private void onNodeNavigation(TreeImageDisplay node, boolean expanded) {
        node.setExpanded(expanded);
        this.controller.onNodeNavigation(node, expanded);
        this.treeDisplay.clearSelection();
        try {
            this.treeDisplay.setSelectionPath(new TreePath(node.getPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.treeDisplay.repaint();
    }

    private void onClick(MouseEvent me, boolean released) {
        Point p = me.getPoint();
        int row = this.treeDisplay.getRowForLocation(p.x, p.y);
        if (row != -1) {
            if (me.getClickCount() == 1) {
                this.model.setClickPoint(p);
                if (this.mousePressedTime > this.eventHandledTime) {
                    this.delayedHandlingTreeSelection = true;
                } else {
                    this.handleTreeSelection();
                }
                if (me.isPopupTrigger() && !released || me.isPopupTrigger() && released && !UIUtilities.isMacOS() || UIUtilities.isMacOS() && SwingUtilities.isLeftMouseButton(me) && me.isControlDown()) {
                    if (this.rightClickButton && !this.model.isMultiSelection()) {
                        TreePath path = this.treeDisplay.getPathForLocation(p.x, p.y);
                        if (path != null) {
                            this.treeDisplay.setSelectionPath(path);
                        }
                        if (path != null && path.getLastPathComponent() instanceof TreeImageDisplay) {
                            this.controller.onRightClick((TreeImageDisplay)path.getLastPathComponent());
                        }
                    }
                    if (this.model.getBrowserType() == 6) {
                        this.controller.showPopupMenu(7);
                    } else {
                        this.controller.showPopupMenu(1);
                    }
                }
            } else if (!(me.getClickCount() != 2 || me.isMetaDown() || me.isControlDown() || me.isShiftDown())) {
                TreeImageDisplay d = this.model.getLastSelectedDisplay();
                if (d == null) {
                    return;
                }
                Object o = d.getUserObject();
                if (o instanceof ImageData) {
                    this.model.browse(d);
                } else if (o instanceof PlateData) {
                    if (!d.hasChildrenDisplay() || d.getChildrenDisplay().size() == 1) {
                        this.model.browse(d);
                    }
                } else if (o instanceof PlateAcquisitionData) {
                    this.model.browse(d);
                }
            }
        }
    }

    private void rollOver(MouseEvent e) {
        if (!this.model.getParentModel().isRollOver()) {
            return;
        }
        DnDTree tree = this.treeDisplay;
        TreePath path = this.treeDisplay.getClosestPathForLocation(e.getX(), e.getY());
        Rectangle bounds = tree.getPathBounds(path);
        if (!bounds.contains(e.getPoint())) {
            return;
        }
        TreeImageDisplay node = (TreeImageDisplay)path.getLastPathComponent();
        Object uo = node.getUserObject();
        if (!(uo instanceof DataObject)) {
            return;
        }
    }

    private TreeImageSet createExperimenterNode(ExperimenterData exp, TreeImageDisplay groupNode) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageSet node = new TreeImageSet(exp);
        switch (this.model.getBrowserType()) {
            case 5: {
                this.createTimeElements(node);
                break;
            }
            case 3: {
                this.createFileElements(node);
                break;
            }
            case 2: {
                this.createTagsElements(node);
                break;
            }
            default: {
                this.buildEmptyNode(node);
            }
        }
        groupNode.addChildDisplay(node);
        tm.insertNodeInto(node, groupNode, groupNode.getChildCount());
        return node;
    }

    private TreeImageSet createGroupNode(TreeImageSet node) {
        switch (this.model.getBrowserType()) {
            case 5: {
                this.createTimeElements(node);
                break;
            }
            case 3: {
                this.createFileElements(node);
                break;
            }
            default: {
                this.buildEmptyNode(node);
            }
        }
        return node;
    }

    private void createTimeElements(TreeImageSet parent) {
        int i;
        this.createTimeNode(99, parent, true);
        this.createTimeNode(100, parent, true);
        this.createTimeNode(101, parent, true);
        TreeImageTimeSet n = this.createTimeNode(103, parent, false);
        int month = TreeImageTimeSet.getCurrentMonth() + 1;
        for (i = 0; i < month; ++i) {
            this.createTimeNode(103, i, n);
        }
        n.setNumberItems(-1L);
        n = this.createTimeNode(104, parent, false);
        for (i = 0; i < 12; ++i) {
            this.createTimeNode(104, i, n);
        }
        n.setNumberItems(-1L);
        this.createTimeNode(102, parent, true);
    }

    private void createFileElements(TreeImageSet parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (int i = 0; i < VALUES.length; ++i) {
            TreeFileSet node = new TreeFileSet(VALUES[i]);
            this.buildEmptyNode(node);
            node.setNumberItems(-1L);
            parent.addChildDisplay(node);
            tm.insertNodeInto(node, parent, parent.getChildCount());
        }
    }

    private void createTagsElements(TreeImageDisplay parent) {
        if (this.model.getDisplayMode() == 0) {
            return;
        }
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeFileSet node = new TreeFileSet(4);
        this.buildEmptyNode(node);
        node.setNumberItems(-1L);
        parent.addChildDisplay(node);
        tm.insertNodeInto(node, parent, parent.getChildCount());
    }

    private TreeImageTimeSet createTimeNode(int index, TreeImageSet parent, boolean empty) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageTimeSet date = new TreeImageTimeSet(index);
        if (empty) {
            this.buildEmptyNode(date);
        }
        parent.addChildDisplay(date);
        tm.insertNodeInto(date, parent, parent.getChildCount());
        return date;
    }

    private TreeImageTimeSet createTimeNode(int index, int month, TreeImageSet parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageTimeSet date = new TreeImageTimeSet(index, month);
        this.buildEmptyNode(date);
        parent.addChildDisplay(date);
        tm.insertNodeInto(date, parent, parent.getChildCount());
        parent.setChildrenLoaded(true);
        return date;
    }

    private List<TreeImageNode> transformDirectory(TreeImageSet dirSet) {
        ArrayList<TreeImageNode> leaves = new ArrayList<TreeImageNode>();
        FileData dir = (FileData)dirSet.getUserObject();
        TreeImageDisplay expNode = BrowserFactory.getDataOwner(dirSet);
        if (expNode == null) {
            return leaves;
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData)) {
            return leaves;
        }
        long expID = ((ExperimenterData)ho).getId();
        DataObject[] files = this.model.getFilesData(expID, dir);
        if (files != null && files.length > 0) {
            DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
            for (int i = 0; i < files.length; ++i) {
                DataObject object = files[i];
                TreeImageDisplay display = null;
                if (object instanceof FileData) {
                    FileData file = (FileData)object;
                    if (file.isDirectory()) {
                        display = new TreeImageSet(file);
                        this.buildEmptyNode(display);
                    } else {
                        display = new TreeImageNode(file);
                    }
                } else if (object instanceof ImageData) {
                    display = TreeViewerTranslator.transformImage((ImageData)object);
                }
                if (display == null) continue;
                dirSet.addChildDisplay(display);
            }
        }
        return leaves;
    }

    private Set<TreeImageDisplay> createFileSystemExplorer(TreeImageDisplay expNode) {
        HashSet<TreeImageDisplay> results = new HashSet<TreeImageDisplay>();
        ExperimenterData exp = (ExperimenterData)expNode.getUserObject();
        FSFileSystemView fs = this.model.getRepositories(exp.getId());
        if (fs == null) {
            return results;
        }
        FileData[] files = fs.getRoots();
        for (int j = 0; j < files.length; ++j) {
            FileData file = files[j];
            if (!file.isDirectory()) continue;
            TreeImageSet display = new TreeImageSet(file);
            expNode.addChildDisplay(display);
            this.buildEmptyNode(display);
            results.add(display);
        }
        return results;
    }

    private void handleTreeSelection() {
        this.delayedHandlingTreeSelection = false;
        TreeImageDisplay[] nodes = this.model.getSelectedDisplays();
        if ((this.rightClickButton && !this.ctrl || this.rightClickPad) && this.model.isMultiSelection()) {
            this.setFoundNode(nodes);
            return;
        }
        if (this.ctrl && this.leftMouseButton) {
            int i;
            TreePath[] paths = this.treeDisplay.getSelectionPaths();
            ArrayList<TreePath> added = new ArrayList<TreePath>();
            TreePath[] all = null;
            if (paths != null) {
                all = new TreePath[paths.length];
                for (i = 0; i < paths.length; ++i) {
                    all[i] = new TreePath(paths[i].getPath());
                }
            }
            if (all != null) {
                this.treeDisplay.setSelectionPaths(all);
            }
            if (all != null) {
                for (i = 0; i < all.length; ++i) {
                    added.add(all[i]);
                }
            }
            this.controller.onClick(added);
            return;
        }
        if (this.event == null) {
            return;
        }
        TreePath[] paths = this.event.getPaths();
        ArrayList<TreePath> added = new ArrayList<TreePath>();
        for (int i = 0; i < paths.length; ++i) {
            if (this.rightClickPad) {
                if (this.event.isAddedPath(paths[i])) continue;
                added.add(paths[i]);
                continue;
            }
            if (!this.event.isAddedPath(paths[i])) continue;
            added.add(paths[i]);
        }
        this.controller.onClick(added);
    }

    private void handleMultiSelection() {
        TreeImageDisplay[] nodes = this.model.getSelectedDisplays();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        TreeImageDisplay n = nodes[0];
        Object o = n.getUserObject();
        if (o instanceof ImageData) {
            TreeImageDisplay p = n.getParentDisplay();
            this.controller.selectNodes(p.getChildrenDisplay(), ImageData.class);
        } else if (o instanceof DatasetData) {
            if (n.isExpanded()) {
                this.controller.selectNodes(n.getChildrenDisplay(), ImageData.class);
            } else {
                TreeImageDisplay p = n.getParentDisplay();
                this.controller.selectNodes(p.getChildrenDisplay(), DatasetData.class);
            }
        } else if (o instanceof ProjectData) {
            if (n.isExpanded()) {
                this.controller.selectNodes(n.getChildrenDisplay(), DatasetData.class);
            } else {
                TreeImageDisplay p = n.getParentDisplay();
                this.controller.selectNodes(p.getChildrenDisplay(), ProjectData.class);
            }
        } else if (o instanceof ScreenData) {
            if (n.isExpanded()) {
                this.controller.selectNodes(n.getChildrenDisplay(), PlateData.class);
            } else {
                TreeImageDisplay p = n.getParentDisplay();
                this.controller.selectNodes(p.getChildrenDisplay(), ScreenData.class);
            }
        } else if (o instanceof PlateData) {
            if (n.isExpanded()) {
                this.controller.selectNodes(n.getChildrenDisplay(), PlateAcquisitionData.class);
            } else {
                TreeImageDisplay p = n.getParentDisplay();
                this.controller.selectNodes(p.getChildrenDisplay(), PlateData.class);
            }
        } else if (o instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)o;
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                if (n.isExpanded()) {
                    this.controller.selectNodes(n.getChildrenDisplay(), TagAnnotationData.class);
                } else {
                    TreeImageDisplay p = n.getParentDisplay();
                    List l = p.getChildrenDisplay();
                    Iterator i = l.iterator();
                    ArrayList<TreeImageDisplay> values = new ArrayList<TreeImageDisplay>();
                    while (i.hasNext()) {
                        TreeImageDisplay node = (TreeImageDisplay)i.next();
                        Object data = node.getUserObject();
                        if (!(data instanceof TagAnnotationData) || !"openmicroscopy.org/omero/insight/tagset".equals(ns = (tag = (TagAnnotationData)data).getNameSpace())) continue;
                        values.add(node);
                    }
                    this.controller.selectNodes(values, TagAnnotationData.class);
                }
            } else if (n.isExpanded()) {
                this.controller.selectNodes(n.getChildrenDisplay(), ImageData.class);
            } else {
                TreeImageDisplay p = n.getParentDisplay();
                List l = p.getChildrenDisplay();
                Iterator i = l.iterator();
                ArrayList<TreeImageDisplay> values = new ArrayList<TreeImageDisplay>();
                while (i.hasNext()) {
                    TreeImageDisplay node = (TreeImageDisplay)i.next();
                    Object data = node.getUserObject();
                    if (!(data instanceof TagAnnotationData) || "openmicroscopy.org/omero/insight/tagset".equals(ns = (tag = (TagAnnotationData)data).getNameSpace())) continue;
                    values.add(node);
                }
                this.controller.selectNodes(values, TagAnnotationData.class);
            }
        } else if (o instanceof FileAnnotationData) {
            TreeImageDisplay p = n.getParentDisplay();
            this.controller.selectNodes(p.getChildrenDisplay(), FileAnnotationData.class);
        } else if (n instanceof TreeImageTimeSet) {
            TreeImageTimeSet time = (TreeImageTimeSet)n;
            if (time.containsImages()) {
                this.controller.selectNodes(n.getChildrenDisplay(), ImageData.class);
            }
        } else if (n instanceof TreeFileSet) {
            this.controller.selectNodes(n.getChildrenDisplay(), FileAnnotationData.class);
        }
    }

    private TreeImageDisplay buildTreeNodes(ExperimenterData exp) {
        TreeImageDisplay root = this.getTreeRoot();
        TreeImageDisplay node = null;
        switch (this.model.getDisplayMode()) {
            case 0: {
                if (TreeViewerAgent.isMultiGroups()) {
                    GroupData group = this.model.getSelectedGroup();
                    List<TreeImageSet> nodes = this.createGroups(group);
                    for (TreeImageSet n : nodes) {
                        GroupData g = (GroupData)n.getUserObject();
                        n = this.createGroupNode(n);
                        if (g.getId() != group.getId()) continue;
                        node = n;
                    }
                    break;
                }
                node = this.createGroup(this.model.getSelectedGroup());
                node = this.createGroupNode((TreeImageSet)node);
                break;
            }
            default: {
                if (this.model.isSingleGroup()) {
                    node = root;
                    node = this.createExperimenterNode(exp, node);
                    break;
                }
                if (TreeViewerAgent.isMultiGroups()) {
                    GroupData group = this.model.getSelectedGroup();
                    List<TreeImageSet> nodes = this.createGroups(group);
                    for (TreeImageSet n : nodes) {
                        GroupData g = (GroupData)n.getUserObject();
                        n = this.createExperimenterNode(exp, n);
                        if (g.getId() != group.getId()) continue;
                        node = n;
                    }
                    break;
                }
                node = this.createGroup(this.model.getSelectedGroup());
                node = this.createExperimenterNode(exp, node);
            }
        }
        return node;
    }

    private List<TreeImageSet> createGroups(GroupData defaultGroup) {
        TreeImageDisplay root = this.getTreeRoot();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        ArrayList<TreeImageSet> l = new ArrayList<TreeImageSet>();
        List groups = this.sorter.sort(TreeViewerAgent.getAvailableUserGroups());
        Iterator i = groups.iterator();
        TreeImageSet n = new TreeImageSet(defaultGroup);
        TreeViewerTranslator.formatToolTipFor(n);
        l.add(n);
        root.addChildDisplay(n);
        tm.insertNodeInto(n, root, root.getChildCount());
        while (i.hasNext()) {
            GroupData group = (GroupData)i.next();
            if (group.getId() == defaultGroup.getId()) continue;
            n = new TreeImageSet(group);
            TreeViewerTranslator.formatToolTipFor(n);
            l.add(n);
            root.addChildDisplay(n);
            tm.insertNodeInto(n, root, root.getChildCount());
        }
        return l;
    }

    private TreeImageSet createGroup(GroupData group) {
        TreeImageDisplay root = this.getTreeRoot();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageSet n = new TreeImageSet(group);
        TreeViewerTranslator.formatToolTipFor(n);
        root.addChildDisplay(n);
        tm.insertNodeInto(n, root, root.getChildCount());
        return n;
    }

    private void createTrees(ExperimenterData exp) {
        TreeImageDisplay node;
        this.treeDisplay = new DnDTree(this.model.getUserID(), TreeViewerAgent.isAdministrator());
        this.treeDisplay.addPropertyChangeListener(this);
        String key = "meta pressed A";
        if (UIUtilities.isWindowsOS()) {
            key = "ctrl pressed A";
        }
        KeyStroke ks = KeyStroke.getKeyStroke(key);
        this.treeDisplay.getInputMap().put(ks, "none");
        this.treeDisplay.setVisible(true);
        this.treeDisplay.setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.treeDisplay);
        this.treeDisplay.setCellRenderer(new TreeCellRenderer(this.model.getUserID()));
        this.treeDisplay.setShowsRootHandles(true);
        TreeImageSet root = new TreeImageSet("");
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        if (this.model.getBrowserType() != 6 && (node = this.buildTreeNodes(exp)) != null) {
            this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        }
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BrowserUI.this.mousePressedTime = e.getWhen();
                BrowserUI.this.rightClickPad = UIUtilities.isMacOS() && SwingUtilities.isLeftMouseButton(e) && e.isControlDown();
                BrowserUI.this.rightClickButton = SwingUtilities.isRightMouseButton(e);
                BrowserUI.this.ctrl = e.isControlDown();
                if (UIUtilities.isMacOS()) {
                    BrowserUI.this.ctrl = e.isMetaDown();
                }
                BrowserUI.this.leftMouseButton = SwingUtilities.isLeftMouseButton(e);
                if (UIUtilities.isMacOS() || UIUtilities.isLinuxOS()) {
                    BrowserUI.this.onClick(e, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BrowserUI.this.leftMouseButton = SwingUtilities.isLeftMouseButton(e);
                if (UIUtilities.isWindowsOS()) {
                    BrowserUI.this.onClick(e, true);
                }
            }
        });
        this.treeDisplay.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                BrowserUI.this.rollOver(e);
            }
        });
        this.treeDisplay.addTreeExpansionListener(this.listener);
        this.selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                BrowserUI.this.event = e;
                BrowserUI.this.eventHandledTime = System.currentTimeMillis();
                if (BrowserUI.this.delayedHandlingTreeSelection) {
                    BrowserUI.this.handleTreeSelection();
                }
                switch (BrowserUI.this.keyEvent) {
                    case 38: 
                    case 40: {
                        TreePath[] paths = BrowserUI.this.treeDisplay.getSelectionPaths();
                        if (paths != null) {
                            BrowserUI.this.controller.onClick(Arrays.asList(paths));
                            break;
                        }
                        BrowserUI.this.controller.onClick(new ArrayList<TreePath>());
                    }
                }
            }
        };
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
        this.treeDisplay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                BrowserUI.this.ctrl = false;
                block0 : switch (e.getKeyCode()) {
                    case 10: {
                        ViewCmd cmd = new ViewCmd(BrowserUI.this.model.getParentModel(), true);
                        cmd.execute();
                        break;
                    }
                    case 127: {
                        switch (BrowserUI.this.model.getState()) {
                            case 11: 
                            case 12: {
                                break block0;
                            }
                        }
                        BrowserUI.this.model.delete();
                        break;
                    }
                    case 17: {
                        if (UIUtilities.isMacOS()) break;
                        BrowserUI.this.ctrl = true;
                        break;
                    }
                    case 157: {
                        if (!UIUtilities.isMacOS()) break;
                        BrowserUI.this.ctrl = true;
                        break;
                    }
                    case 65: {
                        if ((!UIUtilities.isWindowsOS() || !e.isControlDown()) && (UIUtilities.isWindowsOS() || !e.isMetaDown())) break;
                        BrowserUI.this.handleMultiSelection();
                        break;
                    }
                    case 38: 
                    case 39: 
                    case 40: {
                        BrowserUI.this.keyEvent = e.getKeyCode();
                        break;
                    }
                    case 37: {
                        TreePath[] paths = BrowserUI.this.treeDisplay.getSelectionPaths();
                        for (int i = 0; i < paths.length; ++i) {
                            TreeImageDisplay node;
                            Object o = paths[i].getLastPathComponent();
                            if (!(o instanceof TreeImageDisplay) || !(node = (TreeImageDisplay)o).isExpanded()) continue;
                            node.setExpanded(false);
                        }
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                BrowserUI.this.ctrl = false;
                BrowserUI.this.keyEvent = -1;
            }
        });
    }

    private void buildTreeNode(TreeImageDisplay parent, Collection nodes, DefaultTreeModel tm) {
        if (nodes.size() == 0) {
            tm.insertNodeInto(new DefaultMutableTreeNode("Empty"), parent, parent.getChildCount());
            return;
        }
        Iterator i = nodes.iterator();
        parent.removeAllChildren();
        int browserType = this.model.getBrowserType();
        while (i.hasNext()) {
            TreeImageDisplay display = (TreeImageDisplay)i.next();
            tm.insertNodeInto(display, parent, parent.getChildCount());
            if (!(display instanceof TreeImageSet)) continue;
            List children = display.getChildrenDisplay();
            if (children.size() > 0) {
                if (display.containsImages()) {
                    display.setExpanded(true);
                    this.setExpandedParent(display, false);
                    this.nodesToReset.add(display);
                    this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(children)), tm);
                    this.expandNode(display);
                    tm.reload(display);
                    continue;
                }
                if (browserType == 2) {
                    if (display.isExpanded()) {
                        this.setExpandedParent(display, false);
                        this.nodesToReset.add(display);
                    }
                    this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(children)), tm);
                    if (!display.isExpanded()) continue;
                    this.expandNode(display);
                    tm.reload(display);
                    continue;
                }
                if (display.isExpanded()) {
                    this.setExpandedParent(display, true);
                    this.nodesToReset.add(display);
                }
                this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(children)), tm);
                continue;
            }
            Object uo = display.getUserObject();
            if (uo instanceof DatasetData) {
                tm.insertNodeInto(new DefaultMutableTreeNode("Empty"), display, display.getChildCount());
                continue;
            }
            if (uo instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)uo;
                if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) continue;
                tm.insertNodeInto(new DefaultMutableTreeNode("Empty"), display, display.getChildCount());
                continue;
            }
            if (uo instanceof GroupData) {
                tm.insertNodeInto(new DefaultMutableTreeNode("Empty"), display, display.getChildCount());
                continue;
            }
            if (!(uo instanceof FileAnnotationData) || browserType != 1) continue;
            TreeImageSet n = new TreeImageSet(uo);
            tm.insertNodeInto(new DefaultMutableTreeNode("Empty"), n, n.getChildCount());
        }
        if (parent.isExpanded()) {
            this.expandNode(parent);
            tm.reload(parent);
        }
    }

    private void setExpandedParent(TreeImageDisplay n, boolean b) {
        TreeImageDisplay p = n.getParentDisplay();
        if (p != null) {
            p.setExpanded(b);
            this.setExpandedParent(p, b);
        }
    }

    private void buildEmptyNode(DefaultMutableTreeNode node) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.insertNodeInto(new DefaultMutableTreeNode("Empty"), node, node.getChildCount());
    }

    private void buildOrphanImagesNode(TreeImageDisplay parent) {
        Registry reg = TreeViewerAgent.getRegistry();
        Boolean value = Boolean.parseBoolean((String)reg.lookup("omero.client.ui.tree.orphans.enabled"));
        if (value != null && !value.booleanValue()) {
            boolean enabled = false;
            if (TreeViewerAgent.isAdministrator()) {
                enabled = true;
            } else {
                long expID = TreeViewerAgent.getUserDetails().getId();
                if (expID == parent.getUserObjectId()) {
                    enabled = true;
                } else {
                    Set leaders;
                    TreeImageDisplay node = parent.getParentDisplay();
                    long id = -1L;
                    if (node != null && (id = node.getUserObjectId()) == -1L) {
                        id = TreeViewerAgent.getUserDetails().getGroupId();
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(leaders = TreeViewerAgent.getGroupsLeaderOf()))) {
                        for (GroupData type : leaders) {
                            if (id != type.getId()) continue;
                            enabled = true;
                        }
                    }
                }
            }
            if (!enabled) {
                return;
            }
        }
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeFileSet node = new TreeFileSet(5);
        String v = (String)reg.lookup("omero.client.ui.tree.orphans.name");
        if (CommonsLangUtils.isNotBlank(v)) {
            node.setUserObject(v);
        }
        if (CommonsLangUtils.isNotBlank(v = (String)reg.lookup("omero.client.ui.tree.orphans.description"))) {
            node.setToolTip(v);
        }
        this.buildEmptyNode(node);
        node.setNumberItems(-1L);
        parent.addChildDisplay(node);
        tm.insertNodeInto(node, parent, parent.getChildCount());
    }

    private void sortNode(TreeImageSet node) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        List children = node.getChildrenDisplay();
        if (node.containsImages()) {
            node.removeAllChildren();
            dtm.reload(node);
            if (children.size() != 0) {
                this.buildTreeNode(node, this.sorter.sort(children), dtm);
            } else {
                this.buildEmptyNode(node);
            }
            Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
            while (j.hasNext()) {
                this.setExpandedParent(j.next(), true);
            }
        } else if (children.size() != 0) {
            Iterator j = children.iterator();
            while (j.hasNext()) {
                this.sortNode((TreeImageSet)j.next());
            }
        } else {
            this.buildEmptyNode(node);
        }
    }

    private void refreshFolderNode(TreeImageSet node, Set elements) {
        node.removeAllChildren();
        node.removeAllChildrenDisplay();
        for (TreeImageDisplay child : elements) {
            node.addChildDisplay(child);
        }
        this.buildTreeNode(node, this.sorter.sort(elements), (DefaultTreeModel)this.treeDisplay.getModel());
        node.setExpanded(true);
        this.expandNode(node);
    }

    private int getTypePriority(String type) {
        if (CommonsLangUtils.isEmpty(this.typePriority)) {
            return 0;
        }
        int value = this.typePriority.indexOf(type);
        return value == -1 ? Integer.MAX_VALUE : value;
    }

    private List prepareSortedList(List sorted) {
        ArrayList<TreeImageDisplay> top = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> bottom = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> top2 = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> bottom2 = new ArrayList<TreeImageDisplay>();
        int projectPriority = this.getTypePriority("project");
        int datasetPriority = this.getTypePriority("dataset");
        int screenPriority = this.getTypePriority("screen");
        int platePriority = this.getTypePriority("plate");
        int plateAqPriority = this.getTypePriority("acquisition");
        int tagPriority = this.getTypePriority("tag");
        int tagsetPriority = this.getTypePriority("tagset");
        for (TreeImageDisplay object : sorted) {
            Object f;
            Object uo = object.getUserObject();
            if (uo instanceof ProjectData) {
                if (projectPriority <= datasetPriority) {
                    top.add(object);
                    continue;
                }
                bottom.add(object);
                continue;
            }
            if (uo instanceof GroupData) {
                top.add(object);
                continue;
            }
            if (uo instanceof ScreenData) {
                if (screenPriority <= platePriority) {
                    top2.add(object);
                    continue;
                }
                bottom2.add(object);
                continue;
            }
            if (uo instanceof DatasetData) {
                if (projectPriority <= datasetPriority) {
                    bottom.add(object);
                    continue;
                }
                top.add(object);
                continue;
            }
            if (uo instanceof PlateData) {
                if (screenPriority <= platePriority) {
                    bottom2.add(object);
                    continue;
                }
                top2.add(object);
                continue;
            }
            if (uo instanceof PlateAcquisitionData) {
                if (screenPriority <= plateAqPriority) {
                    bottom2.add(object);
                    continue;
                }
                top2.add(object);
                continue;
            }
            if (uo instanceof TagAnnotationData) {
                if ("openmicroscopy.org/omero/insight/tagset".equals(((TagAnnotationData)uo).getNameSpace())) {
                    if (tagsetPriority <= tagPriority) {
                        top.add(object);
                        continue;
                    }
                    bottom.add(object);
                    continue;
                }
                if (tagsetPriority <= tagPriority) {
                    bottom.add(object);
                    continue;
                }
                top.add(object);
                continue;
            }
            if (uo instanceof File) {
                f = (File)uo;
                if (((File)f).isDirectory()) {
                    if (((TreeImageSet)object).isSystem()) {
                        top.add(object);
                        continue;
                    }
                    bottom.add(object);
                    continue;
                }
                top.add(object);
                continue;
            }
            if (uo instanceof FileData) {
                f = (FileData)uo;
                if (((FileData)f).isDirectory()) {
                    top.add(object);
                    continue;
                }
                bottom.add(object);
                continue;
            }
            if (uo instanceof ImageData) {
                bottom.add(object);
                continue;
            }
            if (uo instanceof ExperimenterData) {
                bottom.add(object);
                continue;
            }
            if (!(object instanceof SmartFolder) && !(object instanceof TreeFileSet)) continue;
            bottom2.add(object);
        }
        ArrayList<TreeImageDisplay> all = new ArrayList<TreeImageDisplay>();
        if (top.size() > 0) {
            all.addAll(top);
        }
        if (bottom.size() > 0) {
            all.addAll(bottom);
        }
        if (top2.size() > 0) {
            all.addAll(top2);
        }
        if (bottom2.size() > 0) {
            all.addAll(bottom2);
        }
        return all;
    }

    private void refreshFileFolder(TreeImageDisplay expNode, Map<Integer, Set> r) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        expNode.setChildrenLoaded(true);
        expNode.setExpanded(true);
        if (r == null || r.size() == 0) {
            return;
        }
        Iterator<Integer> i = r.keySet().iterator();
        int n = expNode.getChildCount();
        dtm.reload();
        while (i.hasNext()) {
            int index = i.next();
            for (int j = 0; j < n; ++j) {
                TreeFileSet node = (TreeFileSet)expNode.getChildAt(j);
                if (node.getType() != index) continue;
                this.refreshFolderNode(node, r.get(index));
            }
        }
        this.setExpandedParent(expNode, true);
    }

    private void refreshTimeFolder(TreeImageDisplay expNode, Map<Integer, Set> r) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        expNode.setChildrenLoaded(Boolean.TRUE);
        expNode.setExpanded(true);
        if (r == null || r.size() == 0) {
            return;
        }
        Iterator<Integer> i = r.keySet().iterator();
        int n = expNode.getChildCount();
        dtm.reload();
        while (i.hasNext()) {
            int index = i.next();
            for (int j = 0; j < n; ++j) {
                TreeImageTimeSet node = (TreeImageTimeSet)expNode.getChildAt(j);
                int nodeType = node.getType();
                switch (nodeType) {
                    case 103: 
                    case 104: {
                        List children = node.getChildrenDisplay();
                        for (TreeImageTimeSet child : children) {
                            if (child.getIndex() != index) continue;
                            this.refreshFolderNode(child, r.get(index));
                        }
                        break;
                    }
                }
                if (node.getIndex() != index) continue;
                this.refreshFolderNode(node, r.get(index));
            }
        }
        this.setExpandedParent(expNode, true);
    }

    BrowserUI() {
        this.sorter = new ViewerSorter();
        this.nodesToReset = new HashSet<TreeImageDisplay>();
        this.listener = new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation((TreeImageDisplay)e.getPath().getLastPathComponent(), false);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation((TreeImageDisplay)e.getPath().getLastPathComponent(), true);
            }
        };
        Registry reg = TreeViewerAgent.getRegistry();
        this.typePriority = (String)reg.lookup("omero.client.ui.tree.type_order");
    }

    void initialize(BrowserControl controller, BrowserModel model, ExperimenterData exp) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.createMenuBars();
        this.createTrees(exp);
        this.buildGUI();
    }

    void loadAction(TreeImageDisplay parent) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        tm.insertNodeInto(new DefaultMutableTreeNode("Loading..."), parent, parent.getChildCount());
        tm.reload(parent);
    }

    boolean isFirstChildMessage(TreeImageDisplay parent) {
        int n = parent.getChildCount();
        if (n == 0) {
            return true;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(0);
        Object uo = node.getUserObject();
        return "Loading...".equals(uo) || "Empty".equals(uo);
    }

    JTree getTreeDisplay() {
        return this.treeDisplay;
    }

    TreeImageDisplay getTreeRoot() {
        if (this.treeDisplay == null) {
            return null;
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (dtm == null) {
            return null;
        }
        return (TreeImageDisplay)dtm.getRoot();
    }

    String getBrowserTitle() {
        switch (this.model.getBrowserType()) {
            case 0: {
                return "Projects";
            }
            case 5: {
                return "Images";
            }
            case 2: {
                return "Tags";
            }
            case 1: {
                return "Screens";
            }
            case 3: {
                return "Attachments";
            }
            case 4: {
                return "File System";
            }
            case 6: {
                return "Administration";
            }
        }
        return "";
    }

    void selectFoundNode(TreeImageDisplay node) {
        TreePath path = new TreePath(node.getPath());
        this.treeDisplay.setSelectionPath(path);
        TreeCellRenderer renderer = (TreeCellRenderer)this.treeDisplay.getCellRenderer();
        renderer.getTreeCellRendererComponent(this.treeDisplay, node, this.treeDisplay.isPathSelected(path), false, true, 0, false);
    }

    void collapsePath(DefaultMutableTreeNode node) {
        this.treeDisplay.removeTreeExpansionListener(this.listener);
        this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        this.treeDisplay.addTreeExpansionListener(this.listener);
    }

    void cancel(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.getChildCount() <= 1 && node.getUserObject() instanceof String) {
            node.removeAllChildren();
            this.buildEmptyNode(node);
        }
        ((DefaultTreeModel)this.treeDisplay.getModel()).reload(node);
        this.collapsePath(node);
    }

    void updateNodes(List nodes, DataObject object) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        for (TreeImageDisplay node : nodes) {
            node.setUserObject(object);
            dtm.nodeChanged(node);
        }
    }

    void removeNodes(List nodes, TreeImageDisplay parentDisplay) {
        if (parentDisplay == null) {
            parentDisplay = this.getTreeRoot();
        }
        Iterator i = nodes.iterator();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        while (i.hasNext()) {
            TreeImageDisplay node = (TreeImageDisplay)i.next();
            TreeImageDisplay parent = node.getParentDisplay();
            if (!parent.isChildrenLoaded()) continue;
            parent.removeChildDisplay(node);
            parent.remove(node);
            dtm.reload(parent);
            if (!parent.equals(parentDisplay)) continue;
            this.treeDisplay.setSelectionPath(new TreePath(parent.getPath()));
        }
    }

    void createNodes(List nodes, TreeImageDisplay newNode, TreeImageDisplay parentDisplay) {
        if (parentDisplay == null) {
            parentDisplay = this.getTreeRoot();
        }
        Iterator i = nodes.iterator();
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        boolean toLoad = false;
        while (i.hasNext()) {
            TreeImageDisplay parent = (TreeImageDisplay)i.next();
            if (parent.isChildrenLoaded()) {
                parent.addChildDisplay(newNode);
                List list = this.prepareSortedList(this.sorter.sort(parent.getChildrenDisplay()));
                parent.removeAllChildren();
                for (TreeImageDisplay n : list) {
                    if (!n.isChildrenLoaded()) {
                        n.removeAllChildren();
                        this.buildEmptyNode(n);
                    }
                    dtm.insertNodeInto(n, parent, parent.getChildCount());
                }
                dtm.reload(parent);
                this.expandNode(parent);
                if (!parent.equals(parentDisplay)) continue;
                this.treeDisplay.setSelectionPath(new TreePath(newNode.getPath()));
                continue;
            }
            if (!parent.equals(parentDisplay)) continue;
            toLoad = true;
        }
        if (toLoad) {
            // empty if block
        }
    }

    void sortNodes(int type) {
        boolean b = type == 300;
        this.sorter.setByDate(b);
        this.sorter.setAscending(!b);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = (TreeImageDisplay)dtm.getRoot();
        int n = root.getChildCount();
        switch (this.model.getBrowserType()) {
            case 3: 
            case 5: {
                for (int i = 0; i < n; ++i) {
                    TreeImageDisplay node = (TreeImageDisplay)root.getChildAt(i);
                    List children = node.getChildrenDisplay();
                    for (TreeImageDisplay child : children) {
                        if (!(child instanceof TreeImageTimeSet) && !(child instanceof TreeFileSet)) continue;
                        this.sortNode((TreeImageSet)child);
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    TreeImageDisplay node = (TreeImageDisplay)root.getChildAt(i);
                    List children = node.getChildrenDisplay();
                    node.removeAllChildren();
                    dtm.reload(node);
                    if (!children.isEmpty()) {
                        if (node.getUserObject() instanceof GroupData) {
                            List all = this.prepareSortedList(this.sorter.sort(children));
                            this.buildTreeNode(node, all, dtm);
                        } else {
                            this.buildTreeNode(node, this.sorter.sort(children), dtm);
                        }
                    } else {
                        this.buildEmptyNode(node);
                    }
                    Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
                    while (j.hasNext()) {
                        this.setExpandedParent(j.next(), true);
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    TreeImageDisplay node = (TreeImageDisplay)root.getChildAt(i);
                    List children = node.getChildrenDisplay();
                    node.removeAllChildren();
                    dtm.reload(node);
                    if (!children.isEmpty()) {
                        if (node.getUserObject() instanceof ExperimenterData) {
                            ArrayList<TreeFileSet> sets = new ArrayList<TreeFileSet>();
                            ArrayList toSort = new ArrayList();
                            for (Object object : children) {
                                if (object instanceof TreeFileSet) {
                                    sets.add((TreeFileSet)object);
                                    continue;
                                }
                                toSort.add(object);
                            }
                            sets.addAll(this.sorter.sort(toSort));
                            Collections.reverse(sets);
                            List all = this.prepareSortedList(sets);
                            this.buildTreeNode(node, all, dtm);
                        } else {
                            this.buildTreeNode(node, this.sorter.sort(children), dtm);
                        }
                    } else {
                        this.buildEmptyNode(node);
                    }
                    Iterator<TreeImageDisplay> j = this.nodesToReset.iterator();
                    while (j.hasNext()) {
                        this.setExpandedParent(j.next(), true);
                    }
                }
            }
        }
    }

    void onStateChanged(boolean b) {
        this.model.getParentModel().onComponentStateChange(b);
    }

    void onComponentStateChange(boolean b) {
        this.treeDisplay.setEnabled(b);
    }

    void setNullSelectedNode() {
        if (this.getTreeRoot() != null) {
            this.treeDisplay.setSelectionRow(-1);
        }
    }

    boolean isPartialName() {
        return !this.partialButton.isSelected();
    }

    void removeTreePaths(List paths) {
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            this.treeDisplay.removeSelectionPath((TreePath)j.next());
        }
    }

    void setExperimenterData(Set nodes, TreeImageDisplay expNode) {
        Iterator<Object> i;
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        expNode.removeAllChildren();
        expNode.removeAllChildrenDisplay();
        expNode.setChildrenLoaded(true);
        dtm.reload(expNode);
        if (nodes.size() > 0) {
            boolean createFolder = true;
            i = nodes.iterator();
            TreeFileSet n = null;
            HashSet<TreeImageDisplay> toKeep = new HashSet<TreeImageDisplay>();
            while (i.hasNext()) {
                TreeImageDisplay node = (TreeImageDisplay)i.next();
                if (node instanceof TreeFileSet) {
                    int type = ((TreeFileSet)node).getType();
                    if (type == 4 || type == 5) {
                        List l = node.getChildrenDisplay();
                        if (l.size() <= 0) continue;
                        createFolder = false;
                        n = (TreeFileSet)node.copy();
                        n.setChildrenLoaded(true);
                        expNode.addChildDisplay(n);
                        this.expandNode(n);
                        continue;
                    }
                    toKeep.add(node);
                    expNode.addChildDisplay(node);
                    continue;
                }
                toKeep.add(node);
                expNode.addChildDisplay(node);
            }
            List sorted = this.prepareSortedList(this.sorter.sort(toKeep));
            if (n != null) {
                sorted.add(n);
            }
            this.buildTreeNode(expNode, sorted, (DefaultTreeModel)this.treeDisplay.getModel());
            if (createFolder) {
                switch (this.model.getBrowserType()) {
                    case 2: {
                        if (n != null) break;
                        this.createTagsElements(expNode);
                        break;
                    }
                    case 0: {
                        this.buildOrphanImagesNode(expNode);
                    }
                }
            }
        } else {
            switch (this.model.getBrowserType()) {
                case 2: {
                    this.createTagsElements(expNode);
                    break;
                }
                case 0: {
                    this.buildOrphanImagesNode(expNode);
                    break;
                }
                default: {
                    expNode.setExpanded(false);
                    this.buildEmptyNode(expNode);
                }
            }
        }
        i = this.nodesToReset.iterator();
        while (i.hasNext()) {
            this.setExpandedParent((TreeImageDisplay)i.next(), true);
        }
        TreeImageDisplay root = this.getTreeRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            TreeImageDisplay element = (TreeImageDisplay)root.getChildAt(j);
            Object ho = element.getUserObject();
            if (!(ho instanceof GroupData) || !element.isExpanded()) continue;
            this.expandNode(element);
            List children = element.getChildrenDisplay();
            if (children == null) continue;
            for (TreeImageDisplay child : children) {
                if (!child.isExpanded()) continue;
                this.expandNode(child);
            }
        }
    }

    void setGroups(Set nodes, List expanded) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay root = this.getTreeRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        root.setChildrenLoaded(true);
        root.setExpanded(true);
        dtm.reload();
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                root.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(root, this.prepareSortedList(this.sorter.sort(nodes)), dtm);
            i = nodes.iterator();
            while (i.hasNext()) {
                ((TreeImageDisplay)i.next()).setExpanded(false);
            }
            if (expanded != null && expanded.size() > 0) {
                for (TreeImageDisplay display : nodes) {
                    GroupData g;
                    Object ho = display.getUserObject();
                    if (!(ho instanceof GroupData) || !expanded.contains((g = (GroupData)ho).getId())) continue;
                    this.expandNode(display);
                }
            }
        }
        if (TreeViewerAgent.isAdministrator()) {
            SmartFolder folder = new SmartFolder(GroupData.class, "Experimenters w/o groups");
            this.buildEmptyNode(folder);
        }
    }

    void setCountValues(TreeImageDisplay expNode, int index, Object value) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (this.model.getBrowserType() != 2) {
            expNode.setChildrenLoaded(true);
        }
        int n = expNode.getChildCount();
        ArrayList<TreeImageTimeSet> toRemove = new ArrayList<TreeImageTimeSet>();
        ArrayList<TreeImageTimeSet> toKeep = new ArrayList<TreeImageTimeSet>();
        ArrayList<DefaultMutableTreeNode> remove = new ArrayList<DefaultMutableTreeNode>();
        for (int j = 0; j < n; ++j) {
            TreeImageSet node;
            String s;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)expNode.getChildAt(j);
            Object o = childNode.getUserObject();
            if (o instanceof String && "Empty".equals(s = (String)o)) {
                remove.add(childNode);
            }
            if (childNode instanceof TreeImageTimeSet) {
                node = (TreeImageTimeSet)childNode;
                if (((TreeImageTimeSet)node).getType() != index) continue;
                if (value instanceof Integer) {
                    int vv = (Integer)value;
                    long v = node.getNumberItems();
                    node.setNumberItems(vv);
                    if (v == 0L && vv > 0) {
                        this.buildEmptyNode(node);
                        node.setChildrenLoaded(false);
                    }
                } else if (value instanceof List) {
                    List l = (List)value;
                    int total = 0;
                    for (TreeImageTimeSet child : node.getChildrenDisplay()) {
                        int number = child.countTime(l);
                        total += number;
                        if (number > 0) {
                            child.setNumberItems(number);
                            toKeep.add(child);
                            continue;
                        }
                        toRemove.add(child);
                    }
                    node.removeAllChildren();
                    node.removeChildrenDisplay(toRemove);
                    node.setNumberItems(total);
                    Iterator k = toKeep.iterator();
                    while (k.hasNext()) {
                        dtm.insertNodeInto((TreeImageTimeSet)k.next(), node, node.getChildCount());
                    }
                }
                dtm.reload(node);
                continue;
            }
            if (!(childNode instanceof TreeFileSet) || ((TreeFileSet)(node = (TreeFileSet)childNode)).getType() != index || !(value instanceof Long)) continue;
            node.setNumberItems((Long)value);
        }
        if (remove.size() > 0) {
            Iterator j = remove.iterator();
            while (j.hasNext()) {
                expNode.remove((MutableTreeNode)j.next());
                dtm.reload(expNode);
            }
        }
    }

    void refreshFolder(TreeImageDisplay expNode, Map<Integer, Set> r) {
        int browseType = this.model.getBrowserType();
        if (browseType == 5) {
            this.refreshTimeFolder(expNode, r);
        } else if (browseType == 3) {
            this.refreshFileFolder(expNode, r);
        }
    }

    void setLeavesViews(Collection nodes, TreeImageSet parent) {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        parent.removeAllChildrenDisplay();
        parent.setChildrenLoaded(Boolean.TRUE);
        if (nodes.size() != 0) {
            Iterator i = nodes.iterator();
            while (i.hasNext()) {
                parent.addChildDisplay((TreeImageDisplay)i.next());
            }
            this.buildTreeNode(parent, this.sorter.sort(nodes), dtm);
        } else {
            this.buildEmptyNode(parent);
        }
        dtm.reload(parent);
        if (!this.isPartialName()) {
            this.model.component.accept(new PartialNameVisitor(this.isPartialName()), 0);
        }
    }

    void addExperimenter(ExperimenterData experimenter, TreeImageDisplay groupNode) {
        TreeImageSet node = this.createExperimenterNode(experimenter, groupNode);
    }

    void removeExperimenter(ExperimenterData exp, TreeImageDisplay refNode) {
        List l;
        if (this.model.getBrowserType() == 6) {
            return;
        }
        if (refNode == null) {
            refNode = this.getTreeRoot();
        }
        if ((l = refNode.getChildrenDisplay()) == null || l.size() == 0) {
            return;
        }
        Iterator j = l.iterator();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeImageDisplay node = null;
        ArrayList<TreeImageDisplay> nodesToKeep = new ArrayList<TreeImageDisplay>();
        ArrayList<TreeImageDisplay> toExpand = new ArrayList<TreeImageDisplay>();
        while (j.hasNext()) {
            TreeImageDisplay element = (TreeImageDisplay)j.next();
            Object ho = element.getUserObject();
            if (!(ho instanceof ExperimenterData)) continue;
            ExperimenterData expElement = (ExperimenterData)ho;
            if (expElement.getId() == exp.getId()) {
                node = element;
                continue;
            }
            nodesToKeep.add(element);
            if (!element.isExpanded()) continue;
            toExpand.add(element);
        }
        if (node != null) {
            refNode.removeChildDisplay(node);
        }
        Iterator k = nodesToKeep.iterator();
        refNode.removeAllChildren();
        while (k.hasNext()) {
            tm.insertNodeInto((TreeImageSet)k.next(), refNode, refNode.getChildCount());
        }
        tm.reload(refNode);
        k = toExpand.iterator();
        while (k.hasNext()) {
            this.expandNode((TreeImageSet)k.next(), false);
        }
    }

    void removeGroup(GroupData group) {
        if (this.model.getBrowserType() == 6) {
            return;
        }
        TreeImageDisplay root = this.getTreeRoot();
        List l = root.getChildrenDisplay();
        if (l == null || l.size() == 0) {
            return;
        }
        Iterator j = l.iterator();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        ArrayList<TreeImageDisplay> nodesToKeep = new ArrayList<TreeImageDisplay>();
        TreeImageDisplay node = null;
        while (j.hasNext()) {
            TreeImageDisplay element = (TreeImageDisplay)j.next();
            if (!(element.getUserObject() instanceof GroupData)) continue;
            GroupData g = (GroupData)element.getUserObject();
            if (g.getId() == group.getId()) {
                node = element;
                continue;
            }
            nodesToKeep.add(element);
        }
        if (node != null) {
            root.removeChildDisplay(node);
        }
        Iterator k = nodesToKeep.iterator();
        root.removeAllChildren();
        while (k.hasNext()) {
            tm.insertNodeInto((TreeImageSet)k.next(), root, root.getChildCount());
        }
        tm.reload();
    }

    void reActivate() {
        this.clear();
        this.treeDisplay.reset(this.model.getUserID(), TreeViewerAgent.isAdministrator());
        TreeCellRenderer renderer = (TreeCellRenderer)this.treeDisplay.getCellRenderer();
        renderer.reset(this.model.getUserID());
        if (this.model.getBrowserType() != 6) {
            ExperimenterData exp = this.model.getUserDetails();
            TreeImageDisplay node = this.buildTreeNodes(exp);
            if (this.model.isSelected() && node != null) {
                this.expandNode(node, true);
            }
        }
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload();
    }

    void clear() {
        TreeImageDisplay root = this.getTreeRoot();
        root.removeAllChildren();
        root.removeAllChildrenDisplay();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload();
    }

    void setFoundNode(TreeImageDisplay[] newSelection) {
        if (newSelection == null) {
            this.model.setSelectedDisplay(null, true);
            this.treeDisplay.clearSelection();
            this.controller.getAction(BrowserControl.DELETE).setEnabled(false);
        } else {
            TreePath[] paths = new TreePath[newSelection.length];
            for (int i = 0; i < newSelection.length; ++i) {
                paths[i] = new TreePath(newSelection[i].getPath());
            }
            this.treeDisplay.setSelectionPaths(paths);
        }
        this.treeDisplay.repaint();
    }

    void loadFile(TreeImageDisplay display) {
        display.removeAllChildren();
        display.removeAllChildrenDisplay();
        display.setChildrenLoaded(Boolean.TRUE);
        display.setExpanded(true);
        this.transformDirectory((TreeImageSet)display);
        this.buildTreeNode(display, this.prepareSortedList(this.sorter.sort(display.getChildrenDisplay())), (DefaultTreeModel)this.treeDisplay.getModel());
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload(display);
    }

    void loadFileSystem(TreeImageDisplay expNode) {
        if (this.model.getBrowserType() != 4) {
            return;
        }
        this.setExperimenterData(this.createFileSystemExplorer(expNode), expNode);
    }

    void reloadContainer(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        node.removeAllChildren();
        node.removeAllChildrenDisplay();
        node.setChildrenLoaded(Boolean.FALSE);
        this.buildEmptyNode(node);
        this.treeDisplay.collapsePath(new TreePath(node.getPath()));
        this.treeDisplay.expandPath(new TreePath(node.getPath()));
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.reload(node);
    }

    void reloadNode(TreeImageDisplay node) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        if (node == null) {
            tm.reload();
        } else {
            tm.reload(node);
        }
    }

    void expandNode(TreeImageDisplay node, boolean withListener) {
        if (node == null) {
            return;
        }
        node.setExpanded(true);
        if (withListener) {
            this.treeDisplay.expandPath(new TreePath(node.getPath()));
        } else {
            this.treeDisplay.removeTreeExpansionListener(this.listener);
            this.treeDisplay.expandPath(new TreePath(node.getPath()));
            this.treeDisplay.addTreeExpansionListener(this.listener);
        }
    }

    void expandNode(TreeImageDisplay node) {
        this.expandNode(node, false);
    }

    void addComponent(JComponent component) {
        if (this.bottomComponent != null) {
            this.remove(this.bottomComponent);
        }
        this.bottomComponent = component;
        if (component != null) {
            this.add((Component)this.bottomComponent, "South");
        }
        this.revalidate();
        this.repaint();
    }

    void setUserGroup(List<GroupData> groups) {
        if (groups == null || groups.size() == 0) {
            return;
        }
        ExperimenterData exp = this.model.getUserDetails();
        Iterator<GroupData> i = groups.iterator();
        while (i.hasNext()) {
            TreeImageSet node = this.createGroup(i.next());
            node = this.createExperimenterNode(exp, node);
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        dtm.reload();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("dragged".equals(name)) {
            if (!TreeViewerAgent.canCreate()) {
                return;
            }
            ObjectToTransfer transfer = (ObjectToTransfer)evt.getNewValue();
            int action = 401;
            if (transfer.getDropAction() == 1) {
                action = 400;
            }
            this.model.transfer(transfer.getTarget(), transfer.getNodes(), action);
        }
    }
}

