/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.BrowserVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;

public class ExperimenterVisitor
extends BrowserVisitor {
    private List<TreeImageDisplay> nodes;
    private long userID;
    private Collection<Long> groupIDs;
    private boolean groupOnly;

    public ExperimenterVisitor(Browser model, long groupID) {
        super(model);
        this.groupOnly = true;
        this.groupIDs = new ArrayList<Long>();
        if (groupID >= 0L) {
            this.groupIDs.add(groupID);
        }
        this.nodes = new ArrayList<TreeImageDisplay>();
    }

    public ExperimenterVisitor(Browser model, long userID, long groupID) {
        super(model);
        this.userID = userID;
        this.groupIDs = new ArrayList<Long>();
        if (groupID >= 0L) {
            this.groupIDs.add(groupID);
        }
        this.nodes = new ArrayList<TreeImageDisplay>();
    }

    public ExperimenterVisitor(Browser model, long userID, Collection<Long> groupIDs) {
        super(model);
        this.userID = userID;
        if (groupIDs == null) {
            groupIDs = new ArrayList<Long>();
        }
        this.groupIDs = groupIDs;
        this.nodes = new ArrayList<TreeImageDisplay>();
    }

    public List<TreeImageDisplay> getNodes() {
        return this.nodes;
    }

    @Override
    public void visit(TreeImageNode node) {
    }

    @Override
    public void visit(TreeImageSet node) {
        Object ho = node.getUserObject();
        if (ho instanceof ExperimenterData && !this.groupOnly) {
            if (this.userID < 0L) {
                this.nodes.add(node);
            } else if (this.userID == ((ExperimenterData)ho).getId()) {
                if (this.groupIDs.size() == 0) {
                    this.nodes.add(node);
                } else {
                    TreeImageDisplay parent = node.getParentDisplay();
                    Object pho = parent.getUserObject();
                    if (pho instanceof GroupData && this.groupIDs.contains(((GroupData)pho).getId())) {
                        this.nodes.add(node);
                    }
                }
            }
        } else if (ho instanceof GroupData && this.groupOnly) {
            if (this.groupIDs.contains(((GroupData)ho).getId())) {
                this.nodes.add(node);
            } else if (this.groupIDs.size() == 0) {
                this.nodes.add(node);
            }
        }
    }
}

