/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.SelectionWizardUI;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class DataObjectListCellRenderer
extends DefaultListCellRenderer {
    public static final Color NEW_FOREGROUND_COLOR = Color.red;
    private static final Icon DATASET_ICON;
    private static final Icon FILE_ICON;
    private static final Icon TAG_ICON;
    private static final Icon TAG_SET_ICON;
    private static final Icon OWNER_ICON;
    private static final Icon FILE_TEXT_ICON;
    private static final Icon FILE_PDF_ICON;
    private static final Icon FILE_HTML_ICON;
    private static final Icon FILE_PPT_ICON;
    private static final Icon FILE_WORD_ICON;
    private static final Icon FILE_EXCEL_ICON;
    private static final Icon FILE_XML_ICON;
    private static final Icon FILE_EDITOR_ICON;
    private static final Icon EDITOR_EXPERIMENT_ICON;
    private static final Icon GROUP_ICON;
    private static final Icon ONTOLOGY_ICON;
    private static final Icon TAG_OTHER_OWNER_ICON;
    private static final Icon TAG_SET_OTHER_OWNER_ICON;
    private static final Icon GROUP_PRIVATE_ICON;
    private static final Icon GROUP_READ_ONLY_ICON;
    private static final Icon GROUP_READ_LINK_ICON;
    private static final Icon GROUP_READ_WRITE_ICON;
    private static final Icon GROUP_PUBLIC_READ_ICON;
    private static final Icon GROUP_PUBLIC_READ_WRITE_ICON;
    private ExperimenterData currentUser;
    private Collection immutable;
    private SelectionWizardUI model;

    private void createTooltip(ExperimenterData exp) {
        this.setToolTipText("Owner: " + EditorUtil.formatExperimenter(exp));
    }

    private boolean isImmutable(Object value) {
        if (CollectionUtils.isEmpty((Collection)this.immutable)) {
            return false;
        }
        if (!(value instanceof DataObject)) {
            return false;
        }
        Iterator i = this.immutable.iterator();
        long id = ((DataObject)value).getId();
        if (id < 0L) {
            return false;
        }
        while (i.hasNext()) {
            Object object = i.next();
            if (!object.getClass().equals(value.getClass()) || ((DataObject)object).getId() != id) continue;
            return !this.model.isAddedNode(value);
        }
        return false;
    }

    private String getTagName(TagAnnotationData tag) {
        String v = this.model.getGroupName(tag.getGroupId());
        if (v == null) {
            return tag.getTagValue();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(tag.getTagValue());
        buffer.append(" [");
        buffer.append(v);
        buffer.append("]");
        return buffer.toString();
    }

    DataObjectListCellRenderer(ExperimenterData currentUser, SelectionWizardUI model) {
        this.model = model;
        this.currentUser = currentUser;
    }

    void setImmutableElements(Collection immutable) {
        this.immutable = immutable;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        block35: {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)value;
                this.setText(this.getTagName(tag));
                String ns = tag.getNameSpace();
                if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                    if (this.currentUser != null) {
                        try {
                            ExperimenterData exp = tag.getOwner();
                            this.createTooltip(exp);
                            if (exp.getId() == this.currentUser.getId()) {
                                this.setIcon(TAG_SET_ICON);
                                break block35;
                            }
                            this.setIcon(TAG_SET_OTHER_OWNER_ICON);
                        }
                        catch (Exception e) {
                            if (tag.getId() < 0L) {
                                this.createTooltip(this.currentUser);
                            } else {
                                this.createTooltip(null);
                            }
                            this.setIcon(TAG_SET_ICON);
                        }
                    } else {
                        this.createTooltip(null);
                        this.setIcon(TAG_SET_ICON);
                    }
                } else if (this.currentUser != null) {
                    try {
                        ExperimenterData exp = tag.getOwner();
                        this.createTooltip(exp);
                        if (exp.getId() == this.currentUser.getId()) {
                            this.setIcon(TAG_ICON);
                            break block35;
                        }
                        this.setIcon(TAG_OTHER_OWNER_ICON);
                    }
                    catch (Exception e) {
                        if (tag.getId() < 0L) {
                            this.createTooltip(this.currentUser);
                        } else {
                            this.createTooltip(null);
                        }
                        this.setIcon(TAG_ICON);
                    }
                } else {
                    this.createTooltip(null);
                    this.setIcon(TAG_ICON);
                }
            } else if (value instanceof FileAnnotationData) {
                FileAnnotationData fad = (FileAnnotationData)value;
                this.setText(fad.getFileName());
                String format = fad.getFileFormat();
                Icon icon = FILE_ICON;
                icon = "pdf".equals(format) ? FILE_PDF_ICON : ("txt".equals(format) || "csv".equals(format) ? FILE_TEXT_ICON : ("html".equals(format) || "htm".equals(format) ? FILE_HTML_ICON : ("ppt".equals(format) || "pps".equals(format) || "pptx".equals(format) ? FILE_PPT_ICON : ("doc".equals(format) || "docx".equals(format) ? FILE_WORD_ICON : ("xls".equals(format) ? FILE_EXCEL_ICON : ("xml".equals(format) || "rtf".equals(format) ? FILE_XML_ICON : FILE_ICON))))));
                this.setIcon(icon);
            } else if (value instanceof TermAnnotationData) {
                TermAnnotationData term = (TermAnnotationData)value;
                this.setText(term.getTerm());
                this.setIcon(ONTOLOGY_ICON);
            } else if (value instanceof DatasetData) {
                DatasetData d = (DatasetData)value;
                this.setText(d.getName());
                this.setIcon(DATASET_ICON);
            } else if (value instanceof GroupData) {
                GroupData g = (GroupData)value;
                this.setText(g.getName());
                Icon icon = GROUP_ICON;
                switch (g.getPermissions().getPermissionsLevel()) {
                    case 0: {
                        icon = GROUP_PRIVATE_ICON;
                        break;
                    }
                    case 1: {
                        icon = GROUP_READ_ONLY_ICON;
                        break;
                    }
                    case 2: {
                        icon = GROUP_READ_LINK_ICON;
                        break;
                    }
                    case 3: {
                        icon = GROUP_READ_WRITE_ICON;
                        break;
                    }
                    case 4: {
                        icon = GROUP_PUBLIC_READ_ICON;
                        break;
                    }
                    case 5: {
                        icon = GROUP_PUBLIC_READ_WRITE_ICON;
                    }
                }
                this.setIcon(icon);
            } else if (value instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)value;
                this.setText(EditorUtil.formatExperimenter(exp));
                this.setIcon(OWNER_ICON);
            }
        }
        this.setEnabled(!this.isImmutable(value));
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        DATASET_ICON = icons.getIcon(45);
        FILE_ICON = icons.getIcon(94);
        TAG_ICON = icons.getIcon(64);
        TAG_SET_ICON = icons.getIcon(65);
        OWNER_ICON = icons.getIcon(42);
        FILE_TEXT_ICON = icons.getIcon(102);
        FILE_PDF_ICON = icons.getIcon(101);
        FILE_HTML_ICON = icons.getIcon(108);
        FILE_PPT_ICON = icons.getIcon(106);
        FILE_WORD_ICON = icons.getIcon(104);
        FILE_EXCEL_ICON = icons.getIcon(105);
        FILE_XML_ICON = icons.getIcon(107);
        FILE_EDITOR_ICON = icons.getIcon(103);
        EDITOR_EXPERIMENT_ICON = icons.getIcon(117);
        GROUP_ICON = icons.getIcon(137);
        GROUP_PRIVATE_ICON = icons.getIcon(141);
        GROUP_READ_ONLY_ICON = icons.getIcon(142);
        GROUP_READ_LINK_ICON = icons.getIcon(143);
        GROUP_READ_WRITE_ICON = icons.getIcon(154);
        GROUP_PUBLIC_READ_ICON = icons.getIcon(144);
        GROUP_PUBLIC_READ_WRITE_ICON = icons.getIcon(144);
        ONTOLOGY_ICON = icons.getIcon(149);
        TAG_OTHER_OWNER_ICON = icons.getIcon(88);
        TAG_SET_OTHER_OWNER_ICON = icons.getIcon(136);
    }
}

