/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.SelectionTable;
import org.openmicroscopy.shoola.util.ui.IconManager;

class SelectionTableRenderer
extends DefaultTableCellRenderer {
    private static Icon PRIVATE;
    private static Icon READ_GROUP;
    private static Icon READ_LINK;
    private static Icon READ_WRITE;
    private static Icon PUBLIC;
    private SelectionTable model;

    private void setGroupIcon(GroupData group) {
        switch (this.model.getLevel(group)) {
            case 0: {
                this.setIcon(PRIVATE);
                break;
            }
            case 1: {
                this.setIcon(READ_GROUP);
                break;
            }
            case 2: {
                this.setIcon(READ_LINK);
                break;
            }
            case 3: {
                this.setIcon(READ_WRITE);
                break;
            }
            case 4: {
                this.setIcon(PUBLIC);
            }
        }
    }

    SelectionTableRenderer(SelectionTable model) {
        this.model = model;
    }

    SelectionTableRenderer(Icon icon) {
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        DefaultTableModel dtm = (DefaultTableModel)table.getModel();
        if (column == 0) {
            Object element = dtm.getValueAt(row, column);
            if (element instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)element;
                this.setText(EditorUtil.formatExperimenter(exp));
            } else if (element instanceof GroupData) {
                GroupData group = (GroupData)element;
                this.setText(group.getName());
                this.setGroupIcon(group);
            }
        }
        return this;
    }

    static {
        IconManager icons = IconManager.getInstance();
        PRIVATE = icons.getIcon(141);
        READ_GROUP = icons.getIcon(142);
        READ_LINK = icons.getIcon(143);
        READ_WRITE = icons.getIcon(154);
        PUBLIC = icons.getIcon(144);
    }
}

