/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class DoubleEntry
extends Entry {
    private Double value;

    DoubleEntry() {
    }

    @Override
    protected void setContent(Node node) throws ConfigException {
        String cfgVal = null;
        try {
            cfgVal = node.getFirstChild().getNodeValue();
            this.value = new Double(cfgVal);
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse double entry, name: " + this.getName() + ".", dex);
        }
        catch (NumberFormatException nfe) {
            this.rethrow(cfgVal + " is not a valid double, entry name: " + this.getName() + ".", nfe);
        }
    }

    @Override
    Object getValue() {
        return this.value;
    }
}

