/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import omero.cmd.CmdCallbackI;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.Response;
import omero.gateway.SecurityContext;
import omero.gateway.facility.DataManagerFacility;
import omero.gateway.facility.ROIFacility;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROIData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ROIFolderSaver
extends BatchCallTree {
    private BatchCall saveCall;
    private Map<FolderData, Collection<ROIData>> result;

    private BatchCall makeSaveCall(final SecurityContext ctx, final long imageID, long userID, final Collection<ROIData> allROIs, final Collection<ROIData> roiList, final Collection<FolderData> folders, final ROIFolderAction action) {
        return new BatchCall("save ROI"){

            @Override
            public void doCall() throws Exception {
                ROIFacility svc = ROIFolderSaver.this.context.getGateway().getFacility(ROIFacility.class);
                DataManagerFacility dm = ROIFolderSaver.this.context.getGateway().getFacility(DataManagerFacility.class);
                if (action == ROIFolderAction.ADD_TO_FOLDER) {
                    Collection<ROIData> notSelected = ROIFolderSaver.relativeComplement(roiList, allROIs);
                    if (!notSelected.isEmpty()) {
                        svc.saveROIs(ctx, imageID, notSelected);
                    }
                    ROIFolderSaver.this.result = svc.addRoisToFolders(ctx, imageID, roiList, folders);
                } else if (action == ROIFolderAction.MOVE_TO_FOLDER) {
                    Collection<ROIData> notSelected = ROIFolderSaver.relativeComplement(roiList, allROIs);
                    if (!notSelected.isEmpty()) {
                        svc.saveROIs(ctx, imageID, notSelected);
                    }
                    ROIFolderSaver.this.result = svc.addRoisToFolders(ctx, imageID, roiList, folders, true);
                } else if (action == ROIFolderAction.REMOVE_FROM_FOLDER) {
                    svc.removeRoisFromFolders(ctx, imageID, roiList, folders);
                } else if (action == ROIFolderAction.CREATE_FOLDER) {
                    ROIFolderSaver.this.result = new HashMap<FolderData, Collection<ROIData>>();
                    for (FolderData folder : folders) {
                        ROIFolderSaver.this.result.put((FolderData)dm.saveAndReturnObject(ctx, folder), Collections.EMPTY_LIST);
                    }
                } else if (action == ROIFolderAction.DELETE_FOLDER) {
                    CmdCallbackI cb = dm.deleteFolders(ctx, folders, false, false);
                    Response res = cb.loop(20, 500L);
                    if (res instanceof GraphException) {
                        GraphException ge = (GraphException)res;
                        throw new Exception("Couldn't delete folders: " + ge.message);
                    }
                    if (res instanceof ERR) {
                        throw new Exception("Couldn't delete folders");
                    }
                }
                if (ROIFolderSaver.this.result == null) {
                    ROIFolderSaver.this.result = Collections.EMPTY_MAP;
                }
            }
        };
    }

    private static Collection<ROIData> relativeComplement(Collection<ROIData> coll1, Collection<ROIData> coll2) {
        if (CollectionUtils.isEmpty(coll1)) {
            return coll2;
        }
        if (CollectionUtils.isEmpty(coll2)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ROIData> result = new ArrayList<ROIData>();
        for (ROIData t : coll2) {
            boolean found = false;
            for (ROIData t2 : coll1) {
                if (!t.getUuid().equals(t2.getUuid())) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    protected void buildTree() {
        this.add(this.saveCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ROIFolderSaver(SecurityContext ctx, long imageID, long userID, Collection<ROIData> allROIs, Collection<ROIData> roiList, Collection<FolderData> folders, ROIFolderAction action) {
        this.saveCall = this.makeSaveCall(ctx, imageID, userID, allROIs, roiList, folders, action);
    }

    public static enum ROIFolderAction {
        ADD_TO_FOLDER,
        REMOVE_FROM_FOLDER,
        MOVE_TO_FOLDER,
        CREATE_FOLDER,
        DELETE_FOLDER;

    }
}

