/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.init;

import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.init.InitializationTask;
import org.openmicroscopy.shoola.env.init.StartupException;

public final class AgentsInit
extends InitializationTask {
    private void createAgent(AgentInfo info, int value) throws StartupException {
        if (!info.isActive()) {
            return;
        }
        try {
            Class<?> agentClass = Class.forName(info.getAgentClass());
            if (!Agent.class.isAssignableFrom(agentClass)) {
                throw new Exception(agentClass + "'s type is not Agent.");
            }
            Object agentInstance = agentClass.newInstance();
            Registry reg = this.createAgentRegistry(info.getConfigPath());
            Agent agent = (Agent)agentInstance;
            info.setAgent(agent);
            info.setRegistry(reg);
            Registry containerRegistry = this.container.getRegistry();
            if (info.isActive() && info.getNumber() == value && value == 2) {
                containerRegistry.bind("master", "OMERO.importer");
            }
            reg.bind("DataDisplay", containerRegistry.lookup("DataDisplay"));
            reg.bind("/services/DEBUGGER/emailAddress", containerRegistry.lookup("/services/DEBUGGER/emailAddress"));
        }
        catch (Exception e) {
            throw new StartupException("Couldn't create agent: " + info.getName(), e);
        }
    }

    private Registry createAgentRegistry(String configFile) throws Exception {
        String pathName = this.container.getConfigFileRelative(configFile);
        Registry agentReg = RegistryFactory.makeNew(pathName);
        Registry containerReg = this.container.getRegistry();
        RegistryFactory.linkEventBus(containerReg.getEventBus(), agentReg);
        RegistryFactory.linkLogger(containerReg.getLogger(), agentReg);
        RegistryFactory.linkIS(containerReg.getImageService(), agentReg);
        RegistryFactory.linkTaskBar(containerReg.getTaskBar(), agentReg);
        RegistryFactory.linkUserNotifier(containerReg.getUserNotifier(), agentReg);
        RegistryFactory.linkOS(containerReg.getDataService(), agentReg);
        RegistryFactory.linkMS(containerReg.getMetadataService(), agentReg);
        RegistryFactory.linkAdmin(containerReg.getAdminService(), agentReg);
        RegistryFactory.linkGateway(containerReg.getGateway(), agentReg);
        return agentReg;
    }

    @Override
    String getName() {
        return "Loading Agents";
    }

    @Override
    void configure() {
    }

    @Override
    void execute() throws StartupException {
        Integer plugin;
        Registry reg = this.container.getRegistry();
        Integer v = (Integer)reg.lookup("/application/entryPoint");
        int value = 0;
        if (v != null) {
            switch (v) {
                case 0: 
                case 2: {
                    value = v;
                }
            }
        }
        List agents = (List)reg.lookup("/agents");
        Iterator i = agents.iterator();
        while (i.hasNext()) {
            this.createAgent((AgentInfo)i.next(), value);
        }
        String name = (String)this.container.getRegistry().lookup("master");
        if (name == null) {
            name = "OMERO.insight";
        }
        if ((plugin = (Integer)this.container.getRegistry().lookup("Plugin")) != null) {
            switch (plugin) {
                case 1: 
                case 3: {
                    name = "OMERO.ij";
                }
            }
        }
        this.container.getRegistry().bind("master", name);
    }

    @Override
    void rollback() {
    }
}

