/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

abstract class UserNotifierLoader
extends DSCallAdapter {
    static final String MESSAGE_RESULT = "No result returned.";
    static final String MESSAGE_RUN = "Unable to start the script.";
    protected final Registry registry;
    protected final UserNotifier viewer;
    protected final MetadataHandlerView mhView;
    protected final ImageDataView ivView;
    protected final DataHandlerView dhView;
    protected final DataManagerView dmView;
    protected final ActivityComponent activity;
    protected final SecurityContext ctx;

    UserNotifierLoader(UserNotifier viewer, Registry registry, SecurityContext ctx, ActivityComponent activity) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.activity = activity;
        this.viewer = viewer;
        this.ctx = ctx;
        this.registry = registry;
        this.mhView = (MetadataHandlerView)registry.getDataServicesView(MetadataHandlerView.class);
        this.ivView = (ImageDataView)registry.getDataServicesView(ImageDataView.class);
        this.dhView = (DataHandlerView)registry.getDataServicesView(DataHandlerView.class);
        this.dmView = (DataManagerView)registry.getDataServicesView(DataManagerView.class);
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        if (this.activity != null) {
            this.activity.onActivityCancelled();
        }
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.onException(exc.getMessage(), exc);
    }

    protected void onException(String message, Throwable ex) {
    }

    public abstract void load();

    public abstract void cancel();
}

