/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.svc.proxy;

import java.io.File;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.openmicroscopy.shoola.svc.proxy.Request;
import org.openmicroscopy.shoola.svc.transport.TransportException;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

class MessengerFileRequest
extends Request {
    private static final String TOKEN = "token";
    private static final String READER = "file_format";
    private static final String FILE = "Filedata";
    private String token;
    private String reader;
    private File file;

    MessengerFileRequest(String token, File file, String reader) {
        this.token = token;
        if (CommonsLangUtils.isBlank(reader)) {
            reader = "unknown";
        }
        this.reader = reader;
        this.file = file;
    }

    @Override
    public HttpUriRequest marshal(String path) throws TransportException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart(FILE, (ContentBody)new FileBody(this.file, ContentType.APPLICATION_OCTET_STREAM, this.file.getName()));
        builder.addPart(TOKEN, (ContentBody)new StringBody(this.token, ContentType.TEXT_PLAIN));
        builder.addPart(READER, (ContentBody)new StringBody(this.reader, ContentType.TEXT_PLAIN));
        HttpPost request = new HttpPost(path);
        request.setEntity(builder.build());
        return request;
    }
}

