/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ClickableTooltip {
    private static final int DEFAULT_STARTUP_DELAY = 500;
    private static final int DEFAULT_SHOW_TIME = 500;
    private static final int DEFAULT_X_OFFSET = 10;
    private static final int DEFAULT_Y_OFFSET = 10;
    private static final Color LINK_COLOR = Color.BLUE;
    private static final int INSETS = 3;
    private JPopupMenu popupMenu;
    private JComponent component;
    private Point location;
    private Timer showTimer;
    private Timer hideTimer;

    public ClickableTooltip(String text, Action action) {
        this(text, action, 500, 500);
    }

    public ClickableTooltip(String text, final Action action, int startupDelay, int showTime) {
        Color c = UIUtilities.TOOLTIP_COLOR;
        FontUIResource f = (FontUIResource)UIManager.get("ToolTip.font");
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setLayout(new BoxLayout(this.popupMenu, 3));
        this.popupMenu.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.popupMenu.setBackground(c);
        this.popupMenu.setFont(f);
        if (text != null) {
            JLabel desc = new JLabel(text);
            desc.setBackground(c);
            desc.setFont(f);
            this.popupMenu.add(desc);
        }
        final JLabel label = new JLabel();
        label.setForeground(LINK_COLOR);
        label.setBackground(c);
        label.setFont(f);
        label.setText((String)action.getValue("Name"));
        label.addMouseListener(new MouseAdapter(){
            Cursor defaultCursor = null;

            @Override
            public void mouseReleased(MouseEvent e) {
                action.actionPerformed(new ActionEvent(this, -1, (String)action.getValue("ActionCommandKey")));
                ClickableTooltip.this.popupMenu.setVisible(false);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.defaultCursor = label.getCursor();
                label.setCursor(Cursor.getPredefinedCursor(12));
                ClickableTooltip.this.hideTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.defaultCursor != null) {
                    label.setCursor(this.defaultCursor);
                }
                ClickableTooltip.this.hideTimer.restart();
            }
        });
        this.popupMenu.add(label);
        this.showTimer = new Timer(startupDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClickableTooltip.this.popupMenu.show(ClickableTooltip.this.component, ClickableTooltip.this.location.x, ClickableTooltip.this.location.y);
                ClickableTooltip.this.showTimer.stop();
            }
        });
        this.hideTimer = new Timer(startupDelay + showTime, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClickableTooltip.this.popupMenu.setVisible(false);
                ClickableTooltip.this.hideTimer.stop();
            }
        });
    }

    public void attach(JComponent component) {
        this.attach(component, 10, 10);
    }

    public void attach(final JComponent component, final int xOffset, final int yOffset) {
        this.component = component;
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ClickableTooltip.this.location = e.getPoint();
                ClickableTooltip.this.location.translate(xOffset, yOffset);
                ClickableTooltip.this.showTimer.restart();
                ClickableTooltip.this.hideTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ClickableTooltip.this.showTimer.stop();
                ClickableTooltip.this.hideTimer.restart();
            }
        });
        this.popupMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ClickableTooltip.this.hideTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Rectangle componentBounds = new Rectangle(component.getLocationOnScreen(), new Dimension(component.getWidth(), component.getHeight()));
                if (!componentBounds.contains(e.getLocationOnScreen())) {
                    ClickableTooltip.this.hideTimer.restart();
                }
            }
        });
    }
}

