/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MagnificationComponent
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String MAGNIFICATION_PROPERTY = "magnification";
    public static final String MAGNIFICATION_UPDATE_PROPERTY = "magnificationUpdate";
    public static final double MINIMUM = 0.1;
    public static final double MAXIMUM = 2.0;
    public static final double DEFAULT = 1.0;
    private static final String ZOOM_OUT_TEXT = "Zoom out";
    private static final String ZOOM_IN_TEXT = "Zoom in";
    private static final String ZOOM_FIT_TEXT = "Actual size";
    public static final int ZOOM_OUT = 0;
    public static final int ZOOM_IN = 1;
    public static final int ZOOM_ACTUAL_SIZE = 2;
    private static final double INCREMENT = 0.1;
    private JButton zoomOut;
    private JButton zoomIn;
    private JButton actualSize;
    private double min;
    private double max;
    private double originalValue;
    private double currentValue;

    private void setMagnification(boolean increment) {
        double v = this.currentValue;
        if (increment) {
            this.currentValue += 0.1;
            if (this.currentValue > this.max) {
                this.currentValue = this.max;
            }
        } else {
            this.currentValue -= 0.1;
            if (this.currentValue < this.min) {
                this.currentValue = this.min;
            }
        }
        this.firePropertyChange(MAGNIFICATION_PROPERTY, v, this.currentValue);
    }

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.zoomOut = new JButton(icons.getIcon(135));
        this.zoomOut.setToolTipText(ZOOM_OUT_TEXT);
        this.zoomOut.setActionCommand("0");
        this.zoomOut.addActionListener(this);
        UIUtilities.unifiedButtonLookAndFeel(this.zoomOut);
        this.zoomIn = new JButton(icons.getIcon(134));
        this.zoomIn.setToolTipText(ZOOM_IN_TEXT);
        this.zoomIn.setActionCommand("1");
        this.zoomIn.addActionListener(this);
        UIUtilities.unifiedButtonLookAndFeel(this.zoomIn);
        this.actualSize = new JButton(icons.getIcon(133));
        this.actualSize.setToolTipText(ZOOM_FIT_TEXT);
        this.actualSize.setActionCommand("2");
        this.actualSize.addActionListener(this);
        UIUtilities.unifiedButtonLookAndFeel(this.actualSize);
    }

    private void buildGUI() {
        JToolBar bar = new JToolBar();
        bar.setBorder(null);
        bar.setFloatable(false);
        bar.add(this.zoomOut);
        bar.add(this.zoomIn);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.actualSize);
        this.add(bar);
    }

    public MagnificationComponent() {
        this(0.1, 2.0, 1.0);
    }

    public MagnificationComponent(double min, double max) {
        this(min, max, 1.0);
    }

    public MagnificationComponent(double min, double max, double value) {
        if (min <= 0.0) {
            min = 0.1;
        }
        if (max < 1.0) {
            max = 1.0;
        }
        this.max = max;
        this.min = min;
        this.setOriginal(value);
        this.initComponents();
        this.buildGUI();
    }

    public void setOriginal(double value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        this.currentValue = this.originalValue = value;
    }

    public double getMagnification() {
        return this.currentValue;
    }

    public void setButtonIcon(int index, Icon icon) {
        if (icon == null) {
            return;
        }
        switch (index) {
            case 2: {
                this.actualSize.setIcon(icon);
                break;
            }
            case 1: {
                this.zoomIn.setIcon(icon);
                break;
            }
            case 0: {
                this.zoomOut.setIcon(icon);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.setMagnification(true);
                break;
            }
            case 0: {
                this.setMagnification(false);
                break;
            }
            case 2: {
                double v = this.currentValue;
                this.currentValue = this.originalValue;
                this.firePropertyChange(MAGNIFICATION_PROPERTY, v, this.currentValue);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (MAGNIFICATION_UPDATE_PROPERTY.equals(name)) {
            this.currentValue = (Double)evt.getNewValue();
        }
    }
}

