/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.RatingComponent;

class RatingCanvas
extends JPanel
implements MouseMotionListener {
    static final int SPACE = 2;
    private RatingComponent model;
    private List<Rectangle> stars;
    private MouseAdapter handler;
    private boolean dragging;
    private boolean pressed;

    private void handleClick(Point p) {
        Rectangle r;
        if (!this.isEnabled()) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < this.stars.size(); ++i) {
            r = this.stars.get(i);
            if (!r.contains(p)) continue;
            found = true;
            this.model.setValue(i + 1);
            break;
        }
        if (found) {
            return;
        }
        r = this.stars.get(0);
        if (p.x < r.x) {
            this.model.setValue(0);
            return;
        }
        r = this.stars.get(this.stars.size() - 1);
        if (p.x > r.x + r.width) {
            this.model.setValue(5);
        }
    }

    private void installListeners() {
        this.addMouseListener(this.handler);
        this.addMouseMotionListener(this);
    }

    private void uninstallListeners() {
        this.removeMouseListener(this.handler);
        this.removeMouseMotionListener(this);
    }

    private void handleMouseReleased(Point p) {
        if (this.dragging || this.pressed) {
            this.handleClick(p);
            this.dragging = false;
            this.pressed = false;
        }
    }

    RatingCanvas(RatingComponent model) {
        if (model == null) {
            throw new IllegalArgumentException("No model");
        }
        this.model = model;
        this.setDoubleBuffered(true);
        this.stars = new ArrayList<Rectangle>();
        this.handler = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RatingCanvas.this.handleMouseReleased(e.getPoint());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RatingCanvas.this.pressed = true;
                RatingCanvas.this.handleMouseReleased(e.getPoint());
            }
        };
        this.installListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.installListeners();
        } else {
            this.uninstallListeners();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int h;
        int w;
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        g.setColor(this.getBackground());
        int x = 0;
        List<Image> l = this.model.getPlus();
        Iterator<Image> i = l.iterator();
        this.stars.clear();
        while (i.hasNext()) {
            Image img = i.next();
            w = img.getWidth(null);
            h = img.getHeight(null);
            this.stars.add(new Rectangle(x, 0, w, h));
            g2D.drawImage(img, x, 0, w, h, null);
            x += w + 2;
        }
        l = this.model.getMinus();
        for (Image img : l) {
            w = img.getWidth(null);
            h = img.getHeight(null);
            this.stars.add(new Rectangle(x, 0, w, h));
            g2D.drawImage(img, x, 0, w, h, null);
            x += w + 2;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

