/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colour;

import java.awt.Color;

public class HSV {
    private float h;
    private float s;
    private float v;
    private float a;

    private float findMin(float a, float b, float c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= a && b <= c) {
            return b;
        }
        return c;
    }

    private float findMax(float a, float b, float c) {
        if (a >= b && a >= c) {
            return a;
        }
        if (b >= a && b >= c) {
            return b;
        }
        return c;
    }

    public HSV() {
        this.h = 0.0f;
        this.s = 0.0f;
        this.v = 0.0f;
        this.a = 0.0f;
    }

    public HSV(HSV c) {
        this.h = c.h;
        this.s = c.s;
        this.v = c.v;
        this.a = c.a;
    }

    public HSV(Color c) {
        this.fromColor(c);
    }

    public HSV(float hs, float ss, float vs, float as) {
        this.h = hs;
        this.s = ss;
        this.v = vs;
        this.a = as;
    }

    public HSV(float hs, float ss, float vs) {
        this.h = hs;
        this.s = ss;
        this.v = vs;
        this.a = 1.0f;
    }

    public void fromColor(Color c) {
        float max;
        float min = this.findMin(c.getRed(), c.getGreen(), c.getBlue());
        this.v = max = this.findMax(c.getRed(), c.getGreen(), c.getBlue());
        float delta = max - min;
        if (max != 0.0f) {
            this.s = delta / max;
        } else {
            this.v = 0.0f;
            this.s = 0.0f;
            this.h = 0.0f;
        }
        this.h = (float)c.getRed() == max ? (float)(c.getGreen() - c.getBlue()) / delta : ((float)c.getGreen() == max ? 2.0f + (float)(c.getBlue() - c.getRed()) / delta : 4.0f + (float)(c.getRed() - c.getGreen()) / delta);
        this.h *= 60.0f;
        if (this.h < 0.0f) {
            this.h += 360.0f;
        }
        this.h /= 360.0f;
        this.v /= 255.0f;
        this.a = (float)c.getAlpha() / 255.0f;
    }

    public Color toColor() {
        float b;
        float g;
        float r;
        if (this.s == 0.0f) {
            float b2;
            float g2 = b2 = this.v;
            float r2 = b2;
            return new Color(r2, g2, b2, this.a);
        }
        float hquad = this.h * 6.0f;
        int i = (int)Math.floor(hquad);
        float f = hquad - (float)i;
        float p = this.v * (1.0f - this.s);
        float q = this.v * (1.0f - this.s * f);
        float t = this.v * (1.0f - this.s * (1.0f - f));
        switch (i) {
            case 0: {
                r = this.v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = this.v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = this.v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = this.v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = this.v;
                break;
            }
            default: {
                r = this.v;
                g = p;
                b = q;
            }
        }
        return new Color(r, g, b, 1.0f);
    }

    public Color toColorA() {
        float b;
        float g;
        float r;
        if (this.s == 0.0f) {
            float b2;
            float g2 = b2 = this.v;
            float r2 = b2;
            return new Color(r2, g2, b2, this.a);
        }
        float hquad = this.h * 6.0f;
        int i = (int)Math.floor(hquad);
        float f = hquad - (float)i;
        float p = this.v * (1.0f - this.s);
        float q = this.v * (1.0f - this.s * f);
        float t = this.v * (1.0f - this.s * (1.0f - f));
        switch (i) {
            case 0: {
                r = this.v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = this.v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = this.v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = this.v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = this.v;
                break;
            }
            default: {
                r = this.v;
                g = p;
                b = q;
            }
        }
        return new Color(r, g, b, this.a);
    }

    public float getHue() {
        return this.h;
    }

    public float getSaturation() {
        return this.s;
    }

    public float getValue() {
        return this.v;
    }

    public float getAlpha() {
        return this.a;
    }

    public void setHue(float h) {
        this.h = h;
    }

    public void setSaturation(float s) {
        this.s = s;
    }

    public void setValue(float v) {
        this.v = v;
    }

    public void setAlpha(float a) {
        this.a = a;
    }
}

