/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;
import org.openmicroscopy.shoola.util.ui.graphutils.PointRenderer;

public class ScatterPlot
extends ChartObject {
    private static final int SHAPESIZE = 3;
    private DefaultXYDataset dataset;
    private List<double[][]> data;
    private List<Shape> shapes;

    private void initialize() {
        this.data = new ArrayList<double[][]>();
        this.shapes = new ArrayList<Shape>();
        this.dataset = new DefaultXYDataset();
    }

    private Ellipse2D createDefaultShape() {
        return new Ellipse2D.Double(-3.0, -3.0, 3.0, 3.0);
    }

    public ScatterPlot() {
        super("");
        this.initialize();
    }

    public ScatterPlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours, List<Shape> newShapes) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newShapes == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() && newLegends.size() != newShapes.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i), newShapes.get(i));
        }
        this.setDefaultAxis();
    }

    public ScatterPlot(String title, List<String> newLegends, List<double[][]> newData, List<Color> newColours) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size()) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i));
        }
        this.setDefaultAxis();
    }

    public int addSeries(String legend, double[][] newData, Color color, Shape shape) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.shapes.add(shape);
        this.dataset.addSeries((Comparable)((Object)legend), newData);
        return this.dataset.getSeriesCount();
    }

    public int addSeries(String legend, double[][] newData, Color color) {
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.shapes.add(this.createDefaultShape());
        this.dataset.addSeries((Comparable)((Object)legend), newData);
        return this.dataset.getSeriesCount();
    }

    @Override
    void createChart() {
        PointRenderer renderer = new PointRenderer(this.colours, this.shapes);
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)this.domainAxis, (ValueAxis)this.rangeAxis, (XYItemRenderer)renderer);
        if (this.backgroundImage != null) {
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            plot.setBackgroundImage(this.backgroundImage);
        }
        this.chart = new JFreeChart(this.title, (Plot)plot);
    }
}

