/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.slider;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

public class OneKnobSliderUI
extends BasicSliderUI {
    private static final int ARROW_SPACE = 2;
    private static final int TEXT_SPACE = 2;
    private Image thumbImage;
    private Image disabledThumbImage;
    private Image upArrowImage;
    private Image upArrowDisabledImage;
    private Image downArrowImage;
    private Image downArrowDisabledImage;
    private Image leftArrowImage;
    private Image leftArrowDisabledImage;
    private Image rightArrowImage;
    private Image rightArrowDisabledImage;
    private boolean showArrows = true;
    private Rectangle minArrowRect;
    private Rectangle maxArrowRect;
    private String endLabel;
    private boolean showEndLabel;
    private Rectangle endLabelRect;
    private int labelHeight;
    private int labelWidth;
    protected boolean isDragging;
    private int arrowHeight;
    private int arrowWidth;
    private int minArrowWidth;
    private int minArrowHeight;
    private int thumbWidth;
    private int thumbHeight;

    private void loadThumbArrowImage() {
        IconManager icons = IconManager.getInstance();
        ImageIcon img = icons.getIcon(6);
        this.thumbWidth = img.getIconWidth();
        this.thumbHeight = img.getIconHeight();
        this.thumbImage = img.getImage();
        img = icons.getIcon(7);
        this.disabledThumbImage = img.getImage();
        img = icons.getIcon(12);
        this.arrowWidth = img.getIconWidth();
        this.minArrowHeight = this.arrowHeight = img.getIconHeight();
        this.minArrowWidth = this.arrowWidth;
        this.upArrowDisabledImage = img.getImage();
        img = icons.getIcon(13);
        this.downArrowDisabledImage = img.getImage();
        img = icons.getIcon(14);
        this.leftArrowDisabledImage = img.getImage();
        img = icons.getIcon(15);
        this.rightArrowDisabledImage = img.getImage();
        img = icons.getIcon(8);
        this.upArrowImage = img.getImage();
        img = icons.getIcon(9);
        this.downArrowImage = img.getImage();
        img = icons.getIcon(10);
        this.leftArrowImage = img.getImage();
        img = icons.getIcon(11);
        this.rightArrowImage = img.getImage();
    }

    private void calculateArrowRect() {
        if (this.slider.getOrientation() == 0) {
            int offsetY = (this.trackRect.height - this.minArrowHeight) / 2 - 1;
            this.minArrowRect = new Rectangle(this.trackRect.x - (this.minArrowWidth + this.thumbWidth / 2 + 2), this.trackRect.y + offsetY, this.minArrowWidth, this.minArrowHeight);
            offsetY = (this.trackRect.height - this.arrowHeight) / 2 - 1;
            this.maxArrowRect = new Rectangle(this.trackRect.x + this.trackRect.width + 2 + this.thumbWidth / 2, this.trackRect.y + offsetY, this.arrowWidth, this.arrowHeight);
        } else {
            int offsetX = (this.trackRect.width - this.arrowWidth) / 2;
            if (this.arrowWidth != this.minArrowWidth) {
                ++offsetX;
            }
            this.maxArrowRect = new Rectangle(this.trackRect.x + offsetX, this.trackRect.y - (this.arrowHeight + this.thumbHeight / 2 + 2), this.arrowWidth, this.arrowHeight);
            offsetX = (this.trackRect.width - this.minArrowWidth) / 2;
            if (this.arrowWidth != this.minArrowWidth) {
                ++offsetX;
            }
            this.minArrowRect = new Rectangle(this.trackRect.x + offsetX, this.trackRect.y + this.trackRect.height + 2 + this.thumbHeight / 2, this.minArrowWidth, this.minArrowHeight);
        }
    }

    private void calculateEndLabelRect() {
        if (this.slider.getOrientation() == 0) {
            int offsetY = this.trackRect.height + this.labelHeight / 2 + 1;
            this.endLabelRect = new Rectangle(0, offsetY, this.labelWidth, this.labelHeight);
        } else {
            int offsetX = this.trackRect.width / 2 - this.labelWidth / 2 + 1;
            this.endLabelRect = new Rectangle(offsetX, this.trackRect.y - (this.minArrowRect.height + this.labelHeight + 2), this.labelWidth, this.labelHeight);
        }
    }

    private void paintVerticalTrack(Graphics2D g) {
        GradientPaint paint = new GradientPaint(this.trackRect.x + this.trackRect.width / 2 - 2, this.trackRect.y, UIUtilities.TRACK_GRADIENT_START, this.trackRect.x + this.trackRect.width / 2 + 2, this.trackRect.y, UIUtilities.TRACK_GRADIENT_END, false);
        g.setPaint(paint);
        g.fillRoundRect(this.trackRect.x + this.trackRect.width / 2 - 2, this.trackRect.y, 4, this.trackRect.height, 4, 4);
        g.setPaint(UIUtilities.LINE_COLOR);
        if (this.showArrows) {
            if (this.slider.isEnabled()) {
                g.drawImage(this.downArrowImage, this.minArrowRect.x, this.minArrowRect.y, this.minArrowRect.width, this.minArrowRect.height, null);
                g.drawImage(this.upArrowImage, this.maxArrowRect.x, this.maxArrowRect.y, this.maxArrowRect.width, this.maxArrowRect.height, null);
            } else {
                g.drawImage(this.downArrowDisabledImage, this.minArrowRect.x, this.minArrowRect.y, this.minArrowRect.width, this.minArrowRect.height, null);
                g.drawImage(this.upArrowDisabledImage, this.maxArrowRect.x, this.maxArrowRect.y, this.maxArrowRect.width, this.maxArrowRect.height, null);
            }
        }
        if (this.showEndLabel && this.endLabel != null) {
            g.drawString(this.endLabel, this.endLabelRect.x, this.endLabelRect.y);
        }
    }

    private void paintHorizontalTrack(Graphics2D g) {
        GradientPaint paint = new GradientPaint(0.0f, this.trackRect.y + this.thumbRect.height / 2 - 3, UIUtilities.TRACK_GRADIENT_START, 0.0f, this.trackRect.y + this.thumbRect.height / 2 + 2, UIUtilities.TRACK_GRADIENT_END, false);
        g.setPaint(paint);
        g.fillRoundRect(this.trackRect.x, this.trackRect.y + this.thumbRect.height / 2 - 3, this.trackRect.width, 4, 4, 4);
        g.setPaint(UIUtilities.LINE_COLOR);
        if (this.showArrows) {
            if (this.slider.isEnabled()) {
                g.drawImage(this.leftArrowImage, this.minArrowRect.x, this.minArrowRect.y, this.minArrowRect.width, this.minArrowRect.height, null);
                g.drawImage(this.rightArrowImage, this.maxArrowRect.x, this.maxArrowRect.y, this.maxArrowRect.width, this.maxArrowRect.height, null);
            } else {
                g.drawImage(this.leftArrowDisabledImage, this.minArrowRect.x, this.minArrowRect.y, this.minArrowRect.width, this.minArrowRect.height, null);
                g.drawImage(this.rightArrowDisabledImage, this.maxArrowRect.x, this.maxArrowRect.y, this.maxArrowRect.width, this.maxArrowRect.height, null);
            }
        }
        if (this.showEndLabel && this.endLabel != null) {
            g.drawString(this.endLabel, this.endLabelRect.x, this.endLabelRect.height);
        }
    }

    OneKnobSliderUI(OneKnobSlider slider) {
        super(slider);
        this.loadThumbArrowImage();
        this.showEndLabel = false;
        this.endLabelRect = new Rectangle();
    }

    void setEndLabel(String endLabel) {
        this.endLabel = endLabel;
        this.labelWidth = 6;
        this.labelHeight = 12;
    }

    void setShowTipLabel(boolean show) {
    }

    void setShowEndLabel(boolean show) {
        this.showEndLabel = show;
    }

    void setShowArrows(boolean isShow) {
        this.showArrows = isShow;
        this.calculateGeometry();
    }

    void setArrowsImageIcon(ImageIcon up, ImageIcon down) {
        this.setArrowsImageIcon(up, down, null, null);
    }

    void setArrowsImageIcon(ImageIcon up, ImageIcon down, ImageIcon disabledUp, ImageIcon disabledDown) {
        if (this.slider.getOrientation() == 0) {
            this.rightArrowImage = up.getImage();
            this.rightArrowDisabledImage = disabledUp != null ? disabledUp.getImage() : up.getImage();
            this.leftArrowImage = down.getImage();
            this.leftArrowDisabledImage = disabledDown != null ? disabledDown.getImage() : down.getImage();
        } else {
            this.upArrowImage = up.getImage();
            this.upArrowDisabledImage = disabledUp != null ? disabledUp.getImage() : up.getImage();
            this.downArrowImage = down.getImage();
            this.downArrowDisabledImage = disabledDown != null ? disabledDown.getImage() : down.getImage();
        }
        this.arrowWidth = up.getIconWidth();
        this.arrowHeight = up.getIconHeight();
        this.minArrowWidth = down.getIconWidth();
        this.minArrowHeight = down.getIconHeight();
        this.calculateGeometry();
    }

    boolean isShowArrows() {
        return this.showArrows;
    }

    @Override
    protected void calculateTrackBuffer() {
        super.calculateTrackBuffer();
        if (this.showArrows) {
            this.trackBuffer = this.slider.getOrientation() == 0 ? (this.arrowWidth > this.minArrowWidth ? (this.trackBuffer += this.arrowWidth + 2) : (this.trackBuffer += this.minArrowWidth + 2)) : (this.arrowHeight > this.minArrowHeight ? (this.trackBuffer += this.arrowHeight + 2) : (this.trackBuffer += this.minArrowHeight + 2));
        }
        if (this.showEndLabel) {
            this.trackBuffer = this.slider.getOrientation() == 0 ? (this.trackBuffer += this.labelWidth + 2) : (this.trackBuffer += this.labelHeight + 2);
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(this.thumbWidth, this.thumbHeight);
    }

    @Override
    public void calculateThumbSize() {
        this.thumbRect = new Rectangle(0, 0, this.thumbWidth, this.thumbHeight);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    @Override
    public void paintTrack(Graphics og) {
        if (this.slider.getOrientation() == 0) {
            this.paintHorizontalTrack((Graphics2D)og);
        } else {
            this.paintVerticalTrack((Graphics2D)og);
        }
    }

    @Override
    public void paintThumb(Graphics og) {
        Graphics2D g = (Graphics2D)og;
        if (this.slider.isEnabled()) {
            g.drawImage(this.thumbImage, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, null);
        } else {
            g.drawImage(this.disabledThumbImage, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, null);
        }
    }

    @Override
    public void calculateGeometry() {
        super.calculateGeometry();
        if (this.showArrows) {
            this.calculateArrowRect();
        }
        if (this.showEndLabel) {
            this.calculateEndLabelRect();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (this.slider.getPaintTrack() && (clip.intersects(this.trackRect) || clip.intersects(this.minArrowRect) || clip.intersects(this.maxArrowRect) || clip.intersects(this.endLabelRect))) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (this.slider.hasFocus() && clip.intersects(this.focusRect)) {
            this.paintFocus(g);
        }
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(g);
        }
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new TrackListener2();
    }

    public class TrackListener2
    extends BasicSliderUI.TrackListener {
        public TrackListener2() {
            super(OneKnobSliderUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            super.mouseReleased(event);
            if (OneKnobSliderUI.this.isDragging && OneKnobSliderUI.this.slider instanceof OneKnobSlider) {
                OneKnobSliderUI.this.isDragging = false;
                ((OneKnobSlider)OneKnobSliderUI.this.slider).onMouseReleased();
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!OneKnobSliderUI.this.slider.isEnabled()) {
                return;
            }
            OneKnobSliderUI.this.isDragging = true;
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            OneKnobSliderUI.this.scrollTimer.stop();
            if (OneKnobSliderUI.this.showArrows) {
                if (OneKnobSliderUI.this.minArrowRect.contains(this.currentMouseX, this.currentMouseY)) {
                    int value = OneKnobSliderUI.this.slider.getValue();
                    OneKnobSliderUI.this.isDragging = false;
                    if (value > OneKnobSliderUI.this.slider.getMinimum()) {
                        OneKnobSliderUI.this.slider.setValue(value - 1);
                        OneKnobSliderUI.this.slider.repaint();
                    }
                    return;
                }
                if (OneKnobSliderUI.this.maxArrowRect.contains(this.currentMouseX, this.currentMouseY)) {
                    int value = OneKnobSliderUI.this.slider.getValue();
                    OneKnobSliderUI.this.isDragging = false;
                    if (value < OneKnobSliderUI.this.slider.getMaximum()) {
                        OneKnobSliderUI.this.slider.setValue(value + 1);
                        OneKnobSliderUI.this.slider.repaint();
                    }
                    return;
                }
            }
            if (OneKnobSliderUI.this.trackRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (OneKnobSliderUI.this.slider.getOrientation()) {
                    case 0: {
                        int value = OneKnobSliderUI.this.valueForXPosition(this.currentMouseX);
                        OneKnobSliderUI.this.slider.setValue(value);
                        break;
                    }
                    case 1: {
                        int value = OneKnobSliderUI.this.valueForYPosition(this.currentMouseY);
                        OneKnobSliderUI.this.slider.setValue(value);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!OneKnobSliderUI.this.slider.isEnabled()) {
                return;
            }
            OneKnobSliderUI.this.isDragging = true;
            this.currentMouseX = event.getX();
            this.currentMouseY = event.getY();
            if (OneKnobSliderUI.this.slider.isRequestFocusEnabled()) {
                OneKnobSliderUI.this.slider.requestFocus();
            }
            if (OneKnobSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                super.mousePressed(event);
            }
            if (OneKnobSliderUI.this.showArrows) {
                if (OneKnobSliderUI.this.minArrowRect.contains(this.currentMouseX, this.currentMouseY)) {
                    int value = OneKnobSliderUI.this.slider.getValue();
                    OneKnobSliderUI.this.isDragging = false;
                    if (value > OneKnobSliderUI.this.slider.getMinimum()) {
                        OneKnobSliderUI.this.scrollListener.setScrollByBlock(false);
                        OneKnobSliderUI.this.scrollListener.setDirection(-1);
                        OneKnobSliderUI.this.slider.repaint();
                    }
                    return;
                }
                if (OneKnobSliderUI.this.maxArrowRect.contains(this.currentMouseX, this.currentMouseY)) {
                    int value = OneKnobSliderUI.this.slider.getValue();
                    OneKnobSliderUI.this.isDragging = false;
                    if (value < OneKnobSliderUI.this.slider.getMaximum()) {
                        OneKnobSliderUI.this.scrollListener.setScrollByBlock(false);
                        OneKnobSliderUI.this.scrollListener.setDirection(1);
                        OneKnobSliderUI.this.slider.repaint();
                    }
                    return;
                }
            }
            OneKnobSliderUI.this.slider.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            super.mouseDragged(event);
            OneKnobSliderUI.this.isDragging = true;
        }
    }
}

