/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tdialog;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.util.ui.tdialog.TinyDialog;

class BorderListener
implements MouseMotionListener,
MouseListener {
    private static int THICKNESS = 10;
    private TinyDialog model;

    private void setModelBounds(Rectangle bounds) {
        this.model.setBounds(bounds);
        this.model.setRestoreSize(new Dimension(bounds.width, bounds.height));
        this.model.validate();
    }

    BorderListener(TinyDialog model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
    }

    private void enter() {
        this.model.getRootPane().setCursor(Cursor.getPredefinedCursor(8));
    }

    private void exit() {
        this.model.getRootPane().setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.enter();
        this.model.getRootPane().setCursor(Cursor.getPredefinedCursor(12));
        Rectangle bounds = this.model.getBounds();
        Point p = e.getPoint();
        Dimension min = this.model.getMinimumSize();
        Dimension max = this.model.getMaximumSize();
        if (p.x < THICKNESS) {
            this.model.invalidate();
            SwingUtilities.convertPointToScreen(p, this.model.getContentPane());
            int diff = bounds.x - p.x;
            bounds.x = p.x;
            bounds.width += diff;
            if (bounds.width > min.width && bounds.width < max.width) {
                this.setModelBounds(bounds);
            }
        } else if (e.getX() > this.model.getWidth() - THICKNESS) {
            this.model.invalidate();
            bounds.width = p.x;
            if (bounds.width > min.width && bounds.width < max.width) {
                this.setModelBounds(bounds);
            }
        } else if (e.getY() < THICKNESS) {
            this.model.invalidate();
            SwingUtilities.convertPointToScreen(p, this.model.getContentPane());
            int diff = bounds.y - p.y;
            bounds.y = p.y;
            bounds.height += diff;
            if (bounds.height < max.height && bounds.height > min.height) {
                this.setModelBounds(bounds);
            }
        } else if (e.getY() > this.model.getHeight() - THICKNESS) {
            this.model.invalidate();
            bounds.height = p.y;
            if (bounds.height < max.height && bounds.height > min.height) {
                this.setModelBounds(bounds);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.enter();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.exit();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

