/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import Ice.Current;
import ome.api.ServiceInterface;
import ome.services.blitz.util.IceMethodInvoker;
import ome.services.throttling.Task;
import ome.system.OmeroContext;
import omero.util.IceMapper;
import org.springframework.util.Assert;

public class Callback
extends Task {
    private final Boolean io;
    private final Boolean db;
    private final IceMethodInvoker invoker;
    private final ServiceInterface service;
    private final Object[] args;
    private final IceMapper mapper;

    public Callback(Boolean io, Boolean db, ServiceInterface service, IceMethodInvoker invoker, Object cb, IceMapper mapper, Current current, Object ... args) {
        super(cb, current, invoker.isVoid(current));
        Assert.notNull((Object)invoker, (String)"Null invoker");
        Assert.notNull((Object)service, (String)"Null service");
        Assert.notNull((Object)args, (String)"Null argument array");
        this.io = io;
        this.db = db;
        this.service = service;
        this.invoker = invoker;
        this.args = args;
        this.mapper = mapper;
    }

    public Callback(ServiceInterface service, IceMethodInvoker invoker, IceMapper mapper, Object cb, Current current, Object ... args) {
        this(null, null, service, invoker, cb, mapper, current, args);
    }

    @Override
    public void run(OmeroContext ctx) {
        try {
            Object retVal = this.invoker.invoke(this.service, this.current, this.mapper, this.args);
            this.response(retVal, ctx);
        }
        catch (Throwable e) {
            this.exception(e, ctx);
        }
    }

    Boolean ioIntensive() {
        return this.io;
    }

    Boolean dbIntensive() {
        return this.db;
    }
}

