/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import Glacier2.CannotCreateSessionException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionLostException;
import Ice.ConnectionRefusedException;
import Ice.ConnectionTimeoutException;
import Ice.DNSException;
import Ice.ObjectNotExistException;
import Ice.SocketException;
import Ice.TimeoutException;
import Ice.UnknownException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import ome.conditions.SessionTimeoutException;
import omero.AuthenticationException;
import omero.DatabaseBusyException;
import omero.ResourceError;
import omero.SecurityViolation;
import omero.SessionException;
import omero.gateway.Gateway;
import omero.gateway.exception.ConnectionStatus;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.log.LogMessage;

public abstract class Facility {
    private static final Cache<String, Facility> cache = CacheBuilder.newBuilder().build();
    final Gateway gateway;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    Facility(Gateway gateway) {
        this.gateway = gateway;
    }

    public static <T extends Facility> T getFacility(final Class<T> type, final Gateway gateway) throws ExecutionException {
        String serverHost;
        if (AutoCloseable.class.isAssignableFrom(type)) {
            try {
                Facility facility = (Facility)type.getDeclaredConstructor(Gateway.class).newInstance(gateway);
                for (PropertyChangeListener l : gateway.getPropertyChangeListeners()) {
                    facility.addPropertyChangeListener(l);
                    facility.pcs.firePropertyChange("PROP_FACILITY_CREATED", null, type.getName());
                }
                return (T)facility;
            }
            catch (Exception e) {
                throw new ExecutionException("Can't instantiate " + type.getSimpleName(), e);
            }
        }
        try {
            serverHost = gateway.getServerHost();
        }
        catch (DSOutOfServiceException e) {
            throw new ExecutionException("Not logged in; Can't instantiate " + type.getSimpleName(), e);
        }
        return (T)((Facility)cache.get((Object)(type.getSimpleName() + ":" + serverHost), (Callable)new Callable<Facility>(){

            @Override
            public Facility call() throws Exception {
                gateway.getLogger().debug((Object)this, "Created new " + type.getSimpleName());
                Facility facility = (Facility)type.getDeclaredConstructor(Gateway.class).newInstance(gateway);
                for (PropertyChangeListener l : gateway.getPropertyChangeListeners()) {
                    facility.addPropertyChangeListener(l);
                    facility.pcs.firePropertyChange("PROP_FACILITY_CREATED", null, type.getName());
                }
                return facility;
            }
        }));
    }

    public static void clear() {
        cache.invalidateAll();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            for (PropertyChangeListener l : this.pcs.getPropertyChangeListeners()) {
                this.pcs.removePropertyChangeListener(l);
            }
        }
        this.pcs.removePropertyChangeListener(listener);
    }

    public void firePropertyChanged(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void logDebug(Object originator, String msg, Throwable t) {
        if (t != null) {
            this.gateway.getLogger().debug(originator, new LogMessage(msg, t));
        } else {
            this.gateway.getLogger().debug(originator, msg);
        }
    }

    public void logInfo(Object originator, String msg, Throwable t) {
        if (t != null) {
            this.gateway.getLogger().info(originator, new LogMessage(msg, t));
        } else {
            this.gateway.getLogger().info(originator, msg);
        }
    }

    public void logWarn(Object originator, String msg, Throwable t) {
        if (t != null) {
            this.gateway.getLogger().warn(originator, new LogMessage(msg, t));
        } else {
            this.gateway.getLogger().warn(originator, msg);
        }
    }

    public void logError(Object originator, String msg, Throwable t) {
        if (t != null) {
            this.gateway.getLogger().error(originator, new LogMessage(msg, t));
        } else {
            this.gateway.getLogger().error(originator, msg);
        }
    }

    void handleException(Object originator, Throwable t, String message) throws DSOutOfServiceException, DSAccessException {
        this.logError(originator, message, t);
        if (t instanceof DSOutOfServiceException) {
            throw (DSOutOfServiceException)t;
        }
        if (t instanceof DSAccessException) {
            throw (DSAccessException)t;
        }
        ConnectionStatus b = this.getConnectionStatus(t);
        if (b != ConnectionStatus.OK) {
            throw new DSOutOfServiceException("Connection lost.", t);
        }
        if (!this.gateway.isConnected()) {
            throw new DSOutOfServiceException("Gateway is disconnected.", t);
        }
        Throwable cause = t.getCause();
        if (cause instanceof SecurityViolation) {
            String s = "For security reasons, cannot access data. \n";
            throw new DSAccessException(s + message, cause);
        }
        if (cause instanceof SessionException) {
            String s = "Session is not valid. \n";
            throw new DSOutOfServiceException(s + message, cause);
        }
        if (cause instanceof AuthenticationException) {
            String s = "Cannot initialize the session. \n";
            throw new DSOutOfServiceException(s + message, cause);
        }
        if (cause instanceof ResourceError) {
            String s = "Fatal error. Please contact the administrator. \n";
            throw new DSOutOfServiceException(s + message, t);
        }
        throw new DSAccessException("Cannot access data. \n" + message, t);
    }

    private ConnectionStatus getConnectionStatus(Throwable e) {
        DSOutOfServiceException dso;
        if (e instanceof DSOutOfServiceException && (dso = (DSOutOfServiceException)e).getConnectionStatus() != null) {
            return dso.getConnectionStatus();
        }
        Throwable cause = e.getCause();
        if (cause instanceof ConnectionLostException || e instanceof ConnectionLostException || cause instanceof SessionTimeoutException || e instanceof SessionTimeoutException || cause instanceof TimeoutException || e instanceof TimeoutException || cause instanceof ObjectNotExistException || e instanceof ObjectNotExistException || cause instanceof DNSException || e instanceof DNSException) {
            return ConnectionStatus.LOST_CONNECTION;
        }
        if (cause instanceof CommunicatorDestroyedException || e instanceof CommunicatorDestroyedException) {
            return ConnectionStatus.DESTROYED_CONNECTION;
        }
        if (cause instanceof SocketException || e instanceof SocketException || e instanceof UnknownHostException) {
            return ConnectionStatus.NETWORK;
        }
        if (cause instanceof ConnectionRefusedException || e instanceof ConnectionRefusedException || cause instanceof ConnectionTimeoutException || e instanceof ConnectionTimeoutException || cause instanceof DatabaseBusyException || e instanceof DatabaseBusyException || e instanceof CannotCreateSessionException || cause instanceof CannotCreateSessionException) {
            return ConnectionStatus.SERVER_OUT_OF_SERVICE;
        }
        if (cause instanceof UnknownException) {
            return this.handleIceUnknownException(cause);
        }
        if (e instanceof UnknownException) {
            return this.handleIceUnknownException(e);
        }
        return ConnectionStatus.OK;
    }

    private ConnectionStatus handleIceUnknownException(Throwable e) {
        UnknownException ex = (UnknownException)e;
        if (ex.unknown.contains("Ice::ConnectionRefusedException")) {
            return ConnectionStatus.SERVER_OUT_OF_SERVICE;
        }
        if (ex.unknown.contains("Ice::ConnectionLostException")) {
            return ConnectionStatus.LOST_CONNECTION;
        }
        return ConnectionStatus.OK;
    }
}

