/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.DichroicData;
import omero.gateway.model.FilterData;
import omero.model.Dichroic;
import omero.model.FilterSet;
import omero.model.FilterSetEmissionFilterLink;
import omero.model.FilterSetExcitationFilterLink;

public class FilterSetData
extends DataObject {
    private List<FilterData> emissionFilters;
    private List<FilterData> excitationFilters;

    public FilterSetData(FilterSet filterSet) {
        if (filterSet == null) {
            throw new IllegalArgumentException("filterSet cannot null.");
        }
        this.setValue(filterSet);
    }

    public String getManufacturer() {
        FilterSet f = (FilterSet)this.asIObject();
        RString value = f.getManufacturer();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getModel() {
        FilterSet f = (FilterSet)this.asIObject();
        RString value = f.getModel();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getLotNumber() {
        FilterSet f = (FilterSet)this.asIObject();
        RString value = f.getLotNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getSerialNumber() {
        FilterSet f = (FilterSet)this.asIObject();
        RString value = f.getSerialNumber();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public List<FilterData> getEmissionFilters() {
        FilterSet f = (FilterSet)this.asIObject();
        if (this.emissionFilters == null && f.sizeOfEmissionFilterLink() > 0) {
            this.emissionFilters = new ArrayList<FilterData>();
            List<FilterSetEmissionFilterLink> l = f.copyEmissionFilterLink();
            Iterator<FilterSetEmissionFilterLink> i = l.iterator();
            while (i.hasNext()) {
                this.emissionFilters.add(new FilterData(i.next().getChild()));
            }
        }
        return this.emissionFilters;
    }

    public List<FilterData> getExcitationFilters() {
        FilterSet f = (FilterSet)this.asIObject();
        if (this.excitationFilters == null && f.sizeOfExcitationFilterLink() > 0) {
            this.excitationFilters = new ArrayList<FilterData>();
            List<FilterSetExcitationFilterLink> l = f.copyExcitationFilterLink();
            Iterator<FilterSetExcitationFilterLink> i = l.iterator();
            while (i.hasNext()) {
                this.excitationFilters.add(new FilterData(i.next().getChild()));
            }
        }
        return this.excitationFilters;
    }

    public DichroicData getDichroic() {
        FilterSet f = (FilterSet)this.asIObject();
        Dichroic d = f.getDichroic();
        if (d == null) {
            return null;
        }
        return new DichroicData(d);
    }
}

