/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Map;
import omero.RInt;
import omero.RString;
import omero.RTime;
import omero.gateway.model.DataObject;
import omero.model.PlateAcquisition;
import omero.model.PlateAcquisitionI;
import omero.rtypes;
import org.apache.commons.lang3.StringUtils;

public class PlateAcquisitionData
extends DataObject {
    private static final String DEFAULT_TEXT = "Run ";
    private long refPlateId;

    public PlateAcquisitionData() {
        this.setDirty(true);
        this.setValue(new PlateAcquisitionI());
        this.refPlateId = -1L;
    }

    public PlateAcquisitionData(PlateAcquisition value) {
        if (value == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(value);
        this.refPlateId = -1L;
    }

    public long getRefPlateId() {
        return this.refPlateId;
    }

    public void setRefPlateId(long refPlateId) {
        this.refPlateId = refPlateId;
    }

    public String getName() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return "";
        }
        RString n = acq.getName();
        if (n == null) {
            return "";
        }
        return n.getValue();
    }

    public String getDescription() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return "";
        }
        RString n = acq.getDescription();
        if (n == null) {
            return "";
        }
        return n.getValue();
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        this.setDirty(true);
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        acq.setName(rtypes.rstring(name));
    }

    public void setDescription(String description) {
        if (StringUtils.isBlank((CharSequence)description)) {
            return;
        }
        this.setDirty(true);
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        acq.setDescription(rtypes.rstring(description));
    }

    public Timestamp getStartTime() {
        PlateAcquisition sa = (PlateAcquisition)this.asIObject();
        if (sa == null) {
            return null;
        }
        RTime time = sa.getStartTime();
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getValue());
    }

    public Timestamp getEndTime() {
        PlateAcquisition sa = (PlateAcquisition)this.asIObject();
        if (sa == null) {
            return null;
        }
        RTime time = sa.getEndTime();
        if (time == null) {
            return null;
        }
        return new Timestamp(time.getValue());
    }

    public String getLabel() {
        String name = this.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name;
        }
        Timestamp time = this.getStartTime();
        String start = "";
        String end = "";
        if (time != null) {
            start = DateFormat.getDateTimeInstance(3, 3).format(time);
        }
        String[] values = start.split(" ");
        String date = "";
        String dateEnd = "";
        if (values.length > 1) {
            date = values[0];
            start = start.substring(date.length() + 1);
        }
        if ((time = this.getEndTime()) != null) {
            end = DateFormat.getDateTimeInstance(3, 3).format(time);
        }
        if ((values = end.split(" ")).length > 1) {
            if (!date.equals(values[0])) {
                dateEnd = values[0];
            }
            end = end.substring(values[0].length() + 1);
        }
        Object value = "";
        if (start.length() == 0 && end.length() == 0) {
            return DEFAULT_TEXT + this.getId();
        }
        if (date.length() == 0 && end.length() != 0) {
            return dateEnd + " " + end;
        }
        if (dateEnd.length() == 0) {
            value = date + " " + start;
            if (end.length() > 0) {
                value = (String)value + " - " + end;
            }
        } else {
            value = date + " " + start + " - " + dateEnd + " " + end;
        }
        if (((String)value).length() > 0) {
            return value;
        }
        return DEFAULT_TEXT + this.getId();
    }

    public int getMaximumFieldCount() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return -1;
        }
        RInt n = acq.getMaximumFieldCount();
        if (n == null) {
            return -1;
        }
        return n.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        PlateAcquisition acq = (PlateAcquisition)this.asIObject();
        if (acq == null) {
            return null;
        }
        return acq.getAnnotationLinksCountPerOwner();
    }
}

