/*
 * Decompiled with CFR 0.152.
 */
package ome.annotations;

import java.lang.reflect.Method;
import ome.conditions.InternalException;

public class AnnotationUtils {
    public static Object[] findMethodAnnotations(Class implClass, Method mthd) throws InternalException {
        Class<?>[] interfaces = implClass.getInterfaces();
        Object[] annotations = new Object[interfaces.length + 1];
        for (int i = 0; i < interfaces.length; ++i) {
            Method m = AnnotationUtils.findMethod(interfaces[i], mthd);
            annotations[i] = m == null ? null : m.getDeclaredAnnotations();
        }
        annotations[interfaces.length] = mthd.getDeclaredAnnotations();
        return annotations;
    }

    public static Object[] findParameterAnnotations(Class implClass, Method mthd) throws InternalException {
        Class<?>[] interfaces = implClass.getInterfaces();
        Object[] annotations = new Object[interfaces.length + 1];
        for (int i = 0; i < interfaces.length; ++i) {
            Method m = AnnotationUtils.findMethod(interfaces[i], mthd);
            annotations[i] = m == null ? null : m.getParameterAnnotations();
        }
        annotations[interfaces.length] = mthd.getParameterAnnotations();
        return annotations;
    }

    private static Method findMethod(Class implClass, Method mthd) throws InternalException {
        Method implMethod;
        try {
            implMethod = implClass.getMethod(mthd.getName(), mthd.getParameterTypes());
        }
        catch (SecurityException e) {
            throw new InternalException("Not allowed to perform reflection for testing API.\n" + String.format("Class:%s Method:%s", implClass.getName(), mthd));
        }
        catch (NoSuchMethodException e) {
            implMethod = null;
        }
        return implMethod;
    }
}

