/*
 * Decompiled with CFR 0.152.
 */
package ome.model.units;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import ome.model.enums.UnitsPower;
import ome.model.units.Unit;
import ome.util.Filter;
import ome.util.Filterable;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPowerEnumHandler;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class Power
implements Serializable,
Filterable,
Unit {
    private static final long serialVersionUID = 1L;
    public static final String VALUE = "ome.model.units.Power_value";
    public static final String UNIT = "ome.model.units.Power_unit";
    private double value;
    private UnitsPower unit = null;

    public static ome.xml.model.enums.UnitsPower makePowerUnitXML(String unit) {
        try {
            return ome.xml.model.enums.UnitsPower.fromString((String)unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Power unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Power makePowerXML(double d, String unit) {
        ome.units.unit.Unit units = UnitsPowerEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsPower)Power.makePowerUnitXML(unit));
        return new ome.units.quantity.Power((Number)d, units);
    }

    public static ome.units.quantity.Power convertPower(Power t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = t.getUnit().getSymbol();
        ome.xml.model.enums.UnitsPower units = Power.makePowerUnitXML(u);
        ome.units.unit.Unit units2 = UnitsPowerEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsPower)units);
        return new ome.units.quantity.Power((Number)v, units2);
    }

    public static Power convertPower(Power value, ome.units.unit.Unit<ome.units.quantity.Power> ul) {
        return Power.convertPower(value, ul.getSymbol());
    }

    public static Power convertPower(Power value, String target) {
        String source = value.getUnit().getSymbol();
        if (target.equals(source)) {
            return value;
        }
        throw new RuntimeException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit().getSymbol(), source));
    }

    @Deprecated
    public Power() {
    }

    public Power(double d, String u) {
        this.value = d;
        this.unit = UnitsPower.valueOf(u);
    }

    public Power(double d, UnitsPower u) {
        this.value = d;
        this.unit = u;
    }

    public Power(double d, ome.units.unit.Unit<ome.units.quantity.Power> unit) {
        this(d, UnitsPower.bySymbol(unit.getSymbol()));
    }

    public Power(ome.units.quantity.Power value) {
        this(value.value().doubleValue(), UnitsPower.bySymbol(value.unit().getSymbol()));
    }

    @Override
    @Column(name="value", nullable=false)
    public double getValue() {
        return this.value;
    }

    @Override
    @Column(name="unit", nullable=false, unique=false, insertable=true, updatable=true)
    @Type(type="ome.model.units.GenericEnumType", parameters={@Parameter(name="unit", value="POWER")})
    public UnitsPower getUnit() {
        return this.unit;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public void setUnit(UnitsPower unit) {
        this.unit = unit;
    }

    @Override
    public boolean acceptFilter(Filter filter) {
        this.unit = (UnitsPower)filter.filter(UNIT, this.unit);
        this.value = (Double)filter.filter(VALUE, this.value);
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Power(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Power other = (Power)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }
}

