/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Layouter;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.geom.Dimension2DDouble;

public class LocatorLayouter
implements Layouter {
    public static final AttributeKey<Locator> LAYOUT_LOCATOR = new AttributeKey<Object>("layoutLocator", null);

    public Rectangle2D.Double calculateLayout(CompositeFigure compositeFigure, Point2D.Double anchor, Point2D.Double lead) {
        Rectangle2D.Double bounds = null;
        for (Figure child : compositeFigure.getChildren()) {
            Rectangle2D.Double r;
            Locator locator = this.getLocator(child);
            if (locator == null) {
                r = child.getBounds();
            } else {
                Point2D.Double p = locator.locate(compositeFigure);
                Dimension2DDouble d = child.getPreferredSize();
                r = new Rectangle2D.Double(p.x, p.y, d.width, d.height);
            }
            if (r.isEmpty()) continue;
            if (bounds == null) {
                bounds = r;
                continue;
            }
            bounds.add(r);
        }
        return bounds == null ? new Rectangle2D.Double() : bounds;
    }

    public Rectangle2D.Double layout(CompositeFigure compositeFigure, Point2D.Double anchor, Point2D.Double lead) {
        Rectangle2D.Double bounds = null;
        for (Figure child : compositeFigure.getChildren()) {
            Rectangle2D.Double r;
            Locator locator = this.getLocator(child);
            if (locator == null) {
                r = child.getBounds();
            } else {
                Point2D.Double p = locator.locate(compositeFigure, child);
                Dimension2DDouble d = child.getPreferredSize();
                r = new Rectangle2D.Double(p.x, p.y, d.width, d.height);
            }
            child.willChange();
            child.setBounds(new Point2D.Double(r.getMinX(), r.getMinY()), new Point2D.Double(r.getMaxX(), r.getMaxY()));
            child.changed();
            if (r.isEmpty()) continue;
            if (bounds == null) {
                bounds = r;
                continue;
            }
            bounds.add(r);
        }
        return bounds == null ? new Rectangle2D.Double() : bounds;
    }

    private Locator getLocator(Figure f) {
        return (Locator)f.getAttribute(LAYOUT_LOCATOR);
    }
}

