/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.mini;

import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.ElbowLiner;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.geom.Geom;

public class SmartConnectionFigureSample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextAreaFigure ta = new TextAreaFigure();
                ta.setBounds(new Point2D.Double(10.0, 30.0), new Point2D.Double(100.0, 100.0));
                TextAreaFigure tb = new TextAreaFigure();
                tb.setBounds(new Point2D.Double(220.0, 130.0), new Point2D.Double(310.0, 210.0));
                TextAreaFigure tc = new TextAreaFigure();
                tc.setBounds(new Point2D.Double(220.0, 30.0), new Point2D.Double(310.0, 100.0));
                SmartConnectionFigure cf = new SmartConnectionFigure();
                cf.setLiner(new ElbowLiner());
                cf.setStartConnector(ta.findConnector(Geom.center(ta.getBounds()), cf));
                cf.setEndConnector(tb.findConnector(Geom.center(tb.getBounds()), cf));
                DefaultDrawing drawing = new DefaultDrawing();
                drawing.add(ta);
                drawing.add(tb);
                drawing.add(tc);
                drawing.add(cf);
                JFrame f = new JFrame("My Drawing");
                f.setDefaultCloseOperation(3);
                f.setSize(400, 300);
                DefaultDrawingView view = new DefaultDrawingView();
                view.setDrawing(drawing);
                f.getContentPane().add(view.getComponent());
                DefaultDrawingEditor editor = new DefaultDrawingEditor();
                editor.add(view);
                editor.setTool(new DelegationSelectionTool());
                f.show();
            }
        });
    }

    private static class SmartConnectionFigure
    extends LineConnectionFigure {
        public SmartConnectionFigure() {
            this.setAttributeEnabled(AttributeKeys.STROKE_TYPE, false);
        }

        public void handleConnect(Connector start, Connector end) {
            this.setAttributeEnabled(AttributeKeys.STROKE_TYPE, true);
            AttributeKeys.STROKE_TYPE.set(this, start.getOwner() == end.getOwner() ? AttributeKeys.StrokeType.DOUBLE : AttributeKeys.StrokeType.BASIC);
            this.setAttributeEnabled(AttributeKeys.STROKE_TYPE, false);
        }

        public void handleDisconnect(Connector start, Connector end) {
            this.setAttributeEnabled(AttributeKeys.STROKE_TYPE, true);
            AttributeKeys.STROKE_TYPE.set(this, AttributeKeys.StrokeType.BASIC);
            this.setAttributeEnabled(AttributeKeys.STROKE_TYPE, false);
        }
    }
}

