/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ome.model.IObject;

public class DataProviderBuilder {
    private List<List<Object>> args = Collections.singletonList(Collections.emptyList());

    public DataProviderBuilder add(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] enums = enumClass.getEnumConstants();
        ArrayList<List<Object>> newArgs = new ArrayList<List<Object>>(this.args.size() * enums.length);
        for (List<Object> arg : this.args) {
            for (Enum<?> e : enums) {
                ArrayList<Object> newArg = new ArrayList<Object>(arg.size() + 1);
                newArg.addAll(arg);
                newArg.add(e);
                newArgs.add(newArg);
            }
        }
        this.args = newArgs;
        return this;
    }

    public DataProviderBuilder add(Collection<Class<? extends IObject>> objectClasses) throws ReflectiveOperationException {
        ArrayList<IObject> objects = new ArrayList<IObject>(objectClasses.size());
        for (Class<? extends IObject> objectClass : objectClasses) {
            objects.add(objectClass.newInstance());
        }
        ArrayList<List<Object>> newArgs = new ArrayList<List<Object>>(this.args.size() * objects.size());
        for (List<Object> arg : this.args) {
            for (IObject o : objects) {
                ArrayList<Object> newArg = new ArrayList<Object>(arg.size() + 1);
                newArg.addAll(arg);
                newArg.add(o);
                newArgs.add(newArg);
            }
        }
        this.args = newArgs;
        return this;
    }

    public DataProviderBuilder addBoolean(boolean isNullable) {
        ArrayList<List<Object>> newArgs = new ArrayList<List<Object>>(this.args.size() * (isNullable ? 3 : 2));
        for (List<Object> arg : this.args) {
            ArrayList<Object> newArg = new ArrayList<Object>(arg.size() + 1);
            newArg.addAll(arg);
            newArg.add(Boolean.FALSE);
            newArgs.add(newArg);
            newArg = new ArrayList(arg.size() + 1);
            newArg.addAll(arg);
            newArg.add(Boolean.TRUE);
            newArgs.add(newArg);
            if (!isNullable) continue;
            newArg = new ArrayList(arg.size() + 1);
            newArg.addAll(arg);
            newArg.add(null);
            newArgs.add(newArg);
        }
        this.args = newArgs;
        return this;
    }

    public Object[][] build() {
        Object[][] argsArray = new Object[this.args.size()][];
        int index = 0;
        for (List<Object> arg : this.args) {
            argsArray[index++] = arg.toArray();
        }
        return argsArray;
    }
}

