/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application;

import application.ResourceMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.application.AbstractDocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AboutAction;
import org.jhotdraw.application.action.AbstractApplicationAction;
import org.jhotdraw.application.action.Actions;
import org.jhotdraw.application.action.ClearAction;
import org.jhotdraw.application.action.ClearRecentFilesAction;
import org.jhotdraw.application.action.CloseAction;
import org.jhotdraw.application.action.CopyAction;
import org.jhotdraw.application.action.CutAction;
import org.jhotdraw.application.action.DeleteAction;
import org.jhotdraw.application.action.DuplicateAction;
import org.jhotdraw.application.action.ExitAction;
import org.jhotdraw.application.action.LoadAction;
import org.jhotdraw.application.action.NewAction;
import org.jhotdraw.application.action.PasteAction;
import org.jhotdraw.application.action.PrintAction;
import org.jhotdraw.application.action.RedoAction;
import org.jhotdraw.application.action.SaveAction;
import org.jhotdraw.application.action.SaveAsAction;
import org.jhotdraw.application.action.SelectAllAction;
import org.jhotdraw.application.action.ToggleVisibleAction;
import org.jhotdraw.application.action.UndoAction;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSDIApplication
extends AbstractDocumentOrientedApplication {
    private DocumentView currentView;

    @Override
    public void remove(DocumentView p) {
        super.remove(p);
        if (this.getViews().size() == 0) {
            this.exit();
        }
    }

    public static void initAWT(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    @Override
    protected void initLookAndFeel() {
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "");
        }
    }

    @Override
    protected ActionMap createActionMap() {
        ActionMap m = new ActionMap();
        m.put("Application.about", new AboutAction());
        m.put("Application.exit", new ExitAction());
        m.put("File.clear", new ClearAction());
        m.put("File.new", new NewAction());
        ((AbstractApplicationAction)m.get("File.new")).initActionProperties("newWindow");
        m.put("File.load", new LoadAction());
        m.put("File.clearRecentFiles", new ClearRecentFilesAction());
        m.put("File.save", new SaveAction());
        m.put("File.saveAs", new SaveAsAction());
        m.put("File.close", new CloseAction());
        m.put("File.print", new PrintAction());
        m.put("Edit.undo", new UndoAction());
        m.put("Edit.redo", new RedoAction());
        m.put("Edit.cut", new CutAction());
        m.put("Edit.copy", new CopyAction());
        m.put("Edit.paste", new PasteAction());
        m.put("Edit.delete", new DeleteAction());
        m.put("Edit.duplicate", new DuplicateAction());
        m.put("Edit.selectAll", new SelectAllAction());
        return m;
    }

    @Override
    public void show(final DocumentView p) {
        boolean moved;
        final ResourceMap labels = this.getFrameworkResourceMap();
        this.updateName(p);
        final JFrame f = new JFrame();
        f.setTitle(labels.getString("SDIWindow.Frame.title", new Object[]{p.getName()}));
        f.setDefaultCloseOperation(0);
        JPanel panel = (JPanel)this.wrapProjectComponent(p);
        f.add(panel);
        f.setMinimumSize(new Dimension(200, 200));
        f.setPreferredSize(new Dimension(600, 400));
        f.setJMenuBar(this.createMenuBar(p, (List)panel.getClientProperty("toolBarActions")));
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        PreferencesUtil.installFramePrefsHandler(prefs, "documentView", f);
        Point loc = f.getLocation();
        block0: do {
            moved = false;
            for (DocumentView aProject : this.getViews()) {
                if (aProject == p || SwingUtilities.getWindowAncestor(aProject.getComponent()) == null || !SwingUtilities.getWindowAncestor(aProject.getComponent()).getLocation().equals(loc)) continue;
                loc.x += 22;
                loc.y += 22;
                moved = true;
                continue block0;
            }
        } while (moved);
        f.setLocation(loc);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AbstractSDIApplication.this.setCurrentView(p);
                AbstractSDIApplication.this.getAction("File.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
            }

            public void windowActivated(WindowEvent e) {
                AbstractSDIApplication.this.setCurrentView(p);
            }
        });
        p.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals("modified") || name.equals("name")) {
                    f.setTitle(labels.getString(p.isModified() ? "SDIWindow.Frame.modifiedTitle" : "SDIWindow.Frame.title", new Object[]{p.getName()}));
                } else if (name.equals("file")) {
                    AbstractSDIApplication.this.updateName(p);
                }
            }
        });
        f.setVisible(true);
    }

    protected Component wrapProjectComponent(DocumentView p) {
        JComponent c = p.getComponent();
        LinkedList<ToggleVisibleAction> toolBarActions = new LinkedList<ToggleVisibleAction>();
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        int id = 0;
        for (JToolBar tb : new ReversedList<JToolBar>(this.createToolBars(p))) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)tb, "North");
            panel.add((Component)c, "Center");
            c = panel;
            PreferencesUtil.installToolBarPrefsHandler(prefs, "toolbar." + ++id, tb);
            toolBarActions.addFirst(new ToggleVisibleAction(tb, tb.getName()));
        }
        c.putClientProperty("toolBarActions", toolBarActions);
        return c;
    }

    @Override
    public void hide(DocumentView p) {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
        f.setVisible(false);
        f.remove(p.getComponent());
        f.dispose();
    }

    @Override
    public DocumentView getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(DocumentView newValue) {
        DocumentView oldValue = this.currentView;
        this.currentView = newValue;
        this.firePropertyChange("currentView", oldValue, newValue);
    }

    @Override
    protected JMenu createFileMenu(final DocumentView p) {
        ResourceMap labels = this.getFrameworkResourceMap();
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        m.setName("File.Menu");
        labels.injectComponent((Component)m);
        m.add(this.getAction("File.clear"));
        m.add(this.getAction("File.new"));
        m.add(this.getAction("File.load"));
        final JMenu openRecentMenu = new JMenu();
        openRecentMenu.setName("File.openRecent.Menu");
        labels.injectComponent((Component)openRecentMenu);
        openRecentMenu.add(this.getAction("File.clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        m.add(this.getAction("File.save"));
        m.add(this.getAction("File.saveAs"));
        if (this.getAction("File.export") != null) {
            JMenuItem jMenuItem = m.add(this.getAction("File.export"));
        }
        if (this.getAction("File.print") != null) {
            m.addSeparator();
            m.add(this.getAction("File.print"));
        }
        m.addSeparator();
        m.add(this.getAction("Application.exit"));
        mb.add(m);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "projectCount") {
                    if (p != null && !AbstractSDIApplication.this.getViews().contains(p)) {
                        AbstractSDIApplication.this.removePropertyChangeListener(this);
                    }
                } else if (name == "recentFiles") {
                    AbstractSDIApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    @Override
    public boolean isEditorShared() {
        return false;
    }

    @Override
    public Component getComponent() {
        DocumentView p = this.getCurrentView();
        return p == null ? null : p.getComponent();
    }

    protected JMenu createViewMenu(DocumentView p, List<Action> toolBarActions) {
        ResourceMap labels = this.getResourceMap();
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        m.setName("View.Menu");
        labels.injectComponent((Component)m);
        if (toolBarActions != null && toolBarActions.size() > 0) {
            JMenu m2 = toolBarActions.size() == 1 ? m : new JMenu(labels.getString("toolBars", new Object[0]));
            for (Action a : toolBarActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                m2.add(cbmi);
            }
            m.add(m2);
        }
        return m;
    }

    @Override
    protected JMenu createHelpMenu(DocumentView p) {
        ResourceMap labels = this.getFrameworkResourceMap();
        JMenu m = new JMenu();
        m.setName("Help.Menu");
        labels.injectComponent((Component)m);
        m.add(this.getAction("Application.about"));
        return m;
    }
}

