/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class RoundRectangleRadiusHandle
extends AbstractHandle {
    private static final int OFFSET = 6;
    private Point originalArc;
    CompositeEdit edit;

    public RoundRectangleRadiusHandle(Figure owner) {
        super(owner);
    }

    public void draw(Graphics2D g) {
        this.drawDiamond(g, Color.yellow, Color.black);
    }

    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.locate());
        r.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return r;
    }

    private Point locate() {
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        Rectangle r = this.view.drawingToView(owner.getBounds());
        Point arc = this.view.drawingToView(new Point2D.Double(owner.getArcWidth(), owner.getArcHeight()));
        return new Point(r.x + arc.x / 2 + 6, r.y + arc.y / 2 + 6);
    }

    public void trackStart(Point anchor, int modifiersEx) {
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        this.originalArc = this.view.drawingToView(new Point2D.Double(owner.getArcWidth(), owner.getArcHeight()));
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        int dx = lead.x - anchor.x;
        int dy = lead.y - anchor.y;
        RoundRectangleFigure owner = (RoundRectangleFigure)this.getOwner();
        Rectangle r = this.view.drawingToView(owner.getBounds());
        Point viewArc = new Point(Geom.range(0, r.width, 2 * (this.originalArc.x / 2 + dx)), Geom.range(0, r.height, 2 * (this.originalArc.y / 2 + dy)));
        Point2D.Double arc = this.view.viewToDrawing(viewArc);
        owner.setArc(arc.x, arc.y);
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels").getString("roundRectangleRadiusHandle.tip");
    }
}

