/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.pert;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.print.Pageable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.AbstractProject;
import org.jhotdraw.draw.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingPageable;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.ImageOutputFormat;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.pert.PertFactory;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class PertProject
extends AbstractProject {
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private GridConstrainer visibleConstrainer = new GridConstrainer(10.0, 10.0);
    private GridConstrainer invisibleConstrainer = new GridConstrainer(1.0, 1.0);
    private Preferences prefs;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    public void init() {
        super.init();
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(this.createDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PertProject.this.setHasUnsavedChanges(PertProject.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        pButton = ButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "alignGridSmall");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.setGridVisible(this.prefs.getBoolean("project.gridVisible", false));
        this.setScaleFactor(this.prefs.getDouble("project.scaleFactor", 1.0));
    }

    protected Drawing createDrawing() {
        DefaultDrawing drawing = new DefaultDrawing();
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new PertFactory());
        LinkedList<InputFormat> inputFormats = new LinkedList<InputFormat>();
        inputFormats.add(ioFormat);
        drawing.setInputFormats(inputFormats);
        LinkedList<OutputFormat> outputFormats = new LinkedList<OutputFormat>();
        outputFormats.add(ioFormat);
        outputFormats.add(new ImageOutputFormat());
        drawing.setOutputFormats(outputFormats);
        return drawing;
    }

    public Pageable createPageable() {
        return new DrawingPageable(this.view.getDrawing());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        if (newValue != null) {
            newValue.add(this.view);
        }
    }

    public void setGridVisible(boolean newValue) {
        boolean oldValue = this.isGridVisible();
        GridConstrainer c = newValue ? this.visibleConstrainer : this.invisibleConstrainer;
        this.view.setConstrainer(c);
        this.firePropertyChange("gridVisible", oldValue, newValue);
        this.prefs.putBoolean("project.gridVisible", newValue);
    }

    public boolean isGridVisible() {
        return this.view.getConstrainer() == this.visibleConstrainer;
    }

    public double getScaleFactor() {
        return this.view.getScaleFactor();
    }

    public void setScaleFactor(double newValue) {
        double oldValue = this.getScaleFactor();
        this.view.setScaleFactor(newValue);
        this.firePropertyChange("scaleFactor", oldValue, newValue);
        this.prefs.putDouble("project.scaleFactor", newValue);
    }

    private void initActions() {
        this.putAction("undo", this.undo.getUndoAction());
        this.putAction("redo", this.undo.getRedoAction());
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    public void write(File f) throws IOException {
        Drawing drawing = this.view.getDrawing();
        OutputFormat outputFormat = drawing.getOutputFormats().get(0);
        outputFormat.write(f, drawing);
    }

    public void read(File f) throws IOException {
        try {
            final Drawing drawing = this.createDrawing();
            InputFormat inputFormat = drawing.getInputFormats().get(0);
            inputFormat.read(f, drawing);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    PertProject.this.view.getDrawing().removeUndoableEditListener(PertProject.this.undo);
                    PertProject.this.view.setDrawing(drawing);
                    PertProject.this.view.getDrawing().addUndoableEditListener(PertProject.this.undo);
                    PertProject.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
    }

    public void setDrawingEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.remove(this.view);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.add(this.view);
        }
    }

    public DrawingEditor getDrawingEditor() {
        return this.editor;
    }

    public void clear() {
        this.view.setDrawing(new DefaultDrawing());
        this.undo.discardAllEdits();
    }

    protected JFileChooser createOpenChooser() {
        JFileChooser c = super.createOpenChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Pert Diagram", "xml"));
        return c;
    }

    protected JFileChooser createSaveChooser() {
        JFileChooser c = super.createSaveChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Pert Diagram", "xml"));
        return c;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
    }
}

