/*
 * Decompiled with CFR 0.152.
 */
package ome.model.meta;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IGlobal;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.model.annotations.NodeAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.ExternalInfo;
import ome.model.meta.Session;
import ome.services.fulltext.ConfiguredAnalyzer;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="owner_or_admin", parameters={@ParamDef(name="current_user", type="java.lang.Long"), @ParamDef(name="is_admin", type="java.lang.Integer")})})
@Filters(value={@org.hibernate.annotations.Filter(name="owner_or_admin", condition="(1 = :is_admin)")})
@Entity
@Table(name="node", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_node", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_node"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Node
implements Serializable,
IObject,
IGlobal,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String ID = "ome.model.meta.Node_id";
    protected Long id;
    public static final String VERSION = "ome.model.meta.Node_version";
    protected Integer version = 0;
    protected Set<Session> sessions = new HashSet<Session>();
    protected String uuid = null;
    protected String conn = null;
    protected Timestamp up = null;
    protected Timestamp down = null;
    protected Integer scale = null;
    protected Set<NodeAnnotationLink> annotationLinks = new HashSet<NodeAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "node_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "node_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "node_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "node_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String SESSIONS = "ome.model.meta.Node_sessions";
    public static final String UUID = "ome.model.meta.Node_uuid";
    public static final String CONN = "ome.model.meta.Node_conn";
    public static final String UP = "ome.model.meta.Node_up";
    public static final String DOWN = "ome.model.meta.Node_down";
    public static final String SCALE = "ome.model.meta.Node_scale";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.meta.Node_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.meta.Node_annotationLinks";
    public static final String DETAILS = "ome.model.meta.Node_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Node() {
        this(null, true);
    }

    protected Node(Long id) {
        this(id, true);
    }

    public Node(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    public Node(String _uuid, String _conn, Timestamp _up) {
        this(null, true);
        this.setUuid(_uuid);
        this.setConn(_conn);
        this.setUp(_up);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_node")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @OneToMany(mappedBy="node", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    protected Set<Session> getSessions() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sessions;
    }

    protected void setSessions(Set<Session> sessions) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.sessions = sessions;
    }

    public int sizeOfSessions() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.sessions == null ? -1 : this.sessions.size();
    }

    public Iterator<Session> iterateSessions() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            return new EmptyIterator<Session>();
        }
        return this.getSessions().iterator();
    }

    public Collection<Session> unmodifiableSessions() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getSessions());
    }

    public <E> List<E> collectSessions(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Session> it = this.iterateSessions();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addSession(Session target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            this.throwNullCollectionException("Sessions");
        }
        this.getSessions().add(target);
        if (target != null) {
            target.setNode(this);
        }
    }

    public void addSessionSet(Collection<Session> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            this.throwNullCollectionException("Sessions");
        }
        this.getSessions().addAll(targets);
        for (Session target : targets) {
            if (target == null) continue;
            target.setNode(this);
        }
    }

    public void removeSession(Session target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            this.throwNullCollectionException("Sessions");
        }
        this.getSessions().remove(target);
        target.setNode(null);
    }

    public void removeSessionSet(Collection<Session> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            this.throwNullCollectionException("Sessions");
        }
        this.getSessions().removeAll(targets);
        for (Session target : targets) {
            target.setNode(null);
        }
    }

    public void clearSessions() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getSessions() == null) {
            this.throwNullCollectionException("Sessions");
        }
        this.getSessions().clear();
        Iterator<Session> it = this.iterateSessions();
        while (it.hasNext()) {
            Session target = it.next();
            target.setNode(null);
        }
    }

    @Type(type="ome.util.PrivilegedStringType$FilteredFullAdminUUID")
    @ColumnTransformer(read="'-1;' || /*securestring*/ uuid")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=true, name="uuid", updatable=true)
    public String getUuid() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.uuid = uuid;
    }

    @Type(type="ome.util.PrivilegedStringType$FilteredFullAdminHidden")
    @ColumnTransformer(read="'-1;' || /*securestring*/ conn")
    @Fields(value={@Field(index=Index.TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=false, unique=false, name="conn", updatable=true)
    public String getConn() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.conn;
    }

    public void setConn(String conn) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.conn = conn;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED)})
    @Column(columnDefinition="", nullable=false, unique=false, name="up", updatable=true)
    public Timestamp getUp() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.up;
    }

    public void setUp(Timestamp up) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.up = up;
    }

    @DateBridge(resolution=Resolution.MINUTE)
    @Fields(value={@Field(index=Index.UN_TOKENIZED)})
    @Column(columnDefinition="", nullable=true, unique=false, name="down", updatable=true)
    public Timestamp getDown() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.down;
    }

    public void setDown(Timestamp down) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.down = down;
    }

    @Fields(value={@Field(index=Index.UN_TOKENIZED), @Field(index=Index.TOKENIZED, analyzer=@Analyzer(impl=ConfiguredAnalyzer.class), name="combined_fields")})
    @Column(columnDefinition="", nullable=true, unique=false, name="scale", updatable=true)
    public Integer getScale() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.scale;
    }

    public void setScale(Integer scale) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.scale = scale;
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="node_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="node_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="node_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="node_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<NodeAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<NodeAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<NodeAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<NodeAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<NodeAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<NodeAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addNodeAnnotationLink(NodeAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addNodeAnnotationLinkSet(Collection<NodeAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (NodeAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeNodeAnnotationLink(NodeAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeNodeAnnotationLinkSet(Collection<NodeAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (NodeAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public NodeAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        NodeAnnotationLink link = new NodeAnnotationLink();
        link.link(this, addition);
        this.addNodeAnnotationLink(link, true);
        return link;
    }

    public void addNodeAnnotationLink(NodeAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<NodeAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                NodeAnnotationLink link = (NodeAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<NodeAnnotationLink> findNodeAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<NodeAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<NodeAnnotationLink> result = new HashSet<NodeAnnotationLink>();
        while (it.hasNext()) {
            NodeAnnotationLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<NodeAnnotationLink> toRemove = this.findNodeAnnotationLink(removal);
        Iterator<NodeAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeNodeAnnotationLink(it.next(), true);
        }
    }

    public void removeNodeAnnotationLink(NodeAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<NodeAnnotationLink> list = new ArrayList<NodeAnnotationLink>(this.getAnnotationLinks());
        for (NodeAnnotationLink link : list) {
            this.removeNodeAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Node_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Node_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Node_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Node newInstance() {
        return new Node();
    }

    public Node proxy() {
        return new Node(this.id, false);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.sessions = (Set)__filter.filter(SESSIONS, this.sessions);
            this.uuid = (String)__filter.filter(UUID, this.uuid);
            this.conn = (String)__filter.filter(CONN, this.conn);
            this.up = (Timestamp)__filter.filter(UP, this.up);
            this.down = (Timestamp)__filter.filter(DOWN, this.down);
            this.scale = (Integer)__filter.filter(SCALE, this.scale);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(SESSIONS)) {
            return this.getSessions();
        }
        if (field.equals(UUID)) {
            return this.getUuid();
        }
        if (field.equals(CONN)) {
            return this.getConn();
        }
        if (field.equals(UP)) {
            return this.getUp();
        }
        if (field.equals(DOWN)) {
            return this.getDown();
        }
        if (field.equals(SCALE)) {
            return this.getScale();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(SESSIONS)) {
            this.setSessions((Set)value);
        } else if (field.equals(UUID)) {
            this.setUuid((String)value);
        } else if (field.equals(CONN)) {
            this.setConn((String)value);
        } else if (field.equals(UP)) {
            this.setUp((Timestamp)value);
        } else if (field.equals(DOWN)) {
            this.setDown((Timestamp)value);
        } else if (field.equals(SCALE)) {
            this.setScale((Integer)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.sessions = null;
        this.uuid = null;
        this.conn = null;
        this.up = null;
        this.down = null;
        this.scale = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(SESSIONS);
        raw.add(UUID);
        raw.add(CONN);
        raw.add(UP);
        raw.add(DOWN);
        raw.add(SCALE);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKnode_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }
    }
}

