/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.AdvancedResultSearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class SearchThumbnailLoader
extends DataBrowserLoader {
    private Collection<DataObject> objects;
    private AdvancedResultSearchModel model;
    private CallHandle handle;

    public SearchThumbnailLoader(DataBrowser viewer, SecurityContext ctx, Collection<ImageData> imgs, AdvancedResultSearchModel model) {
        super(viewer, ctx);
        if (imgs == null) {
            throw new NullPointerException("The provided collection of images shouldn't be null.");
        }
        this.model = model;
        this.objects = new ArrayList<DataObject>(imgs.size());
        for (ImageData img : imgs) {
            this.objects.add(img);
        }
    }

    @Override
    public void load() {
        this.handle = this.hiBrwView.loadThumbnails(this.ctx, this.objects, 96, 96, -1L, 0, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        ThumbnailData td;
        if (this.viewer.getState() == 5) {
            return;
        }
        String status = fe.getStatus();
        int percDone = fe.getPercentDone();
        if (status == null) {
            String string = status = percDone == 100 ? "Done" : "";
        }
        if ((td = (ThumbnailData)fe.getPartialResult()) != null) {
            long imgId = td.getImageID();
            BufferedImage thumb = td.getThumbnail();
            this.model.setThumbnail(imgId, thumb);
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void onEnd() {
        this.model.notifyThumbsLoaded();
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

