/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;

class TagSetsModel
extends DataBrowserModel {
    private Set<TagAnnotationData> tagSets;

    TagSetsModel(SecurityContext ctx, Object parent, Set<TagAnnotationData> tagSets) {
        super(ctx);
        if (tagSets == null) {
            throw new IllegalArgumentException("No images.");
        }
        this.tagSets = tagSets;
        this.parent = parent;
        Set visTrees = DataBrowserTranslator.transformHierarchy(tagSets);
        this.browser = BrowserFactory.createBrowser(visTrees);
        for (TagAnnotationData tag : tagSets) {
            Set<DataObject> objects = tag.getDataObjects();
            if (objects == null) continue;
            for (DataObject child : objects) {
                if (child instanceof ImageData) {
                    ++this.numberOfImages;
                    continue;
                }
                if (child instanceof DatasetData) {
                    this.numberOfImages += ((DatasetData)child).getImages().size();
                    continue;
                }
                if (!(child instanceof ProjectData)) continue;
                Set<DatasetData> datasets = ((ProjectData)child).getDatasets();
                Iterator<DatasetData> j = datasets.iterator();
                while (j.hasNext()) {
                    this.numberOfImages += j.next().getImages().size();
                }
            }
        }
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageNode node = i.next();
                ImageData img = (ImageData)node.getHierarchyObject();
                if (!ids.contains(img.getId()) || node.getThumbnail().getFullScaleThumb() != null) continue;
                imgs.add((ImageData)node.getHierarchyObject());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                imgs.add((ImageData)node.getHierarchyObject());
                ++this.imagesLoaded;
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return this.createThumbnailsLoader(this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 4;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

