/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;

public class NodesFinder
implements ImageDisplayVisitor {
    private List<ImageDisplay> foundNodes;
    private List<DataObject> nodes;

    private void findNode(ImageDisplay node) {
        Object o = node.getHierarchyObject();
        if (!(o instanceof DataObject)) {
            return;
        }
        if (this.nodes.isEmpty()) {
            this.foundNodes.add(node);
            return;
        }
        Iterator<DataObject> i = this.nodes.iterator();
        Class<?> k = o.getClass();
        long id = ((DataObject)o).getId();
        while (i.hasNext()) {
            DataObject object = i.next();
            if (!k.equals(object.getClass()) || id != object.getId()) continue;
            this.foundNodes.add(node);
            break;
        }
    }

    public NodesFinder() {
        this(new ArrayList<DataObject>());
    }

    public NodesFinder(List<DataObject> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("No nodes to find.");
        }
        this.nodes = nodes;
        this.foundNodes = new ArrayList<ImageDisplay>();
    }

    public List<ImageDisplay> getFoundNodes() {
        return this.foundNodes;
    }

    @Override
    public void visit(ImageNode node) {
        this.findNode(node);
    }

    @Override
    public void visit(ImageSet node) {
        this.findNode(node);
    }
}

