/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.visitor;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;

public class SelectionVisitor
implements ImageDisplayVisitor {
    private Rectangle selection;
    private List<ImageDisplay> selected;
    private Colors colors;

    private boolean containsInSelection(Rectangle bounds) {
        return bounds.intersects(this.selection);
    }

    public SelectionVisitor(Rectangle selection, boolean collect) {
        this.selection = selection;
        this.colors = Colors.getInstance();
        if (collect) {
            this.selected = new ArrayList<ImageDisplay>();
        }
    }

    public List<ImageDisplay> getSelected() {
        return this.selected;
    }

    @Override
    public void visit(ImageNode node) {
        if (this.selection == null) {
            node.setHighlight(this.colors.getSelectedHighLight(node, false));
            if (this.selected != null) {
                this.selected.add(node);
            }
        } else if (this.containsInSelection(node.getBounds())) {
            node.setHighlight(this.colors.getSelectedHighLight(node, false));
            if (this.selected != null) {
                this.selected.add(node);
            }
        } else {
            node.setHighlight(this.colors.getDeselectedHighLight(node));
        }
    }

    @Override
    public void visit(ImageSet node) {
    }
}

