/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ome.model.units.Unit;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.primitives.Color;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.model.xml.Channel;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ChannelConverter
extends DataConverter {
    @Override
    public JComponent getLabel(String name, int index, List<ActionListener> listeners) {
        JPanel channelLabelPane = new JPanel();
        channelLabelPane.setLayout(new BoxLayout(channelLabelPane, 0));
        channelLabelPane.setBorder(new EmptyBorder(5, 2, 2, 2));
        channelLabelPane.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        channelLabelPane.add(label);
        return channelLabelPane;
    }

    public LinkedHashMap<String, TagData> convertData(Channel channel) {
        this.tagMap = new LinkedHashMap();
        if (channel != null) {
            try {
                this.tagMap.put("Name", this.convertName(channel.getName(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Name", this.convertName(null, true));
            }
            try {
                this.tagMap.put("Color", this.convertColor(channel.getColor(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Color", this.convertColor(null, true));
            }
            try {
                this.tagMap.put("Fluorophore", this.convertFluorophore(channel.getFluor(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Fluorophore", this.convertFluorophore(null, true));
            }
            try {
                this.tagMap.put("Illumination Type", this.convertIllumType(channel.getIlluminationTypeAsString(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Illumination Type", this.convertIllumType(null, true));
            }
            try {
                this.tagMap.put("Exposure Time", this.convertExposureTime(channel.getDefaultExposureTime(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Exposure Time", this.convertExposureTime(null, true));
            }
            try {
                this.tagMap.put("Excitation Wavelength", this.convertExcitWavelength(channel.getExcitationWavelength(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Excitation Wavelength", this.convertExcitWavelength(null, true));
            }
            try {
                this.tagMap.put("Emission Wavelength", this.convertEmissionWavelength(channel.getEmissionWavelength(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Emission Wavelength", this.convertEmissionWavelength(null, true));
            }
            try {
                this.tagMap.put("Imaging Mode", this.convertImagingMode(channel.getAcquisitionModeAsString(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Imaging Mode", this.convertImagingMode(null, true));
            }
            try {
                this.tagMap.put("Contrast Method", this.convertContrastMethod(channel.getContrastMethod(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Contrast Method", this.convertContrastMethod(null, true));
            }
            try {
                this.tagMap.put("ND Filter", this.convertNDFilter(channel.getNDFilter(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ND Filter", this.convertNDFilter(null, true));
            }
            try {
                this.tagMap.put("Pinhole Size", this.convertPinholeSize(channel.getPinholeSize(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Pinhole Size", this.convertPinholeSize(null, true));
            }
        } else {
            this.tagMap.put("Name", this.convertName(null, true));
            this.tagMap.put("Color", this.convertColor(null, true));
            this.tagMap.put("Fluorophore", this.convertFluorophore(null, true));
            this.tagMap.put("Illumination Type", this.convertIllumType(null, true));
            this.tagMap.put("Exposure Time", this.convertExposureTime(null, true));
            this.tagMap.put("Excitation Wavelength", this.convertExcitWavelength(null, true));
            this.tagMap.put("Emission Wavelength", this.convertEmissionWavelength(null, true));
            this.tagMap.put("Imaging Mode", this.convertImagingMode(null, true));
            this.tagMap.put("Contrast Method", this.convertContrastMethod(null, true));
            this.tagMap.put("ND Filter", this.convertNDFilter(null, true));
            this.tagMap.put("Pinhole Size", this.convertPinholeSize(null, true));
        }
        return this.tagMap;
    }

    private TagData convertName(String value, boolean prop) {
        return new TagData("OME:Channel", "Name", value, prop, "TextField");
    }

    private TagData convertColor(Color value, boolean prop) {
        String val = value != null ? Integer.toHexString((Integer)value.getValue()) : "";
        return new TagData("OME:Channel", "Color", val, prop, "TextField");
    }

    private TagData convertFluorophore(String value, boolean prop) {
        return new TagData("OME:Channel", "Fluorophore", value, prop, "TextField");
    }

    private TagData convertIllumType(String value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Channel", "Illumination Type", val, prop, "ComboBox", OMEValueConverter.getNames(IlluminationType.class));
    }

    private TagData convertExposureTime(Time value, boolean prop) {
        ome.model.units.Time val = null;
        if (value != null) {
            val = new ome.model.units.Time(value);
        }
        TagData t = new TagData("OME:Channel", "Exposure Time", (Unit)val, ome.model.units.Time.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPosFloat(t, "Invalid input. Use float >0!"));
        return t;
    }

    private TagData convertExcitWavelength(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        TagData t = new TagData("OME:Channel", "Excitation Wavelength", (Unit)val, ome.model.units.Length.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPosFloat(t, "Invalid input. Use float >0!"));
        return t;
    }

    private TagData convertEmissionWavelength(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        TagData t = new TagData("OME:Channel", "Emission Wavelength", (Unit)val, ome.model.units.Length.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPosFloat(t, "Invalid input. Use float >0!"));
        return t;
    }

    private TagData convertPinholeSize(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        return new TagData("OME:Channel", "Pinhole Size", (Unit)val, ome.model.units.Length.class, prop, "TextField");
    }

    private TagData convertImagingMode(String value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Channel", "Imaging Mode", value, prop, "ComboBox", OMEValueConverter.getNames(AcquisitionMode.class));
    }

    private TagData convertContrastMethod(ContrastMethod value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Channel", "Contrast Method", val, prop, "ComboBox", OMEValueConverter.getNames(ContrastMethod.class));
    }

    private TagData convertNDFilter(Double value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Channel", "ND Filter", val, prop, "TextField");
    }
}

