/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.MDEHelper;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleConfiguration;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;

public class ModuleTree
extends JPanel
implements ActionListener {
    private static String POPUP_COPY = "copy";
    private static String POPUP_PASTE = "paste";
    public static final String POPUP_DEL = "delete";
    private static String POPUP_INSERT = "insert";
    private static String POPUP_INSERT_ALL = "insertAll";
    private JMenu insert;
    private JTree tree;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode original;
    private ModuleController controller = ModuleController.getInstance();
    private DefaultMutableTreeNode copyVal;
    private JPopupMenu popup;
    private boolean changeTreeStructure = false;

    public ModuleTree(DefaultMutableTreeNode elem, ActionListener l) {
        super(new GridLayout(1, 0));
        this.buildContextMenu(l);
        this.buildTree(elem);
    }

    private void buildTree(DefaultMutableTreeNode elem) {
        if (((ModuleTreeElement)elem.getUserObject()).getType().equals("OME-Model")) {
            this.root = elem;
        } else {
            this.root = new DefaultMutableTreeNode(new ModuleTreeElement(null, null));
            this.root.add(elem);
        }
        this.tree = new JTree(this.root);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        treeModel.addTreeModelListener(new ModuleTreeListener());
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger() && ((JComponent)e.getSource()).isEnabled()) {
                    ModuleTree.this.popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private boolean is_selected;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                String type = ((ModuleTreeElement)((DefaultMutableTreeNode)value).getUserObject()).getType();
                this.is_selected = false;
                if (!((DefaultMutableTreeNode)value).isRoot() && !ModuleTree.this.controller.configurationExists(type)) {
                    this.setEnabled(false);
                    this.setDisabledIcon(this.getClosedIcon());
                    if (sel) {
                        this.is_selected = true;
                    }
                }
                return this;
            }

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Color.white);
                int offset = 0;
                if (this.is_selected) {
                    g.drawRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
                    g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
                }
                super.paintComponent(g);
            }
        });
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
    }

    private void filterTree(DefaultMutableTreeNode cTree) {
        Enumeration<TreeNode> e = cTree.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (this.controller.configurationExists(((ModuleTreeElement)node.getUserObject()).getType()) || node.isRoot()) continue;
            this.removeNodeFromParent(node);
        }
    }

    private void buildContextMenu(ActionListener l) {
        this.popup = new JPopupMenu();
        JMenu edit = new JMenu("Edit");
        JMenuItem edit_copy = new JMenuItem("Copy");
        edit_copy.setActionCommand(POPUP_COPY);
        edit_copy.addActionListener(this);
        JMenuItem edit_paste = new JMenuItem("Paste");
        edit_paste.setActionCommand(POPUP_PASTE);
        edit_paste.addActionListener(this);
        JMenuItem edit_delete = new JMenuItem("Delete");
        edit_delete.setActionCommand(POPUP_DEL);
        edit_delete.addActionListener(l);
        edit.add(edit_copy);
        edit.add(edit_paste);
        edit.add(edit_delete);
        this.insert = new JMenu("Insert Node");
        this.insert.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ModuleTree.this.insert.removeAll();
                ModuleTree.this.addMenuItems(null);
                ModuleTree.this.insert.revalidate();
                ModuleTree.this.insert.repaint();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.popup.add(this.insert);
        this.popup.add(edit);
    }

    protected void addMenuItems(DefaultMutableTreeNode current) {
        String[] list;
        if (current == null) {
            current = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        }
        if (((ModuleTreeElement)current.getUserObject()).getType().equals("OME-Model")) {
            JMenuItem node = new JMenuItem("Standard tree");
            node.setActionCommand(POPUP_INSERT_ALL);
            node.addActionListener(this);
            this.insert.add(node);
        }
        if ((list = this.controller.getPossibleChilds(((ModuleTreeElement)current.getUserObject()).getType())) != null && list.length > 0) {
            for (String s : list) {
                JMenuItem node = new JMenuItem(s);
                node.setActionCommand(POPUP_INSERT);
                node.addActionListener(this);
                this.insert.add(node);
            }
        } else {
            JMenuItem node = new JMenuItem("No childs to insert");
            this.insert.add(node);
        }
    }

    private String getName(DefaultMutableTreeNode thisElem) {
        return thisElem.getUserObject().toString();
    }

    private DefaultMutableTreeNode addNode(DefaultMutableTreeNode parent, DefaultMutableTreeNode thisElem) {
        if (parent == null) {
            parent = this.getRoot();
        }
        String pType = ((ModuleTreeElement)parent.getUserObject()).getType();
        if (thisElem != null && thisElem.getUserObject() != null) {
            if (pType.equals("OME-Model") || this.controller.configurationExists(pType)) {
                if (((ModuleTreeElement)thisElem.getUserObject()).getData() != null) {
                    if (((ModuleTreeElement)thisElem.getUserObject()).getData().hasParent(pType)) {
                        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] addNode: " + this.getName(thisElem) + " at " + parent.getUserObject().toString());
                        this.changeTreeStructure = true;
                        ((ModuleTreeElement)thisElem.getUserObject()).setChildIndex(parent);
                        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(thisElem, parent, parent.getChildCount());
                        if (thisElem != null && this.tree != null) {
                            this.tree.scrollPathToVisible(new TreePath(thisElem.getPath()));
                        }
                        return thisElem;
                    }
                    ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't insert node at selected parent! Allowed parents: " + Arrays.toString(((ModuleTreeElement)thisElem.getUserObject()).getData().getParents()));
                } else {
                    ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't insert node, content data empty");
                }
            } else {
                ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't insert node, content not configurated for selected mic");
            }
        } else {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] can't insert node, given new element is empty");
        }
        return null;
    }

    public void reset(DefaultMutableTreeNode elem, ModuleController controller) {
        this.controller = controller;
        this.removeAll();
        this.changeTreeStructure = true;
        this.buildTree(elem);
        this.revalidate();
        this.repaint();
    }

    public void customizeTree(String micName) {
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] load custom tree for " + micName);
        HashMap<String, ModuleConfiguration> confMap = this.controller.getMDEConfiguration().getConfiguratedObjects(micName);
        DefaultMutableTreeNode cTree = this.getRoot();
        if (confMap != null) {
            for (Map.Entry<String, ModuleConfiguration> entry : confMap.entrySet()) {
                if (entry.getValue() == null) continue;
                this.insertCustomizeNode(entry.getKey(), entry.getValue(), cTree, confMap);
            }
        }
    }

    private void insertCustomizeNode(String nodeType, ModuleConfiguration nodeConf, DefaultMutableTreeNode cTree, HashMap<String, ModuleConfiguration> confMap) {
        if (MDEHelper.getChildByName(cTree, nodeType) == null && nodeConf.isInsertInTree()) {
            String pType = nodeConf.getInsertPoint();
            List<DefaultMutableTreeNode> insertAtNodeList = MDEHelper.getChildsByType(cTree, pType);
            if (insertAtNodeList != null) {
                for (DefaultMutableTreeNode insertAtNode : insertAtNodeList) {
                    if (MDEHelper.getListOfChilds(nodeType, insertAtNode) != null) continue;
                    ModuleContent c = this.controller.getContentOfType(nodeType);
                    ModuleTreeElement choice = null;
                    choice = c != null && c.getList() == null ? new ModuleTreeElement(c, insertAtNode) : new ModuleTreeElement(nodeType, null, "", c, insertAtNode);
                    this.addNode(insertAtNode, new DefaultMutableTreeNode(choice));
                }
            } else if (confMap.containsKey(pType) && confMap.get(pType) != null) {
                this.insertCustomizeNode(pType, confMap.get(pType), cTree, confMap);
                this.insertCustomizeNode(nodeType, nodeConf, cTree, confMap);
            }
        }
    }

    public void removeNodeFromParent(DefaultMutableTreeNode current) {
        if (this.tree == null) {
            return;
        }
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(current);
    }

    public void pasteNode(DefaultMutableTreeNode node) {
        this.changeTreeStructure = true;
        DefaultMutableTreeNode cNode = this.insertNode(node);
    }

    public DefaultMutableTreeNode insertNode(String type) {
        this.changeTreeStructure = true;
        TreePath parentPath = this.tree.getSelectionPath();
        DefaultMutableTreeNode parent = this.getRoot();
        if (parentPath != null) {
            parent = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        }
        ModuleContent c = this.controller.getContentOfType(type);
        ModuleTreeElement choice = null;
        choice = c.getList() == null ? new ModuleTreeElement(c, parent) : new ModuleTreeElement(type, null, "", c, parent);
        return this.addNode(parent, new DefaultMutableTreeNode(choice));
    }

    public DefaultMutableTreeNode insertNode(DefaultMutableTreeNode node) {
        this.changeTreeStructure = true;
        if (node == null) {
            return null;
        }
        TreePath parentPath = this.tree.getSelectionPath();
        DefaultMutableTreeNode pNode = this.getRoot();
        if (parentPath != null) {
            pNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        }
        DefaultMutableTreeNode cNode = this.addNode(pNode, node);
        return cNode;
    }

    public void addTreeSelectionListener(MDEContent mdeContent) {
        if (this.tree == null) {
            return;
        }
        this.tree.addTreeSelectionListener(mdeContent);
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        if (this.tree == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public static void printTree(DefaultMutableTreeNode node, String title) {
        if (node == null) {
            ImporterAgent.getRegistry().getLogger().debug(null, title + " EMPTY");
            return;
        }
        try {
            ImporterAgent.getRegistry().getLogger().debug(null, title + node.getUserObject().toString());
            for (int i = 0; i < node.getChildCount(); ++i) {
                ModuleTree.printTree((DefaultMutableTreeNode)node.getChildAt(i), title + "  ");
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                ModuleTree.printTree((DefaultMutableTreeNode)node.getChildAt(i), title + "  ");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        TreePath selectedNode = this.tree.getSelectionPath();
        DefaultMutableTreeNode current = null;
        if (selectedNode != null && (current = (DefaultMutableTreeNode)selectedNode.getLastPathComponent()) == null) {
            return;
        }
        if (POPUP_COPY.equals(cmd)) {
            this.copyVal = current;
        }
        if (POPUP_PASTE.equals(cmd) && this.copyVal != null) {
            this.pasteNode(ModuleTree.cloneTreeNode(this.copyVal));
        }
        if (POPUP_INSERT.equals(cmd)) {
            this.insertNode(((JMenuItem)e.getSource()).getText());
        }
        if (POPUP_INSERT_ALL.equals(cmd)) {
            DefaultMutableTreeNode tree = this.controller.getTree();
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.insertNode((DefaultMutableTreeNode)tree.getChildAt(i));
            }
        }
    }

    public static DefaultMutableTreeNode cloneTreeNode(DefaultMutableTreeNode node) {
        if (node == null || !(node.getUserObject() instanceof ModuleTreeElement)) {
            return null;
        }
        DefaultMutableTreeNode cloneNode = new DefaultMutableTreeNode(new ModuleTreeElement((ModuleTreeElement)node.getUserObject()));
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = ModuleTree.cloneTreeNode((DefaultMutableTreeNode)node.getChildAt(i));
            if (child == null) continue;
            cloneNode.add(child);
        }
        return cloneNode;
    }

    public DefaultMutableTreeNode getRoot() {
        if (this.tree == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean changeTreeStructure() {
        return this.changeTreeStructure;
    }

    public void setChangeTreeStructure(boolean val) {
        this.changeTreeStructure = val;
    }

    class ModuleTreeListener
    implements TreeModelListener {
        ModuleTreeListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            int index = e.getChildIndices()[0];
            node = (DefaultMutableTreeNode)node.getChildAt(index);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

