/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.configuration;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionListener;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.MDEConfiguration;

public class ObjectList_Panel
extends JPanel
implements ActionListener {
    private static final String CMD_NEW_OBJ = "create new object";
    private static final String CMD_DEL_OBJ = "delete selected object";
    private static final String CMD_ADD_OBJ = "add object";
    private JList objList;
    private String mic;
    private MDEConfiguration conf;
    private JComboBox<String> objects;

    public ObjectList_Panel(String mic, DefaultListModel<String> listModel, ListSelectionListener selectListener, MDEConfiguration conf) {
        super(new BorderLayout());
        this.removeAll();
        this.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.black), "Objects"));
        this.mic = mic;
        this.conf = conf;
        this.objList = new JList<String>(listModel);
        this.objList.setSelectionMode(0);
        this.objList.addListSelectionListener(selectListener);
        if (!listModel.isEmpty()) {
            this.objList.setSelectedIndex(0);
        }
        this.objList.setVisibleRowCount(10);
        JScrollPane listScrollPane = new JScrollPane(this.objList);
        this.add((Component)listScrollPane, "Center");
        JButton btnDelObj = new JButton("Delete");
        btnDelObj.setActionCommand(CMD_DEL_OBJ);
        btnDelObj.addActionListener(this);
        JPanel newObjPane = new JPanel();
        JButton btnNewObj = new JButton("New");
        btnNewObj.setActionCommand(CMD_NEW_OBJ);
        btnNewObj.addActionListener(this);
        btnNewObj.setEnabled(false);
        JButton btnAddObj = new JButton("Add");
        btnAddObj.setActionCommand(CMD_ADD_OBJ);
        btnAddObj.addActionListener(this);
        btnAddObj.setEnabled(false);
        JPanel btnPanelObj = new JPanel(new FlowLayout(2));
        btnPanelObj.add(btnNewObj);
        btnPanelObj.add(btnAddObj);
        btnPanelObj.add(btnDelObj);
        newObjPane.setLayout(new BorderLayout());
        newObjPane.add((Component)btnPanelObj, "East");
        this.add((Component)newObjPane, "South");
        this.revalidate();
        this.repaint();
    }

    private void addObject(String objectName) {
        this.conf.addConfiguration(this.mic, objectName, this.conf.getConfiguration("Universal", objectName));
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        listModel.addElement(objectName);
        this.objList.setSelectedIndex(listModel.getSize() - 1);
        this.objList.revalidate();
        this.objList.repaint();
        this.revalidate();
        this.repaint();
    }

    private void createNewObject(String obj) {
        this.conf.createNewObject(this.mic, obj);
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        listModel.addElement(obj);
        this.objList.setSelectedIndex(listModel.getSize() - 1);
        this.objList.revalidate();
        this.objList.repaint();
        this.revalidate();
        this.repaint();
    }

    private void deleteObject() {
        String objName = (String)this.objList.getSelectedValue();
        DefaultListModel listModel = (DefaultListModel)this.objList.getModel();
        int objIndex = this.objList.getSelectedIndex();
        ImporterAgent.getRegistry().getLogger().debug((Object)this, "[MDE] DELETE [" + this.mic + "::" + objName + "]: on index " + objIndex + "/" + listModel.getSize());
        listModel.remove(objIndex);
        this.conf.removeObjectForMicroscope(objName, this.mic);
        this.objList.setSelectedIndex(0);
    }

    public String getSelectedValue() {
        if (this.objList.getSelectedIndex() != -1) {
            return (String)this.objList.getSelectedValue();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "add object": {
                String obj = String.valueOf(this.objects.getSelectedItem());
                this.addObject(obj);
                break;
            }
            case "create new object": {
                break;
            }
            case "delete selected object": {
                this.deleteObject();
            }
        }
    }

    public void setSelectedIndex(int i) {
        if (!((DefaultListModel)this.objList.getModel()).isEmpty()) {
            this.objList.setSelectedIndex(i);
        }
    }
}

