/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.util.Collection;
import omero.gateway.SecurityContext;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.data.Tile;

public class TileLoader
extends DataLoader {
    private CallHandle handle;
    private Collection<Tile> tiles;
    private long pixelsID;
    private PlaneDef pDef;
    private int count;
    private RenderingControl proxy;

    public TileLoader(ImViewer viewer, SecurityContext ctx, long pixelsID, PlaneDef pDef, RenderingControl proxy, Collection<Tile> tiles) {
        super(viewer, ctx);
        if (tiles == null || tiles.size() == 0) {
            throw new IllegalArgumentException("No tiles to load.");
        }
        if (pDef == null) {
            throw new IllegalArgumentException("No plane to render.");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("No rendering control.");
        }
        if (pixelsID != proxy.getPixelsID()) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.tiles = tiles;
        this.pixelsID = pixelsID;
        this.pDef = pDef;
        this.proxy = proxy;
    }

    @Override
    public void load() {
        this.handle = this.ivView.loadTiles(this.ctx, this.pixelsID, this.pDef, this.proxy, this.tiles, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Tile Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError(s, s, exc);
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5) {
            return;
        }
        String status = fe.getStatus();
        int percDone = fe.getPercentDone();
        if (status == null) {
            status = percDone == 100 ? "" : "";
        }
        this.viewer.setStatus(status, percDone);
        Tile tile = (Tile)fe.getPartialResult();
        if (tile != null) {
            ++this.count;
            if (this.count == this.tiles.size()) {
                this.viewer.setTileCount(this.count);
            } else {
                this.viewer.setTileCount(0);
            }
        }
    }
}

