/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.imviewer.browser.BirdEyeViewComponent;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserBICanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvasListener;

class BrowserUI
extends JScrollPane
implements AdjustmentListener {
    private JLayeredPane layeredPane;
    private JComponent canvas;
    private BrowserModel model;
    private BrowserControl controller;
    private ImageCanvasListener canvasListener;
    private Map<Integer, JComponent> siblings = new HashMap<Integer, JComponent>();
    private boolean adjusting;
    private BirdEyeViewComponent birdEyeView;
    private JPanel glass;

    private void setBirdEyeViewLocation() {
        if (this.birdEyeView == null) {
            return;
        }
        Rectangle r = this.getVisibleRectangle();
        Point p = new Point(0, 0);
        p = SwingUtilities.convertPoint(this.getViewport(), p, this.glass);
        switch (this.birdEyeView.getLocationIndex()) {
            case 1: {
                Dimension d = this.birdEyeView.getSize();
                p = new Point(p.x + r.width - d.width, p.y + r.height - d.height);
                this.birdEyeView.setLocation(p);
                break;
            }
            default: {
                this.birdEyeView.setLocation(p);
            }
        }
    }

    private Rectangle convertFromSelection(Rectangle region) {
        Dimension d = this.birdEyeView.getImageSize();
        Rectangle rl = this.canvas.getBounds();
        int sizeX = rl.width;
        int sizeY = rl.height;
        double vx = sizeX / d.width;
        double vy = sizeY / d.height;
        int x = (int)(vx * (double)region.x);
        int y = (int)(vy * (double)region.y);
        int w = (int)(vx * (double)region.width);
        int h = (int)(vy * (double)region.height);
        return new Rectangle(x, y, w, h);
    }

    private void displaySelectedRegion(Rectangle region, boolean load) {
        if (region == null) {
            return;
        }
        Rectangle r = this.convertFromSelection(region);
        this.getViewport().setViewPosition(new Point(-1, -1));
        this.scrollTo(r, false);
        if (load) {
            this.model.loadTiles(null);
        }
    }

    private void setSelectionRegion() {
        if (this.birdEyeView == null) {
            return;
        }
        Dimension d = this.birdEyeView.getImageSize();
        if (d.width == 0 || d.height == 0) {
            return;
        }
        Rectangle rect = this.getVisibleRectangle();
        int sizeX = this.model.getTiledImageSizeX();
        int sizeY = this.model.getTiledImageSizeY();
        int rx = sizeX / d.width;
        int ry = sizeY / d.height;
        if (rx == 0) {
            rx = 1;
        }
        if (ry == 0) {
            ry = 1;
        }
        int w = rect.width / rx;
        int h = rect.height / ry;
        int x = rect.x / rx;
        int y = rect.y / ry;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.birdEyeView.setSelection(x, y, w, h);
    }

    private void center() {
        JComponent sibling;
        Rectangle r = this.getVisibleRectangle();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (hBar.isVisible()) {
            xLoc = this.layeredPane.getX();
        }
        if (vBar.isVisible()) {
            yLoc = this.layeredPane.getY();
        }
        if ((sibling = this.siblings.get(this.model.getSelectedIndex())) != null) {
            sibling.setBounds(sibling.getBounds());
        }
        this.layeredPane.setBounds(xLoc, yLoc, d.width, d.height);
        this.setBirdEyeViewLocation();
    }

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.canvas = new BrowserBICanvas(this.model, this);
        this.layeredPane.add((Component)this.canvas, (Object)0);
        this.canvasListener = new ImageCanvasListener(this, this.model, this.canvas);
        this.canvasListener.setHandleKeyDown(true);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                BrowserUI.this.installScrollbarListener(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BrowserUI.this.installScrollbarListener(true);
            }
        };
        this.getVerticalScrollBar().addMouseListener(adapter);
        this.getHorizontalScrollBar().addMouseListener(adapter);
    }

    private void buildGUI() {
        JViewport viewport = this.getViewport();
        viewport.setLayout(null);
        viewport.setBackground(this.model.getBackgroundColor());
        viewport.add(this.layeredPane);
    }

    private boolean scrollbarsVisible() {
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (hBar.isVisible()) {
            return true;
        }
        return vBar.isVisible();
    }

    BrowserUI() {
    }

    void initialize(BrowserControl controller, BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setSibling(int index, JComponent sibling) {
        this.siblings.put(index, sibling);
    }

    void addComponentToLayer(Component c, boolean reset) {
        int i;
        Component[] components = this.layeredPane.getComponents();
        for (i = 0; i < components.length; ++i) {
            if (components[i] != c) continue;
            return;
        }
        if (reset) {
            for (i = 0; i < components.length; ++i) {
                if (components[i] == this.canvas) continue;
                this.layeredPane.remove(components[i]);
            }
            this.layeredPane.add(c, (Object)1);
            for (i = 0; i < components.length; ++i) {
                if (components[i] == this.canvas) continue;
                this.layeredPane.add(components[i], (Object)1);
            }
        } else {
            this.layeredPane.add(c, (Object)1);
        }
    }

    void setBirdEyeView(BufferedImage image) {
        boolean init = false;
        if (this.birdEyeView == null) {
            this.birdEyeView = new BirdEyeViewComponent(1);
            this.birdEyeView.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if ("displayRegion".equals(name)) {
                        BrowserUI.this.displaySelectedRegion((Rectangle)evt.getNewValue(), true);
                    } else if ("fullDisplay".equals(name)) {
                        BrowserUI.this.setBirdEyeViewLocation();
                    }
                }
            });
            this.birdEyeView.setup(0, 0);
            JFrame frame = this.model.getParentModel().getUI();
            this.glass = (JPanel)frame.getGlassPane();
            this.glass.setLayout(null);
            this.glass.add(this.birdEyeView);
            this.glass.setVisible(true);
            this.setBirdEyeViewLocation();
            init = true;
        }
        this.birdEyeView.setImage(image);
        if (init && image != null) {
            int width = image.getWidth();
            int height = image.getHeight();
            Rectangle r = this.getVisibleRectangle();
            int sizeX = this.model.getTiledImageSizeX();
            int sizeY = this.model.getTiledImageSizeY();
            int rx = sizeX / width;
            int ry = sizeY / height;
            if (rx == 0) {
                rx = 1;
            }
            if (ry == 0) {
                ry = 1;
            }
            int w = r.width / rx;
            int h = r.height / ry;
            int x = (width - w) / 2;
            int y = (height - h) / 2;
            this.birdEyeView.setSelection(x, y, w, h);
            r = this.birdEyeView.getSelectionRegion();
            this.displaySelectedRegion(r, false);
        }
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    void paintMainImage() {
        if (this.model.getRenderedImage() == null) {
            return;
        }
        this.model.createDisplayedImage();
        BufferedImage img = this.model.getDisplayedImage();
        if (img == null) {
            return;
        }
        this.canvasListener.setAreaSize(img.getWidth(), img.getHeight());
        this.canvas.repaint();
    }

    void zoomImage() {
        this.adjusting = false;
        if (this.model.getRenderedImage() == null) {
            return;
        }
        this.model.createDisplayedImage();
        BufferedImage img = this.model.getDisplayedImage();
        if (img == null) {
            return;
        }
        this.setComponentsSize(img.getWidth(), img.getHeight());
        this.canvasListener.setAreaSize(img.getWidth(), img.getHeight());
        this.getViewport().setViewPosition(new Point(-1, -1));
        this.canvas.repaint();
        this.setBounds(this.getBounds());
        this.getViewport().setViewPosition(new Point(-1, -1));
        this.canvas.repaint();
        this.setBounds(this.getBounds());
    }

    void setComponentsSize(int w, int h) {
        Dimension d = new Dimension(w, h);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
        if (this.model.isBigImage()) {
            Rectangle r = this.getVisibleRectangle();
            d = this.layeredPane.getPreferredSize();
            if (d.width < r.width && d.height < r.height) {
                this.center();
            }
        }
    }

    Dimension getViewportSize() {
        return this.getViewport().getSize();
    }

    private void installScrollbarListener(boolean add) {
        if (add) {
            this.getHorizontalScrollBar().addAdjustmentListener(this);
            this.getVerticalScrollBar().addAdjustmentListener(this);
        } else {
            this.getHorizontalScrollBar().removeAdjustmentListener(this);
            this.getVerticalScrollBar().removeAdjustmentListener(this);
        }
    }

    void pan(int x, int y, boolean load) {
        Rectangle r = this.getVisibleRectangle();
        if (r.contains(this.canvas.getBounds())) {
            return;
        }
        int vx = r.x;
        int vy = r.y;
        if (x < 0) {
            vx += -x;
        }
        if (x > 0) {
            vx -= x;
        }
        if (y < 0) {
            vy += -y;
        }
        if (y > 0) {
            vy -= y;
        }
        this.getViewport().setViewPosition(new Point(vx, vy));
        this.setSelectionRegion();
        this.setBirdEyeViewLocation();
        if (load) {
            this.model.loadTiles(this.getVisibleRectangle());
        }
    }

    void setSelectedRegion(Rectangle region) {
        this.scrollTo(region, false);
        this.setSelectionRegion();
        this.setBirdEyeViewLocation();
        this.model.loadTiles(this.getVisibleRectangle());
    }

    void scrollTo(Rectangle bounds, boolean blockIncrement) {
        Rectangle viewRect = this.getVisibleRectangle();
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        int x = 0;
        int y = 0;
        if (!viewRect.contains(bounds)) {
            int deltaX = viewRect.x - bounds.x;
            int deltaY = viewRect.y - bounds.y;
            if (deltaX < 0 && blockIncrement) {
                x = hBar.getValue() + hBar.getBlockIncrement();
            } else {
                int w = viewRect.width - bounds.width;
                if (w < 0) {
                    w = -w;
                }
                x = bounds.x - w / 2;
            }
            if (deltaY < 0 && blockIncrement) {
                y = vBar.getValue() + vBar.getBlockIncrement();
            } else {
                int h = viewRect.height - bounds.height;
                if (h < 0) {
                    h = -h;
                }
                y = bounds.y - h / 2;
            }
        } else {
            if (blockIncrement) {
                return;
            }
            int w = viewRect.width - bounds.width;
            if (w < 0) {
                w = -w;
            }
            x = bounds.x - w / 2;
            int h = viewRect.height - bounds.height;
            if (h < 0) {
                h = -h;
            }
            y = bounds.y - h / 2;
        }
        vBar.setValue(y);
        hBar.setValue(x);
        this.setBirdEyeViewLocation();
    }

    void scrollTo(int vValue, int hValue) {
        JScrollBar vBar = this.getVerticalScrollBar();
        JScrollBar hBar = this.getHorizontalScrollBar();
        hBar.setValue(hBar.getValue() + hValue);
        vBar.setValue(vBar.getValue() + vValue);
        this.setBirdEyeViewLocation();
    }

    void clearGridImages() {
        this.model.clearGridImages();
    }

    boolean isAdjusting() {
        return this.adjusting;
    }

    void locateScrollBars() {
        if (!this.scrollbarsVisible()) {
            return;
        }
        this.scrollTo(this.getVisibleRectangle(), false);
    }

    int getBirdEyeViewLocationIndex() {
        if (this.birdEyeView == null) {
            return -1;
        }
        return this.birdEyeView.getLocationIndex();
    }

    void onComponentResized() {
        this.adjusting = false;
        this.center();
        this.setSelectionRegion();
    }

    Rectangle getVisibleRectangle() {
        return this.getViewport().getViewRect();
    }

    void onStateChange(boolean b) {
        JScrollBar bar = this.getHorizontalScrollBar();
        if (bar.isVisible()) {
            bar.setEnabled(b);
        }
        if ((bar = this.getVerticalScrollBar()).isVisible()) {
            bar.setEnabled(b);
        }
        if (this.birdEyeView != null) {
            this.birdEyeView.installListeners(b);
        }
        this.canvasListener.installListeners(b);
    }

    void setViewLocation(double rx, double ry) {
        Dimension d = this.birdEyeView.getImageSize();
        Rectangle r = this.birdEyeView.getSelectionRegion();
        double cx = r.getCenterX();
        double cy = r.getCenterY();
        Rectangle rect = this.getVisibleRectangle();
        int sizeX = this.model.getTiledImageSizeX();
        int sizeY = this.model.getTiledImageSizeY();
        int rxx = sizeX / d.width;
        int ryy = sizeY / d.height;
        if (rxx == 0) {
            rxx = 1;
        }
        if (ryy == 0) {
            ryy = 1;
        }
        int w = rect.width / rxx;
        int h = rect.height / ryy;
        int x = (int)(cx - (double)(w / 2));
        int y = (int)(cy - (double)(h / 2));
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.birdEyeView.setSelection(x, y, w, h);
        this.displaySelectedRegion(this.birdEyeView.getSelectionRegion(), true);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getValueIsAdjusting()) {
            this.adjusting = true;
            this.setBirdEyeViewLocation();
            this.setSelectionRegion();
            return;
        }
        this.adjusting = false;
        this.setBirdEyeViewLocation();
        this.setSelectionRegion();
        this.model.loadTiles(this.getVisibleRectangle());
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Rectangle r = this.getVisibleRectangle();
        Dimension d = this.layeredPane.getPreferredSize();
        if (this.model.isBigImage()) {
            this.setBirdEyeViewLocation();
            if (d.width >= r.width || d.height >= r.height) {
                return;
            }
        }
        if (!this.scrollbarsVisible() && this.adjusting) {
            this.adjusting = false;
        }
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (!hBar.isVisible() || !vBar.isVisible()) {
            this.center();
        }
    }
}

