/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ActivityImageAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ChannelMovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ChannelsSelectionAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ClearHistoryAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.CloseAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorModelAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorPickerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.CompressionAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.DetachAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.HistoryAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.LensAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ManageRndSettingsAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.MetadataAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.MovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PlayMovieAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PreferencesAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ProjectionProjectAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ROIToolAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RefreshAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RendererAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.SaveAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.SaveRndSettingsAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ShowViewAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.TextVisibleAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.UserAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomGridAction;
import org.openmicroscopy.shoola.agents.imviewer.util.PlaneInfoComponent;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.data.model.ScriptActivityParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.ClosableTabbedPaneComponent;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPickerUtil;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class ImViewerControl
implements ActionListener,
ChangeListener,
ComponentListener,
PropertyChangeListener,
WindowFocusListener {
    static final Integer CLOSE = 0;
    static final Integer RENDERER = 1;
    static final Integer MOVIE = 2;
    static final Integer SAVE = 3;
    static final Integer ZOOM_25 = 4;
    static final Integer ZOOM_50 = 5;
    static final Integer ZOOM_75 = 6;
    static final Integer ZOOM_100 = 7;
    static final Integer ZOOM_125 = 8;
    static final Integer ZOOM_150 = 9;
    static final Integer ZOOM_175 = 10;
    static final Integer ZOOM_200 = 11;
    static final Integer ZOOM_225 = 12;
    static final Integer ZOOM_250 = 13;
    static final Integer ZOOM_275 = 14;
    static final Integer ZOOM_300 = 15;
    static final Integer ZOOM_FIT_TO_WINDOW = 16;
    static final Integer LENS = 17;
    static final Integer GREY_SCALE_MODEL = 18;
    static final Integer RGB_MODEL = 19;
    static final Integer HSB_MODEL = 20;
    static final Integer CHANNEL_MOVIE = 26;
    static final Integer UNIT_BAR = 27;
    static final Integer UNIT_BAR_ONE = 28;
    static final Integer UNIT_BAR_TWO = 29;
    static final Integer UNIT_BAR_FIVE = 30;
    static final Integer UNIT_BAR_TEN = 31;
    static final Integer UNIT_BAR_TWENTY = 32;
    static final Integer UNIT_BAR_FIFTY = 33;
    static final Integer UNIT_BAR_HUNDRED = 34;
    static final Integer UNIT_BAR_CUSTOM = 35;
    static final Integer COLOR_PICKER = 36;
    static final Integer TEXT_VISIBLE = 38;
    static final Integer MEASUREMENT_TOOL = 39;
    static final Integer PLAY_MOVIE_T = 44;
    static final Integer PLAY_MOVIE_Z = 45;
    static final Integer PREFERENCES = 47;
    static final Integer USER = 48;
    static final Integer ZOOM_GRID_25 = 49;
    static final Integer ZOOM_GRID_50 = 50;
    static final Integer ZOOM_GRID_75 = 51;
    static final Integer ZOOM_GRID_100 = 52;
    static final Integer TAB_VIEW = 54;
    static final Integer TAB_PROJECTION = 55;
    static final Integer TAB_GRID = 56;
    static final Integer HISTORY = 57;
    static final Integer PASTE_RND_SETTINGS = 58;
    static final Integer COPY_RND_SETTINGS = 59;
    static final Integer SAVE_RND_SETTINGS = 60;
    static final Integer RESET_RND_SETTINGS = 61;
    static final Integer SET_RND_SETTINGS_MIN_MAX = 62;
    static final Integer SET_OWNER_RND_SETTINGS = 63;
    static final Integer UNDO_RND_SETTINGS = 64;
    static final Integer PROJECTION_PROJECT = 66;
    static final Integer COMPRESSION = 67;
    static final Integer CLEAR_HISTORY = 68;
    static final Integer METADATA = 69;
    static final Integer PLAY_LIFETIME_MOVIE = 70;
    static final Integer CHANNELS_ON = 71;
    static final Integer CHANNELS_OFF = 72;
    static final Integer ACTIVITY = 73;
    static final Integer DETACH = 74;
    static final Integer REFRESH = 75;
    private ImViewer model;
    private ImViewerUI view;
    private Map<Integer, ViewerAction> actionsMap;
    private int historyState;
    private int colorPickerIndex;
    private MoviePlayerDialog moviePlayer;
    private ColourPicker colorPicker;

    private void createActions() {
        this.actionsMap.put(RENDERER, new RendererAction(this.model));
        this.actionsMap.put(MOVIE, new MovieAction(this.model));
        this.actionsMap.put(SAVE, new SaveAction(this.model));
        this.actionsMap.put(ZOOM_25, new ZoomAction(this.model, 0));
        this.actionsMap.put(ZOOM_50, new ZoomAction(this.model, 1));
        this.actionsMap.put(ZOOM_75, new ZoomAction(this.model, 2));
        this.actionsMap.put(ZOOM_100, new ZoomAction(this.model, 3));
        this.actionsMap.put(ZOOM_125, new ZoomAction(this.model, 4));
        this.actionsMap.put(ZOOM_150, new ZoomAction(this.model, 5));
        this.actionsMap.put(ZOOM_175, new ZoomAction(this.model, 6));
        this.actionsMap.put(ZOOM_200, new ZoomAction(this.model, 7));
        this.actionsMap.put(ZOOM_225, new ZoomAction(this.model, 8));
        this.actionsMap.put(ZOOM_250, new ZoomAction(this.model, 9));
        this.actionsMap.put(ZOOM_275, new ZoomAction(this.model, 10));
        this.actionsMap.put(ZOOM_300, new ZoomAction(this.model, 11));
        this.actionsMap.put(ZOOM_FIT_TO_WINDOW, new ZoomAction(this.model, 12));
        this.actionsMap.put(LENS, new LensAction(this.model));
        this.actionsMap.put(GREY_SCALE_MODEL, new ColorModelAction(this.model, 0));
        this.actionsMap.put(RGB_MODEL, new ColorModelAction(this.model, 1));
        this.actionsMap.put(HSB_MODEL, new ColorModelAction(this.model, 2));
        this.actionsMap.put(CHANNEL_MOVIE, new ChannelMovieAction(this.model));
        this.actionsMap.put(UNIT_BAR, new UnitBarAction(this.model));
        this.actionsMap.put(UNIT_BAR_ONE, new UnitBarSizeAction(this.model, 0));
        this.actionsMap.put(UNIT_BAR_TWO, new UnitBarSizeAction(this.model, 1));
        this.actionsMap.put(UNIT_BAR_FIVE, new UnitBarSizeAction(this.model, 2));
        this.actionsMap.put(UNIT_BAR_TEN, new UnitBarSizeAction(this.model, 3));
        this.actionsMap.put(UNIT_BAR_TWENTY, new UnitBarSizeAction(this.model, 4));
        this.actionsMap.put(UNIT_BAR_FIFTY, new UnitBarSizeAction(this.model, 5));
        this.actionsMap.put(UNIT_BAR_HUNDRED, new UnitBarSizeAction(this.model, 6));
        this.actionsMap.put(UNIT_BAR_CUSTOM, new UnitBarSizeAction(this.model, 7));
        this.actionsMap.put(COLOR_PICKER, new ColorPickerAction(this.model));
        this.actionsMap.put(TEXT_VISIBLE, new TextVisibleAction(this.model));
        this.actionsMap.put(MEASUREMENT_TOOL, new ROIToolAction(this.model));
        this.actionsMap.put(PLAY_MOVIE_T, new PlayMovieAction(this.model, 301));
        this.actionsMap.put(PLAY_MOVIE_Z, new PlayMovieAction(this.model, 300));
        this.actionsMap.put(PREFERENCES, new PreferencesAction(this.model));
        this.actionsMap.put(USER, new UserAction(this.model));
        this.actionsMap.put(ZOOM_GRID_25, new ZoomGridAction(this.model, 0));
        this.actionsMap.put(ZOOM_GRID_50, new ZoomGridAction(this.model, 1));
        this.actionsMap.put(ZOOM_GRID_75, new ZoomGridAction(this.model, 2));
        this.actionsMap.put(ZOOM_GRID_100, new ZoomGridAction(this.model, 3));
        this.actionsMap.put(TAB_VIEW, new ShowViewAction(this.model, 0));
        this.actionsMap.put(TAB_PROJECTION, new ShowViewAction(this.model, 2));
        this.actionsMap.put(TAB_GRID, new ShowViewAction(this.model, 1));
        this.actionsMap.put(HISTORY, new HistoryAction(this.model));
        this.actionsMap.put(PASTE_RND_SETTINGS, new ManageRndSettingsAction(this.model, 1));
        this.actionsMap.put(COPY_RND_SETTINGS, new ManageRndSettingsAction(this.model, 0));
        this.actionsMap.put(SAVE_RND_SETTINGS, new SaveRndSettingsAction(this.model));
        this.actionsMap.put(RESET_RND_SETTINGS, new ManageRndSettingsAction(this.model, 2));
        this.actionsMap.put(SET_OWNER_RND_SETTINGS, new ManageRndSettingsAction(this.model, 4));
        this.actionsMap.put(SET_RND_SETTINGS_MIN_MAX, new ManageRndSettingsAction(this.model, 3));
        this.actionsMap.put(UNDO_RND_SETTINGS, new ManageRndSettingsAction(this.model, 5));
        this.actionsMap.put(PROJECTION_PROJECT, new ProjectionProjectAction(this.model));
        this.actionsMap.put(COMPRESSION, new CompressionAction(this.model));
        this.actionsMap.put(CLEAR_HISTORY, new ClearHistoryAction(this.model));
        this.actionsMap.put(METADATA, new MetadataAction(this.model));
        this.actionsMap.put(CHANNELS_ON, new ChannelsSelectionAction(this.model, true));
        this.actionsMap.put(CHANNELS_OFF, new ChannelsSelectionAction(this.model, false));
        this.actionsMap.put(ACTIVITY, new ActivityImageAction(this.model));
        this.actionsMap.put(CLOSE, new CloseAction(this.model));
        this.actionsMap.put(DETACH, new DetachAction(this.model));
        this.actionsMap.put(REFRESH, new RefreshAction(this.model));
        this.actionsMap.put(PLAY_LIFETIME_MOVIE, new PlayMovieAction(this.model, 303));
    }

    private void attachListeners() {
        this.model.addChangeListener(this);
        this.model.addPropertyChangeListener(this);
        JMenu menu = ImViewerFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImViewerFactory.register((JMenu)source);
                }
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    ImViewerFactory.register((JMenu)source);
                }
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImViewerControl.this.model.close(true);
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                ImViewerControl.this.model.iconified(false);
            }

            @Override
            public void windowIconified(WindowEvent e) {
                ImViewerControl.this.model.iconified(true);
            }
        });
        this.view.getLoadingWindow().addPropertyChangeListener("cancelLoadingProperty", this);
        this.view.addWindowFocusListener(this);
    }

    private void uploadScript() {
    }

    private void downloadScript(ScriptActivityParam param) {
        FileChooser chooser = new FileChooser(this.view, 1, "Download", "Select where to download the file.", null, true);
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(72));
        chooser.setSelectedFileFull(param.getScript().getName());
        chooser.setApproveButtonText("Download");
        final long id = param.getScript().getScriptID();
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File[] files = (File[])evt.getNewValue();
                    File folder = files[0];
                    IconManager icons = IconManager.getInstance();
                    DownloadActivityParam activity = new DownloadActivityParam(id, 0, folder, icons.getIcon(73));
                    UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                    un.notifyActivity(ImViewerControl.this.model.getSecurityContext(), activity);
                }
            }
        });
        chooser.centerDialog();
    }

    ImViewerControl() {
    }

    void initialize(ImViewer model, ImViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.historyState = -1;
        this.colorPickerIndex = -1;
        this.actionsMap = new HashMap<Integer, ViewerAction>();
        this.createActions();
        this.attachListeners();
        ImViewerFactory.attachWindowMenuToTaskBar();
    }

    ViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    ViewerAction getZoomActionFromLevels(int levels) {
        switch (levels) {
            case 1: {
                return this.getAction(ZOOM_50);
            }
            case 2: {
                return this.getAction(ZOOM_75);
            }
            case 3: {
                return this.getAction(ZOOM_100);
            }
            case 4: {
                return this.getAction(ZOOM_125);
            }
            case 5: {
                return this.getAction(ZOOM_150);
            }
            case 7: {
                return this.getAction(ZOOM_200);
            }
            case 8: {
                return this.getAction(ZOOM_225);
            }
            case 9: {
                return this.getAction(ZOOM_250);
            }
            case 10: {
                return this.getAction(ZOOM_275);
            }
            case 11: {
                return this.getAction(ZOOM_300);
            }
        }
        return null;
    }

    void setSelectedXYPlane(int z, int t, int bin) {
        boolean enableSave = z != this.model.getDefaultZ() || t != this.model.getDefaultT();
        this.model.setSelectedXYPlane(z, t, bin);
        if (enableSave) {
            this.actionsMap.get(SAVE_RND_SETTINGS).setEnabled(true);
        }
    }

    int getHistoryState() {
        return this.historyState;
    }

    void setHistoryState(int s) {
        this.historyState = s;
    }

    void showColorPicker(int index) {
        this.colorPickerIndex = index;
        Color c = this.model.getChannelColor(index);
        String lut = this.model.getLookupTable(index);
        boolean revInt = this.model.getReverseIntensity(index);
        Collection<String> luts = this.model.getAvailableLookupTables();
        if (this.colorPicker == null) {
            this.colorPicker = new ColourPicker(this.view, c, luts, lut, revInt);
            this.colorPicker.setPreviewVisible(true);
            this.colorPicker.addPropertyChangeListener(this);
        } else {
            this.colorPicker.reinit(c, null, lut, revInt);
        }
        if (!this.colorPicker.isShowing()) {
            UIUtilities.setLocationRelativeToAndShow(this.view, this.colorPicker);
        }
    }

    MoviePlayerDialog getMoviePlayer() {
        if (this.moviePlayer != null) {
            return this.moviePlayer;
        }
        this.moviePlayer = new MoviePlayerDialog(this.view, this.model);
        this.moviePlayer.addPropertyChangeListener("close", this);
        return this.moviePlayer;
    }

    void setZoomFactor(int zoomIndex) {
        double f = ZoomAction.getZoomFactor(zoomIndex);
        this.model.setZoomFactor(f, zoomIndex);
    }

    void toFront() {
        if (this.view.getExtendedState() != 0) {
            return;
        }
        if (!this.view.isFocused()) {
            this.view.removeWindowFocusListener(this);
            this.view.setVisible(true);
        }
    }

    void setPreferences() {
        int index;
        Rectangle bounds;
        ViewerPreferences pref = ImViewerFactory.getPreferences();
        if (pref == null) {
            pref = new ViewerPreferences();
        }
        if ((bounds = this.view.getBounds()) != null) {
            pref.setViewerBounds(bounds);
        }
        if ((index = this.view.getZoomIndex()) > 0) {
            pref.setZoomIndex(index);
        }
        pref.setRenderer(this.view.isRendererShown());
        pref.setHistory(this.view.isHistoryShown());
        Color c = this.model.getUnitBarColor();
        if (c != null) {
            pref.setScaleBarColor(c);
        }
        if ((index = this.view.getScaleBarIndex()) > 0) {
            pref.setScaleBarIndex(index);
        }
        pref.setInterpolation(this.model.isInterpolation());
        ImViewerFactory.setPreferences(pref);
    }

    void setGridMagnificationFactor(double factor) {
        this.model.setGridMagnificationFactor(factor);
    }

    void setProjectionRange(boolean released) {
        this.view.setLeftStatus();
        this.view.setPlaneInfoStatus();
        if (released) {
            this.model.renderXYPlane();
        }
    }

    void renderOverlays(boolean selected) {
        this.model.renderOverlays(-1, selected);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String m = this.model.getColorModel();
        ViewerAction a = null;
        if ("rgb".equals(m)) {
            a = this.getAction(GREY_SCALE_MODEL);
            a.actionPerformed(e);
        } else if ("greyscale".equals(m)) {
            a = this.getAction(RGB_MODEL);
            a.actionPerformed(e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            Component c = pane.getSelectedComponent();
            if (c instanceof ClosableTabbedPaneComponent) {
                int index = ((ClosableTabbedPaneComponent)c).getIndex();
                this.model.setSelectedPane(index);
            }
            return;
        }
        int state = this.model.getState();
        LoadingWindow window = this.view.getLoadingWindow();
        switch (state) {
            case 7: {
                window.close();
                this.view.setVisible(false);
                if (this.view.isLensVisible()) {
                    this.view.setLensVisible(false, this.model.getSelectedIndex());
                }
                this.view.dispose();
                this.historyState = state;
                break;
            }
            case 17: 
            case 18: {
                if (window.isVisible()) break;
                UIUtilities.centerAndShow(window);
                break;
            }
            case 19: {
                window.setVisible(false);
                break;
            }
            case 3: {
                if (this.historyState == 4) {
                    window.setVisible(false);
                }
                this.view.onStateChange(false);
                window.setVisible(false);
                this.historyState = state;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                this.view.setStatus(true);
                this.view.onStateChange(false);
                break;
            }
            case 6: {
                this.view.setStatus(false);
                window.setVisible(false);
                if (this.historyState == 8) {
                    this.view.onStateChange(false);
                    break;
                }
                this.view.onStateChange(true);
                this.historyState = state;
                break;
            }
            case 15: {
                window.setVisible(false);
                this.view.onStateChange(false);
                break;
            }
            case 8: {
                this.historyState = 8;
                this.view.onStateChange(false);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        String pName = pce.getPropertyName();
        if ("zSelected".equals(pName)) {
            this.view.setZSection((Integer)pce.getNewValue());
        } else if ("tSelected".equals(pName)) {
            this.view.setTimepoint((Integer)pce.getNewValue());
        } else if ("binSelected".equals(pName)) {
            this.view.setBin((Integer)pce.getNewValue());
        } else if ("channelSelected".equals(pName)) {
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Set set = map.entrySet();
            Map.Entry entry = map.entrySet().iterator().next();
            Integer index = (Integer)entry.getKey();
            this.model.setChannelSelection(index, (Boolean)entry.getValue());
        } else if ("channelOverlay".equals(pName)) {
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                return;
            }
            if (map.size() != 1) {
                return;
            }
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                Integer index = (Integer)entry.getKey();
                this.model.renderOverlays(index, (Boolean)entry.getValue());
            }
        } else if ("cancelLoadingProperty".equals(pName)) {
            this.model.cancelInit();
        } else if ("renderPlane".equals(pName)) {
            this.model.renderXYPlane();
        } else if ("rndLoaded".equals(pName)) {
            boolean b = (Boolean)pce.getNewValue();
            this.model.onRndLoaded(b);
        } else if ("channelColor".equals(pName)) {
            this.model.showColorPicker((Integer)pce.getNewValue());
        } else if ("channelColour".equals(pName) || "channelColor".equals(pName)) {
            if (this.view.isSourceDisplayed(pce.getSource())) {
                this.model.showColorPicker((Integer)pce.getNewValue());
            }
        } else if ("colour".equals(pName)) {
            if (this.colorPickerIndex != -1) {
                ColourObject co = (ColourObject)pce.getNewValue();
                ColourObject old = (ColourObject)pce.getOldValue();
                this.handleColorPicker(false, co.preview, this.colorPickerIndex, co.color, old != null ? old.color : null, co.lut, old != null ? old.lut : null, co.revInt);
            }
        } else if ("unitBarValue".equals(pName)) {
            double v = (Double)pce.getNewValue();
            this.model.setUnitBarSize(v);
        } else if ("iconified".equals(pName)) {
            if (this.moviePlayer != null) {
                this.model.playMovie(false, false, -1);
            }
            this.view.onIconified();
        } else if ("lensLocation".equals(pName)) {
            this.view.scrollToNode((Rectangle)pce.getNewValue());
        } else if ("close".equals(pName)) {
            this.model.playMovie(false, false, -1);
        } else if ("movieStateChanged".equals(pName)) {
            boolean b = (Boolean)pce.getNewValue();
            if (!b && !this.getMoviePlayer().isVisible()) {
                PlayMovieAction action = (PlayMovieAction)this.getAction(PLAY_MOVIE_T);
                action.setActionIcon(true);
                action = (PlayMovieAction)this.getAction(PLAY_MOVIE_Z);
                action.setActionIcon(true);
                action = (PlayMovieAction)this.getAction(PLAY_LIFETIME_MOVIE);
                action.setActionIcon(true);
                this.model.playMovie(false, false, -1);
            }
        } else if ("viewerPref".equals(pName)) {
            ViewerPreferences pref;
            Map map = (Map)pce.getNewValue();
            if (map == null) {
                ImViewerFactory.setPreferences(null);
            }
            if ((pref = ImViewerFactory.getPreferences()) == null) {
                pref = new ViewerPreferences();
            }
            pref.setSelectedFields(map);
            ImViewerFactory.setPreferences(pref);
        } else if ("userRndSettings".equals(pName)) {
            ExperimenterData exp = (ExperimenterData)pce.getNewValue();
            this.model.setUserRndSettings(exp);
        } else if ("projection".equals(pName)) {
            this.model.projectImage((ProjectionRef)pce.getNewValue());
        } else if ("planeInfo".equals(pName)) {
            this.view.showPlaneInfoDetails((PlaneInfoComponent)pce.getNewValue());
        } else if ("closedDialog".equals(pName)) {
            this.view.hideAnimation();
        } else if ("loadAll".equals(pName)) {
            this.model.loadAllContainers();
        } else if ("selectedChannel".equals(pName)) {
            int index = (Integer)pce.getNewValue();
            this.model.onChannelSelection(index);
        } else if ("closeRenderer".equals(pName)) {
            PixelsData pixs;
            Object ref = pce.getNewValue();
            ImageData image = null;
            if (ref instanceof ImageData) {
                image = (ImageData)ref;
            } else if (ref instanceof WellSampleData) {
                image = ((WellSampleData)ref).getImage();
            }
            if (image != null && (pixs = image.getDefaultPixels()) != null && pixs.getId() == this.view.getPixelsID()) {
                this.model.discard();
            }
        } else if ("handleScript".equals(pName)) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            ScriptActivityParam p = (ScriptActivityParam)pce.getNewValue();
            int index = p.getIndex();
            ScriptObject script = p.getScript();
            if (index == 3) {
                Environment env = (Environment)ImViewerAgent.getRegistry().lookup("/env");
                Object path = env.getOmeroFilesHome();
                path = (String)path + File.separator + script.getName();
                File f = new File((String)path);
                DownloadAndLaunchActivityParam activity = new DownloadAndLaunchActivityParam(p.getScript().getScriptID(), 0, f, null);
                un.notifyActivity(this.model.getSecurityContext(), activity);
            } else if (index == 2) {
                this.downloadScript(p);
            } else {
                un.notifyActivity(this.model.getSecurityContext(), pce.getNewValue());
            }
        } else if ("uploadScript".equals(pName)) {
            this.uploadScript();
        } else if ("generateFigure".equals(pName)) {
            Object object = pce.getNewValue();
            if (!(object instanceof FigureParam)) {
                return;
            }
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            IconManager icons = IconManager.getInstance();
            ImageIcon icon = icons.getIcon(74);
            ArrayList<Long> ids = new ArrayList<Long>();
            FigureParam param = (FigureParam)object;
            Class<ImageData> klass = null;
            DataObject p = null;
            if (param.getIndex() == 2) {
                klass = ImageData.class;
                p = this.view.getParentObject();
                if (!(p instanceof DatasetData)) {
                    p = null;
                }
                if (p != null) {
                    param.setAnchor(p);
                }
            }
            ids.add(this.view.getImageID());
            if (param.getIndex() != 2) {
                param.setAnchor(p);
            }
            FigureActivityParam activity = new FigureActivityParam(object, ids, klass, 0);
            activity.setIcon(icon);
            un.notifyActivity(this.model.getSecurityContext(), activity);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.model.isBigImage() && this.model.isRendererLoaded()) {
            this.model.loadTiles(null);
        } else if (this.model.isZoomFitToWindow()) {
            this.model.setZoomFactor(-1.0, 12);
        }
        this.view.onComponentResized();
        this.view.maximizeWindow();
        this.setPreferences();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    boolean isInterpolation() {
        return this.model.isInterpolation();
    }

    void setInterpolation(boolean interpolation) {
        this.model.setInterpolation(interpolation);
        ImViewerFactory.setInterpolation(interpolation);
    }

    private void handleColorPicker(boolean reset, boolean preview, int index, Color newColor, Color oldColor, String newLut, String oldLut, boolean revInt) {
        if (reset) {
            this.model.resetLookupTable(index);
            this.model.setChannelColor(index, null, true);
        } else {
            if (!ColourPickerUtil.sameLookuptable(newLut, oldLut)) {
                this.model.setLookupTable(index, newLut, preview);
            }
            if (newColor != null && !ColourPickerUtil.sameColor(newColor, oldColor)) {
                this.model.setChannelColor(index, newColor, preview);
            }
            this.model.setReverseIntensity(index, revInt, preview);
        }
    }
}

