/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;

public class ROIAction
extends AbstractAction {
    protected ROIActionController.CreationActionType action;
    protected ROIActionController controller;

    private void setName(String name) {
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    private void setToolTip(String name) {
        this.putValue("LongDescription", name);
    }

    public ROIAction(ROIActionController controller, ROIActionController.CreationActionType action) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (action == null) {
            throw new IllegalArgumentException("No Action type specified.");
        }
        this.controller = controller;
        this.action = action;
        this.setEnabled(false);
        switch (action) {
            case DUPLICATE: {
                this.setName("Duplicate");
                this.setToolTip("Duplicate the selected ROI, ROIShapes, creating new ROI.");
                break;
            }
            case DELETE: {
                this.setName("Delete");
                this.setToolTip("Delete selected ROI and ROIShapes.");
                break;
            }
            case MERGE: {
                this.setName("Merge");
                this.setToolTip("Merge the selected ROIShapes into a new ROI.");
                break;
            }
            case SPLIT: {
                this.setName("Split");
                this.setToolTip("Split the selected ROIShapes from parent ROI into a new ROI.");
                break;
            }
            case PROPAGATE: {
                this.setName("Propagate");
                this.setToolTip("Propagate the selected ROI through Time and Z Sections.");
                break;
            }
            case TAG: {
                this.setName("Tag");
                this.setToolTip("Tag the selected shapes.");
                break;
            }
            case ADD_TO_FOLDER: {
                this.setName("Add to Folder");
                this.setToolTip("Adds the ROIs to specific Folders.");
                break;
            }
            case REMOVE_FROM_FOLDER: {
                this.setName("Remove from Folder");
                this.setToolTip("Removes the ROIs from specific Folders.");
                break;
            }
            case CREATE_FOLDER: {
                this.setName("Create Folder");
                this.setToolTip("Creates a new Folder.");
                break;
            }
            case DELETE_FOLDER: {
                this.setName("Delete Folder");
                this.setToolTip("Deletes the Folder.");
                break;
            }
            case EDIT_FOLDER: {
                this.setName("Edit Folder");
                this.setToolTip("Edit Folder.");
                break;
            }
            case MOVE_FOLDER: {
                this.setName("Move Folder");
                this.setToolTip("Move Folder to another Folder.");
            }
        }
    }

    public ROIActionController.CreationActionType getCreationActionType() {
        return this.action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.action) {
            case DUPLICATE: {
                this.controller.duplicateROI();
                break;
            }
            case DELETE: {
                this.controller.deleteROI();
                break;
            }
            case MERGE: {
                this.controller.mergeROI();
                break;
            }
            case SPLIT: {
                this.controller.splitROI();
                break;
            }
            case PROPAGATE: {
                this.controller.propagateROI();
                break;
            }
            case TAG: {
                this.controller.loadTags();
                break;
            }
            case ADD_TO_FOLDER: {
                this.controller.addToFolder();
                break;
            }
            case REMOVE_FROM_FOLDER: {
                this.controller.removeFromFolder();
                break;
            }
            case CREATE_FOLDER: {
                this.controller.createFolder();
                break;
            }
            case DELETE_FOLDER: {
                this.controller.deleteFolder();
                break;
            }
            case EDIT_FOLDER: {
                this.controller.editFolder();
                break;
            }
            case MOVE_FOLDER: {
                this.controller.moveFolder();
            }
        }
    }
}

