/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import omero.gateway.model.ChannelData;
import omero.gateway.model.FolderData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ROIResult;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageViewport;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.view.CalculationWizard;
import org.openmicroscopy.shoola.agents.measurement.view.GraphPane;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityResultsView;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityView;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementResults;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectInspector;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectManager;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistant;
import org.openmicroscopy.shoola.agents.measurement.view.ServerROITable;
import org.openmicroscopy.shoola.agents.measurement.view.StatusBar;
import org.openmicroscopy.shoola.agents.measurement.view.ToolBar;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.views.calls.ROIFolderSaver;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.filter.file.JPEGFilter;
import org.openmicroscopy.shoola.util.filter.file.PNGFilter;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureMaskFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class MeasurementViewerUI
extends TopWindow {
    static final String RETRIEVE_MSG = "Cannot retrieve the ROI";
    static final String CREATE_MSG = "Cannot create the ROI";
    static final String DELETE_MSG = "Cannot delete the ROI";
    static final String UNKNOWN_MSG = "An unknown error occurred in ";
    static final String DEFAULT_MSG = "";
    private static final Dimension DEFAULT_SIZE = new Dimension(500, 300);
    private static final String WINDOW_TITLE = "";
    public static final int INSPECTOR_INDEX = 0;
    public static final int MANAGER_INDEX = 1;
    public static final int RESULTS_INDEX = 2;
    public static final int GRAPH_INDEX = 3;
    public static final int INTENSITY_INDEX = 4;
    public static final int CALCWIZARD_INDEX = 5;
    public static final int INTENSITYRESULTVIEW_INDEX = 6;
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private MeasurementViewer component;
    private LoadingWindow loadingWindow = new LoadingWindow(this);
    private ToolBar toolBar;
    private ObjectInspector roiInspector;
    private ObjectManager roiManager;
    private MeasurementResults roiResults;
    private GraphPane graphPane;
    private IntensityView intensityView;
    private IntensityResultsView intensityResultsView;
    private CalculationWizard calcWizard;
    private JTabbedPane tabs;
    private StatusBar statusBar;
    private JCheckBoxMenuItem createMultipleFigure;
    private JCheckBoxMenuItem createSingleFigure;
    private List<ServerROITable> roiTables;
    private JMenuBar mainMenu;
    private boolean showGraph = true;

    private void scrollToFigure(ROIFigure figure) {
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        bus.post(new ImageViewport(this.model.getImageID(), this.model.getPixelsID(), figure.getBounds().getBounds()));
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createControlsMenu());
        menuBar.add(this.createOptionsMenu());
        TaskBar tb = MeasurementAgent.getRegistry().getTaskBar();
        menuBar.add(tb.getMenu(0));
        menuBar.add(tb.getMenu(1));
        return menuBar;
    }

    private JMenu createControlsMenu() {
        JMenu menu = new JMenu("Controls");
        menu.setMnemonic(67);
        MeasurementViewerAction a = this.controller.getAction(MeasurementViewerControl.LOAD);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getName());
        item.setVisible(false);
        menu.add(item);
        a = this.controller.getAction(MeasurementViewerControl.SAVE);
        item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        a = this.controller.getAction(MeasurementViewerControl.ROI_ASSISTANT);
        item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        return menu;
    }

    private JMenu createOptionsMenu() {
        JCheckBoxMenuItem item;
        MeasurementViewerAction a;
        JMenu menu = new JMenu("Options");
        ButtonGroup displayUnits = new ButtonGroup();
        menu.setMnemonic(79);
        JMenu subMenu = new JMenu("Units");
        if (this.model.sizeInMicrons()) {
            a = this.controller.getAction(MeasurementViewerControl.IN_MICRONS);
            item = new JCheckBoxMenuItem(a);
            item.setText(a.getName());
            displayUnits.add(item);
            subMenu.add(item);
            item.setSelected(true);
        }
        this.model.showMeasurementsInMicrons(this.model.sizeInMicrons());
        a = this.controller.getAction(MeasurementViewerControl.IN_PIXELS);
        item = new JCheckBoxMenuItem(a);
        item.setText(a.getName());
        displayUnits.add(item);
        subMenu.add(item);
        if (!this.model.sizeInMicrons()) {
            item.setSelected(true);
        }
        menu.add(subMenu);
        ButtonGroup createFigureGroup = new ButtonGroup();
        JMenu creationMenu = new JMenu("ROI Creation");
        a = this.controller.getAction(MeasurementViewerControl.CREATE_SINGLE_FIGURE);
        this.createSingleFigure = new JCheckBoxMenuItem(a);
        this.createSingleFigure.setText(a.getName());
        createFigureGroup.add(this.createSingleFigure);
        creationMenu.add(this.createSingleFigure);
        a = this.controller.getAction(MeasurementViewerControl.CREATE_MULTIPLE_FIGURES);
        this.createMultipleFigure = new JCheckBoxMenuItem(a);
        this.createMultipleFigure.setText(a.getName());
        createFigureGroup.add(this.createMultipleFigure);
        creationMenu.add(this.createMultipleFigure);
        this.createMultipleFigure.setSelected(true);
        menu.add(creationMenu);
        return menu;
    }

    private void initComponents() {
        this.showGraph = !this.model.isBigImage() && this.hasStatsInfo();
        this.roiTables = new ArrayList<ServerROITable>();
        this.statusBar = new StatusBar();
        this.toolBar = new ToolBar(this.component, this, this.controller, this.model);
        this.roiManager = new ObjectManager(this, this.controller, this.model);
        this.roiInspector = new ObjectInspector(this.controller, this.model);
        this.roiResults = new MeasurementResults(this.controller, this.model, this);
        if (this.showGraph) {
            this.graphPane = new GraphPane(this, this.controller, this.model);
            this.intensityView = new IntensityView(this, this.model, this.controller);
            this.intensityResultsView = new IntensityResultsView(this, this.model);
        }
        this.calcWizard = new CalculationWizard(this.controller, this.model);
        this.tabs = new JTabbedPane(1, 0);
        DrawingCanvasView canvasView = this.model.getDrawingView();
        canvasView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Cursor cursor = MeasurementViewerUI.this.model.getDrawingEditor().getTool() instanceof DelegationSelectionTool ? Cursor.getPredefinedCursor(0) : Cursor.getPredefinedCursor(1);
                MeasurementViewerUI.this.getDrawingView().setCursor(cursor);
            }
        });
        this.tabs.setAlignmentX(0.0f);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (MeasurementViewerUI.this.model.isHCSData()) {
                    MeasurementViewerUI.this.updateDrawingArea();
                } else if (MeasurementViewerUI.this.inDataView()) {
                    MeasurementViewerUI.this.controller.analyseSelectedFigures();
                }
            }
        });
    }

    MeasurementViewerUI(String title) {
        super(title);
    }

    void initialize(MeasurementViewer component, MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (component == null) {
            throw new NullPointerException("No component.");
        }
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.component = component;
        this.model = model;
        this.controller = controller;
        controller.attachListeners();
        ImageIcon icon = IconManager.getInstance().getIcon(41);
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.initComponents();
        controller.getAction(MeasurementViewerControl.IN_MICRONS);
        this.setName("measurement viewer window");
    }

    void buildGUI() {
        this.mainMenu = this.createMenuBar();
        this.setJMenuBar(this.mainMenu);
        this.tabs.addTab(this.roiManager.getComponentName(), this.roiManager.getComponentIcon(), this.roiManager);
        this.tabs.addTab(this.roiInspector.getComponentName(), this.roiInspector.getComponentIcon(), this.roiInspector);
        this.tabs.addTab(this.roiResults.getComponentName(), this.roiResults.getComponentIcon(), this.roiResults);
        if (this.showGraph) {
            this.tabs.addTab(this.graphPane.getComponentName(), this.graphPane.getComponentIcon(), this.graphPane);
            this.tabs.addTab(this.intensityView.getComponentName(), this.intensityView.getComponentIcon(), this.intensityView);
            this.tabs.addTab(this.intensityResultsView.getComponentName(), this.intensityResultsView.getComponentIcon(), this.intensityResultsView);
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)this.toolBar, "North");
        container.add((Component)this.tabs, "Center");
        container.add((Component)this.statusBar, "South");
    }

    private boolean hasStatsInfo() {
        List<ChannelData> channels = this.model.getMetadata();
        for (ChannelData channel : channels) {
            if (channel.hasStats()) continue;
            return false;
        }
        return true;
    }

    void showROIManagementMenu(int x, int y) {
        this.roiManager.showROIManagementMenu(x, y);
    }

    void mergeROI(List<Long> idList, List<ROIShape> shapeList) {
        try {
            this.model.notifyDataChanged(true);
            ROI newROI = this.model.cloneROI(idList.get(0));
            for (ROIShape shape : shapeList) {
                ROIFigure roi = shape.getFigure();
                if (roi.isReadOnly() || !roi.canEdit()) continue;
                ROIShape newShape = new ROIShape(newROI, shape.getCoord3D(), shape);
                if (this.getDrawing().contains((Figure)roi)) {
                    if (roi.canAnnotate()) {
                        roi.removeFigureListener(this.controller);
                    }
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().remove((Figure)shape.getFigure());
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.deleteShape(shape.getID(), shape.getCoord3D());
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().add((Figure)newShape.getFigure());
                    if (roi.canAnnotate()) {
                        newShape.getFigure().addFigureListener(this.controller);
                    }
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.addShape(newROI.getID(), newShape.getCoord3D(), newShape);
            }
        }
        catch (Exception e) {
            if (e instanceof ROICreationException) {
                this.handleROIException(e, CREATE_MSG);
            }
            if (e instanceof NoSuchROIException) {
                this.handleROIException(e, RETRIEVE_MSG);
            }
            this.handleROIException(e, "An unknown error occurred in Merging ROI");
        }
    }

    void splitROI(long id, List<ROIShape> shapeList) {
        try {
            this.model.notifyDataChanged(true);
            ROI newROI = this.model.cloneROI(id);
            for (ROIShape shape : shapeList) {
                ROIFigure roi = shape.getFigure();
                if (roi.isReadOnly() || !roi.canEdit()) continue;
                ROIShape newShape = new ROIShape(newROI, shape.getCoord3D(), shape);
                if (this.getDrawing().contains((Figure)roi)) {
                    if (roi.canAnnotate()) {
                        roi.removeFigureListener(this.controller);
                    }
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().remove((Figure)shape.getFigure());
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.deleteShape(shape.getID(), shape.getCoord3D());
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().add((Figure)newShape.getFigure());
                    if (roi.canAnnotate()) {
                        newShape.getFigure().addFigureListener(this.controller);
                    }
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.addShape(newROI.getID(), newShape.getCoord3D(), newShape);
            }
        }
        catch (Exception e) {
            if (e instanceof ROICreationException) {
                this.handleROIException(e, CREATE_MSG);
            }
            if (e instanceof NoSuchROIException) {
                this.handleROIException(e, RETRIEVE_MSG);
            }
            this.handleROIException(e, "An unknown error occurred in Splitting ROI.");
        }
    }

    void duplicateROI(long id, List<ROIShape> shapeList) {
        try {
            this.model.notifyDataChanged(true);
            ROI newROI = this.model.cloneROI(id);
            Drawing drawing = this.model.getDrawing();
            for (ROIShape shape : shapeList) {
                ROIFigure roi = shape.getFigure();
                if (roi.isReadOnly()) continue;
                ROIShape newShape = new ROIShape(newROI, shape.getCoord3D(), shape);
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    drawing.removeDrawingListener((DrawingListener)this.controller);
                    drawing.add((Figure)newShape.getFigure());
                    newShape.getFigure().addFigureListener(this.controller);
                    drawing.addDrawingListener((DrawingListener)this.controller);
                }
                this.model.addShape(newROI.getID(), newShape.getCoord3D(), newShape);
            }
            this.updateDrawingArea();
        }
        catch (Exception e) {
            this.handleROIException(e, CREATE_MSG);
        }
    }

    void markROIForDelete(ROIFigure roi) {
        if (roi == null) {
            return;
        }
        long id = roi.getROIShape().getID();
        if (id < 0L) {
            return;
        }
        this.model.markROIForDelete(id, roi.getROI(), true);
    }

    void deleteROIShapes(List<ROIShape> shapeList) {
        try {
            ArrayList<DeletableObject> deobs = new ArrayList<DeletableObject>();
            for (ROIShape shape : shapeList) {
                ROIFigure roi = shape.getFigure();
                if (!roi.canDelete()) continue;
                ROI r = roi.getROI();
                if (r.getID() >= 0L && !r.isClientSide()) {
                    ROIData rd = new ROIData();
                    rd.setId(r.getID());
                    rd.setImage(this.model.getImage().asImage());
                    DeletableObject d = new DeletableObject(rd);
                    d.setSecurityContext(this.model.getSecurityContext());
                    deobs.add(d);
                }
                if (this.getDrawing().contains((Figure)roi)) {
                    shape.getFigure().removeFigureListener(this.controller);
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().remove((Figure)roi);
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.deleteShape(shape.getID(), shape.getCoord3D());
            }
            this.model.deleteAllROIs(deobs);
            TreeMap<Long, ROI> rois = this.model.getROIComponent().getROIMap();
            boolean allsaved = true;
            for (ROI tmp : rois.values()) {
                if (!tmp.isClientSide()) continue;
                allsaved = false;
                break;
            }
            if (allsaved) {
                this.model.notifyDataChanged(false);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, DELETE_MSG);
        }
    }

    boolean inDataView() {
        return this.inIntensityView() || this.inGraphView() || this.inCalcWizardView();
    }

    boolean inCalcWizardView() {
        int index = this.tabs.getSelectedIndex();
        if (index < 0) {
            return false;
        }
        int n = this.tabs.getTabCount();
        if (index >= n) {
            return false;
        }
        return this.tabs.getTitleAt(index).equals(this.calcWizard.getComponentName());
    }

    boolean inGraphView() {
        if (!this.showGraph) {
            return false;
        }
        int index = this.tabs.getSelectedIndex();
        if (index < 0) {
            return false;
        }
        int n = this.tabs.getTabCount();
        if (index >= n) {
            return false;
        }
        return this.tabs.getTitleAt(index).equals(this.graphPane.getComponentName());
    }

    boolean inIntensityView() {
        if (!this.showGraph) {
            return false;
        }
        int index = this.tabs.getSelectedIndex();
        if (index < 0) {
            return false;
        }
        int n = this.tabs.getTabCount();
        if (index >= n) {
            return false;
        }
        return this.tabs.getTitleAt(index).equals(this.intensityView.getComponentName());
    }

    boolean inIntensityResultsView() {
        if (!this.showGraph) {
            return false;
        }
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.intensityResultsView.getComponentName());
    }

    LoadingWindow getLoadingWindow() {
        return this.loadingWindow;
    }

    void setCellColor(Color color) {
        Collection<Figure> l;
        int row = -1;
        if (this.roiInspector != null) {
            row = this.roiInspector.setCellColor(color);
        }
        if ((l = this.model.getSelectedFigures()) == null || l.size() == 0) {
            return;
        }
        Iterator<Figure> i = l.iterator();
        AttributeKey attKey = this.roiInspector.getAttributeKey(row);
        attKey.set(i.next(), (Object)color);
        this.model.getDrawingView().repaint();
    }

    void selectFigure(long ROIid, int t, int z) {
        try {
            ROI roi = this.model.getROI(ROIid);
            ROIFigure fig = roi.getFigure(new Coord3D(z, t));
            this.selectFigure(fig);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
    }

    void showROIAssistant() {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        if (this.inDataView()) {
            un.notifyInfo("ROI Assistant", "ROI Assistant cannot be used in graph pane or intensity view.");
            return;
        }
        Collection<ROI> roiList = this.model.getSelectedROI();
        if (roiList.size() == 0) {
            un.notifyInfo("ROI Assistant", "Select a Figure to modify using the ROI Assistant.");
            return;
        }
        if (roiList.size() > 1) {
            un.notifyInfo("ROI Assistant", "The ROI Assistant canonly be used on one ROI at a time.");
            return;
        }
        ROI currentROI = roiList.iterator().next();
        ROIAssistant assistant = new ROIAssistant(this.model.getNumTimePoints(), this.model.getNumZSections(), this.model.getCurrentView(), currentROI, this);
        UIUtilities.setLocationRelativeToAndShow(this, assistant);
        this.updateDrawingArea();
    }

    void showROIAssistant(ROI roi) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        if (this.inDataView()) {
            un.notifyInfo("ROI Assistant", "ROI Assistant cannot be used in graph pane or intensity view");
            return;
        }
        ROIAssistant assistant = new ROIAssistant(this.model.getNumTimePoints(), this.model.getNumZSections(), this.model.getCurrentView(), roi, this);
        UIUtilities.setLocationRelativeToAndShow(this, assistant);
        this.updateDrawingArea();
    }

    void selectFigure(ROIFigure figure) {
        if (figure == null) {
            this.model.getDrawingView().clearSelection();
            this.model.getDrawingView().setToolTipText("");
            return;
        }
        if (!figure.isVisible()) {
            return;
        }
        Coord3D coord3D = figure.getROIShape().getCoord3D();
        if (coord3D == null) {
            return;
        }
        if (!coord3D.equals(this.model.getCurrentView()) || this.model.isBigImage()) {
            this.model.setPlane(coord3D.getZSection(), coord3D.getTimePoint());
            SelectPlane request = new SelectPlane(this.model.getPixelsID(), coord3D.getZSection(), coord3D.getTimePoint());
            if (this.model.isBigImage()) {
                request.setBounds(figure.getBounds().getBounds());
            }
            EventBus bus = MeasurementAgent.getRegistry().getEventBus();
            bus.post(request);
            this.updateDrawingArea();
        }
        DrawingCanvasView dv = this.model.getDrawingView();
        dv.setToolTipText("" + figure.getAttribute(MeasurementAttributes.TEXT));
        dv.clearSelection();
        dv.addToSelection(figure);
        ArrayList<ROIShape> roiShapeList = new ArrayList<ROIShape>();
        roiShapeList.add(figure.getROIShape());
        if (this.model.isHCSData()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ROIShape roiShape : roiShapeList) {
                ids.add(roiShape.getROI().getID());
            }
            Component c = this.tabs.getSelectedComponent();
            if (c instanceof ServerROITable) {
                ((ServerROITable)c).selectROI(ids);
            }
        } else {
            this.roiInspector.setSelectedFigures(roiShapeList);
            this.roiManager.setSelectedFigures(roiShapeList, false);
            if (this.showGraph) {
                this.intensityResultsView.onFigureSelected();
                this.intensityView.onFigureSelected();
            }
            this.toolBar.onFigureSelected();
            this.displayAnalysisResults();
        }
    }

    void setSelectedFigures(Collection figures) {
        if (this.model.getState() != 5) {
            return;
        }
        if (figures == null || figures.isEmpty()) {
            return;
        }
        Iterator i = figures.iterator();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        try {
            while (i.hasNext()) {
                ROIFigure figure = (ROIFigure)i.next();
                ROIShape shape = figure.getROIShape();
                if (shape == null) continue;
                shapeList.add(shape);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        if (this.model.isHCSData()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ROIShape shape : shapeList) {
                ids.add(shape.getROI().getID());
            }
            Component c = this.tabs.getSelectedComponent();
            if (c instanceof ServerROITable) {
                ((ServerROITable)c).selectROI(ids);
            }
        } else {
            this.roiInspector.setSelectedFigures(shapeList);
            this.roiManager.setSelectedFigures(shapeList, true);
            if (this.showGraph) {
                this.intensityResultsView.onFigureSelected();
                this.intensityView.onFigureSelected();
            }
            this.toolBar.onFigureSelected();
        }
    }

    void setTableSelectedFigure(List<ROIFigure> figures) {
        if (figures == null) {
            return;
        }
        DrawingCanvasView dv = this.model.getDrawingView();
        Iterator<ROIFigure> k = figures.iterator();
        dv.clearSelection();
        if (figures == null || figures.size() == 0) {
            return;
        }
        dv.removeFigureSelectionListener(this.controller);
        int n = figures.size() - 1;
        int index = 0;
        while (k.hasNext()) {
            ROIFigure figure = k.next();
            dv.addToSelection(figure);
            if (index == n) {
                this.scrollToFigure(figure);
            }
            ++index;
        }
        dv.addFigureSelectionListener(this.controller);
        dv.grabFocus();
    }

    void removeROI(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        try {
            this.model.removeROIShape(figure.getROI().getID());
            if (!this.model.isHCSData()) {
                this.roiManager.removeFigure(figure);
                this.roiResults.refreshResults();
                this.roiInspector.removeROIFigure(figure);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, DELETE_MSG);
        }
    }

    void deleteROIs(List<ROIFigure> figures) {
        if (figures == null || figures.size() == 0) {
            return;
        }
        try {
            this.roiManager.removeFigures(figures);
            this.roiResults.refreshResults();
            this.roiInspector.removeROIFigures(figures);
            if (this.showGraph) {
                this.intensityView.onFigureRemoved();
                this.intensityResultsView.removeAllResults();
                this.graphPane.clearData();
            }
        }
        catch (Exception e) {
            this.handleROIException(e, DELETE_MSG);
        }
    }

    void addROI(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        ROI roi = null;
        try {
            boolean isDuplicate = this.getDrawingView().isDuplicate();
            roi = this.model.createROI(figure, !isDuplicate);
            if (!isDuplicate) {
                MeasurementAttributes.SHOWTEXT.set((Figure)figure, (Object)this.roiInspector.isShowText());
                MeasurementAttributes.SHOWMEASUREMENT.set((Figure)figure, (Object)true);
            }
            this.getDrawingView().unsetDuplicate();
        }
        catch (Exception e) {
            this.handleROIException(e, CREATE_MSG);
        }
        if (roi == null) {
            return;
        }
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        roiList.add(roi);
        if (!this.model.isHCSData()) {
            this.roiManager.addFigures(roiList);
            this.roiResults.refreshResults();
        }
    }

    void onAttributeChanged(ROIFigure figure) {
        if (this.model.getState() != 5) {
            return;
        }
        if (figure == null) {
            return;
        }
        if (!this.model.isHCSData()) {
            this.roiInspector.setModelData(figure);
            this.roiResults.refreshResults();
        }
    }

    Drawing getDrawing() {
        return this.model.getDrawing();
    }

    DrawingCanvasView getDrawingView() {
        return this.model.getDrawingView();
    }

    void rebuildManagerTable() {
        if (!this.model.isHCSData()) {
            this.roiManager.rebuildTable();
        }
    }

    void rebuildManagerTable(Map<FolderData, Collection<ROIData>> result, ROIFolderSaver.ROIFolderAction action) {
        if (!this.model.isHCSData()) {
            this.roiManager.rebuildTable(result, action);
        }
    }

    void refreshToolBar() {
        this.toolBar.refreshToolBar();
    }

    void refreshResultsTable() {
        if (!this.model.isHCSData()) {
            this.roiResults.refreshResults();
        }
    }

    void refreshInspectorTable() {
        if (!this.model.isHCSData()) {
            this.roiInspector.repaint();
        }
    }

    void clearInspector() {
        this.roiInspector.clearData();
    }

    void handleROIException(Exception e, String text) {
        Registry reg = MeasurementAgent.getRegistry();
        if (e instanceof ROICreationException || e instanceof NoSuchROIException) {
            reg.getLogger().error((Object)this, "Problem while handling ROI " + e.getMessage());
            this.statusBar.setStatus(text);
        } else {
            String s = "An unexpected error occurred while handling ROI ";
            reg.getLogger().error((Object)this, s + e.getMessage());
            reg.getUserNotifier().notifyError("ROI", s, e);
        }
    }

    void layoutUI() {
        if (this.model.isHCSData()) {
            this.tabs.removeAll();
            Collection l = this.model.getMeasurementResults();
            for (ROIResult result : l) {
                ServerROITable comp = new ServerROITable(this, this.model);
                comp.setResult(result);
                this.roiTables.add(comp);
                this.tabs.addTab(comp.getComponentName(), comp.getComponentIcon(), comp);
            }
            if (l.size() > 0) {
                this.tabs.setSelectedIndex(0);
            }
            this.getContentPane().remove(this.toolBar);
            this.setJMenuBar(null);
        }
    }

    void updateDrawingArea() {
        Drawing drawing = this.model.getDrawing();
        drawing.removeDrawingListener((DrawingListener)this.controller);
        drawing.clear();
        ShapeList list = null;
        ArrayList<ROIFigure> first = new ArrayList<ROIFigure>();
        ArrayList<ROIFigure> second = new ArrayList<ROIFigure>();
        if (this.model.isHCSData()) {
            DrawingCanvasView canvas;
            KeyListener[] l;
            block25: {
                Component comp = this.tabs.getSelectedComponent();
                if (comp instanceof ServerROITable) {
                    ServerROITable table = (ServerROITable)comp;
                    try {
                        ROIFigure figure2;
                        long fileID = table.getFileID();
                        if (fileID >= 0L) {
                            List<ROI> rois = this.model.getROIList(fileID);
                            if (rois != null) {
                                for (ROI roi : rois) {
                                    TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
                                    for (ROIShape shape : shapes.values()) {
                                        figure2 = shape.getFigure();
                                        if (!(figure2 instanceof MeasureMaskFigure)) {
                                            second.add(figure2);
                                            continue;
                                        }
                                        first.add(figure2);
                                    }
                                }
                                for (ROIFigure figure2 : first) {
                                    drawing.add((Figure)figure2);
                                    if (!figure2.canAnnotate()) continue;
                                    figure2.addFigureListener(this.controller);
                                }
                                for (ROIFigure figure2 : second) {
                                    drawing.add((Figure)figure2);
                                    if (!figure2.canAnnotate()) continue;
                                    figure2.addFigureListener(this.controller);
                                }
                            }
                            break block25;
                        }
                        try {
                            list = this.model.getShapeList();
                        }
                        catch (Exception e) {
                            this.handleROIException(e, RETRIEVE_MSG);
                        }
                        if (list != null) {
                            TreeMap<Long, ROIShape> map = list.getList();
                            for (ROIShape shape : map.values()) {
                                if (shape == null) continue;
                                figure2 = shape.getFigure();
                                drawing.add((Figure)figure2);
                                if (!figure2.canAnnotate()) continue;
                                figure2.addFigureListener(this.controller);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.handleROIException(e, RETRIEVE_MSG);
                    }
                }
            }
            if ((l = (canvas = this.model.getDrawingView()).getKeyListeners()) != null) {
                for (int i = 0; i < l.length; ++i) {
                    canvas.removeKeyListener(l[i]);
                }
            }
        } else {
            try {
                list = this.model.getShapeList();
            }
            catch (Exception e) {
                this.handleROIException(e, RETRIEVE_MSG);
            }
            if (list != null) {
                TreeMap<Long, ROIShape> map = list.getList();
                for (ROIShape shape : map.values()) {
                    if (shape == null) continue;
                    ROIFigure figure = shape.getFigure();
                    if (!(figure instanceof MeasureMaskFigure)) {
                        second.add(figure);
                        continue;
                    }
                    first.add(figure);
                }
                for (ROIFigure figure : first) {
                    drawing.add((Figure)figure);
                    if (!figure.canAnnotate()) continue;
                    figure.addFigureListener(this.controller);
                }
                for (ROIFigure figure : second) {
                    drawing.add((Figure)figure);
                    if (!figure.canAnnotate()) continue;
                    figure.addFigureListener(this.controller);
                }
            }
        }
        this.setStatus("");
        this.model.getDrawingView().setDrawing(drawing);
        drawing.addDrawingListener((DrawingListener)this.controller);
    }

    void propagateShape(ROIShape shape, int timePoint, int zSection) {
        ArrayList<ROIShape> addedShapes = new ArrayList();
        try {
            ROIFigure roi = shape.getFigure();
            if (!roi.isReadOnly() && roi.canEdit()) {
                addedShapes = this.model.propagateShape(shape, timePoint, zSection);
            }
            ROIFigure figToDelete = null;
            for (ROIShape newShape : addedShapes) {
                roi = newShape.getFigure();
                if (roi.isReadOnly() || !roi.canEdit()) continue;
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    figToDelete = null;
                    for (Figure f : this.getDrawing().getFigures()) {
                        ROIFigure roiFig = (ROIFigure)f;
                        if (roiFig.getROI().getID() != newShape.getID()) continue;
                        figToDelete = roiFig;
                    }
                    if (figToDelete != null) {
                        this.getDrawing().remove(figToDelete);
                    }
                    this.getDrawing().add((Figure)newShape.getFigure());
                    if (roi.canAnnotate()) {
                        newShape.getFigure().addFigureListener(this.controller);
                    }
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                newShape.getFigure().calculateMeasurements();
            }
            if (!this.model.isHCSData()) {
                this.roiManager.addROIShapes(addedShapes);
            }
        }
        catch (ROICreationException e) {
            this.handleROIException(e, CREATE_MSG);
        }
        catch (NoSuchROIException e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.setStatus("");
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) {
        try {
            this.model.deleteShape(shape, timePoint, zSection);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.setStatus("");
        this.rebuildManagerTable();
    }

    void setStatus(String text) {
        this.statusBar.setStatus(text);
    }

    void setPlaneStatus(String text) {
        this.statusBar.setPlaneStatus(text);
    }

    void setReadyStatus() {
        this.setStatus("");
    }

    void displayAnalysisResults() {
        if (this.inGraphView()) {
            this.graphPane.displayAnalysisResults();
        } else if (this.inIntensityView()) {
            this.intensityView.displayAnalysisResults();
        } else if (this.inIntensityResultsView()) {
            this.intensityResultsView.displayAnalysisResults();
        }
    }

    void createSingleFigure(boolean createSingleFig) {
        this.createSingleFigure.setSelected(createSingleFig);
        this.createMultipleFigure.setSelected(!createSingleFig);
        this.toolBar.createSingleFigure(createSingleFig);
    }

    boolean isCreateSingleFigure() {
        return this.createSingleFigure.isSelected();
    }

    long getPixelsID() {
        return this.model.getPixelsID();
    }

    void calculateStats(List<ROIShape> shapeList) {
        if (this.model.getState() != 5) {
            return;
        }
        this.model.calculateStats(shapeList);
    }

    void onSelectedFigures() {
        Collection<Figure> figures = this.model.getSelectedFigures();
        if (figures != null) {
            boolean show = this.roiInspector.isShowMeasurement();
            for (Figure f : figures) {
                if ((Boolean)MeasurementAttributes.SHOWMEASUREMENT.get(f) == show) continue;
                MeasurementAttributes.SHOWMEASUREMENT.set(f, (Object)show);
            }
        }
        this.roiManager.onSelectedFigures();
    }

    Collection<Figure> getSelectedFiguresFromTables() {
        return this.roiManager.getSelectedFiguresFromTables();
    }

    FileChooser createSaveToExcelChooser() {
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        ExcelFilter filter = new ExcelFilter();
        filterList.add(filter);
        FileChooser chooser = new FileChooser(this, 1, "Save Results to Excel", "Save the Results data to a file which can be loaded by a spreadsheet.", filterList);
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chooser;
    }

    void showText(boolean show) {
        Collection<ROIFigure> figures = this.model.getAllFigures();
        if (figures.size() == 0) {
            return;
        }
        for (ROIFigure figure : figures) {
            MeasurementAttributes.SHOWTEXT.set((Figure)figure, (Object)show);
            if (this.roiInspector == null) continue;
            this.roiInspector.showText(show, figure);
        }
        this.model.getDrawingView().repaint();
    }

    boolean isChannelActive(int channel) {
        return this.model.isChannelActive(channel);
    }

    void onAnalysed(boolean analyse) {
        if (!this.showGraph) {
            return;
        }
        this.graphPane.onAnalysed(analyse);
        this.intensityView.onAnalysed(analyse);
        this.toolBar.onAnalysed(analyse);
    }

    void onMagnificationChanged() {
        this.toolBar.onMagnificationChanged();
    }

    @Override
    public void setOnScreen() {
        this.setSize(DEFAULT_SIZE);
        UIUtilities.incrementRelativeToAndShow(null, this);
    }

    public void exportGraph() {
        if (!this.showGraph) {
            return;
        }
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        filterList.add(new JPEGFilter());
        filterList.add(new PNGFilter());
        FileChooser chooser = new FileChooser((JFrame)SwingUtilities.windowForComponent(this), 1, "Save Graph", "Save the graph as JPEG or PNG", filterList);
        try {
            File f = UIUtilities.getDefaultFolder();
            if (f != null) {
                chooser.setCurrentDirectory(f);
            }
        }
        catch (Exception f) {
            // empty catch block
        }
        if (chooser.showDialog() != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        FileFilter filter = chooser.getSelectedFilter();
        int type = filter instanceof JPEGFilter ? 1 : 0;
        this.graphPane.saveGraph(file, type);
    }

    void displayAnnotations(List<ROIShape> shapes) {
        this.roiInspector.setSelectedFigures(shapes);
    }
}

