/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.metadata.actions.CollapseAction;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

class BrowserControl
implements PropertyChangeListener {
    static final Integer COLLAPSE = 0;
    static final Integer CLOSE = 1;
    static final Integer SORT = 2;
    static final Integer SORT_DATE = 3;
    static final Integer PARTIAL_NAME = 4;
    private Browser model;
    private BrowserUI view;
    private Map<Integer, BrowserAction> actionsMap = new HashMap<Integer, BrowserAction>();

    private void createActions() {
        this.actionsMap.put(COLLAPSE, new CollapseAction(this.model));
    }

    BrowserControl() {
    }

    void initialize(Browser model, BrowserUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = view;
        this.createActions();
    }

    BrowserAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void onClick() {
        JTree tree = this.view.getTreeDisplay();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int n = paths.length;
        if (n == 0) {
            return;
        }
        Object pathComponent = paths[0].getLastPathComponent();
        if (!(pathComponent instanceof TreeBrowserDisplay)) {
            return;
        }
        TreeBrowserDisplay node = (TreeBrowserDisplay)pathComponent;
        ArrayList<TreeBrowserDisplay> l = new ArrayList<TreeBrowserDisplay>();
        l.add(node);
        if (l.size() != n) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Node selection", "You can only select node of the same type e.g. images.");
        }
        if (l.size() == 0) {
            return;
        }
        this.model.setSelectedNodes(l);
    }

    void onNodeNavigation(TreeBrowserDisplay node) {
        this.model.setSelectedNode(node);
        if (node.isChildrenLoaded()) {
            return;
        }
        this.view.addDefaultNode(node, "Loading...");
        this.model.loadMetadata(node);
    }

    void browser(List<TreeBrowserDisplay> nodes) {
        Object object;
        TreeBrowserDisplay node2;
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (TreeBrowserDisplay node2 : nodes) {
            object = node2.getUserObject();
            if (!(object instanceof DataObject)) continue;
            ids.add(((DataObject)object).getId());
        }
        if (ids.size() == 0) {
            return;
        }
        node2 = this.model.getLastSelectedNode();
        object = node2.getUserObject();
        int index = -1;
        if (object instanceof DatasetData) {
            index = 3;
        } else if (object instanceof ProjectData) {
            index = 4;
        }
        if (index == -1) {
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("loadingParents".equals(name)) {
            this.view.addDefaultNode("Loading...");
        }
    }
}

