/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.browser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;

class BrowserModel {
    private List<TreeBrowserDisplay> selectedNodes = new ArrayList<TreeBrowserDisplay>();
    private MetadataViewer parent;
    private TreeBrowserSet root;
    private Browser component;

    BrowserModel(Object refObject, MetadataViewer parent) {
        if (refObject != null) {
            this.selectedNodes.add(new TreeBrowserSet(refObject));
        }
        this.parent = parent;
    }

    BrowserModel(MetadataViewer parent) {
        this(null, parent);
    }

    void initialize(Browser component) {
        this.component = component;
    }

    TreeBrowserDisplay getLastSelectedNode() {
        int n = this.selectedNodes.size();
        if (n == 0) {
            return null;
        }
        return this.selectedNodes.get(n - 1);
    }

    List<TreeBrowserDisplay> getSelectedNodes() {
        return this.selectedNodes;
    }

    void setSelectedDisplays(List<TreeBrowserDisplay> nodes) {
        this.selectedNodes.clear();
        if (nodes == null) {
            return;
        }
        Iterator<TreeBrowserDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            this.selectedNodes.add(i.next());
        }
    }

    void setRootObject(Object refObject) {
        this.selectedNodes.clear();
        this.root = new TreeBrowserSet(refObject);
        this.selectedNodes.add(this.root);
    }

    void loadMetadata(TreeBrowserDisplay node) {
        this.parent.loadContainers(node);
    }

    TreeBrowserSet getRoot() {
        return this.root;
    }
}

