/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ActivatedUserAction
extends TreeViewerAction {
    public static final String NAME = "Activated User";
    private static final String DESCRIPTION = "If selected the user is active.";
    private static final Icon ACTIVATED_ICON;
    private static final Icon NOT_ACTIVATED_ICON;

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                if (browser.getBrowserType() != 6) {
                    this.setEnabled(false);
                    break;
                }
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.isAdministrator()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null || selectedDisplay == null || browser.getBrowserType() != 6) {
            this.setEnabled(false);
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes.length > 1) {
            this.setEnabled(false);
        } else if (selectedDisplay.getUserObject() instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)selectedDisplay.getUserObject();
            ExperimenterData user = this.model.getUserDetails();
            this.setEnabled(exp.getId() != user.getId() && !this.model.isSystemUser(exp.getId()));
            if (exp.isActive()) {
                this.putValue("SmallIcon", ACTIVATED_ICON);
            } else {
                this.putValue("SmallIcon", NOT_ACTIVATED_ICON);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public ActivatedUserAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(32));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    static {
        IconManager icons = IconManager.getInstance();
        ACTIVATED_ICON = icons.getIcon(23);
        NOT_ACTIVATED_ICON = icons.getIcon(124);
    }
}

