/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.events.importer.LoadImporter;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.event.EventBus;

public class CreateCmd
implements ActionCmd {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int TAG = 2;
    public static final int SCREEN = 3;
    public static final int PLATE = 4;
    public static final int IMAGE = 5;
    public static final int TAG_SET = 6;
    public static final int GROUP = 7;
    public static final int EXPERIMENTER = 8;
    private TreeViewer model;
    private DataObject userObject;
    private boolean withParent;

    private DataObject checkNodeType(int type) {
        switch (type) {
            case 0: {
                return new ProjectData();
            }
            case 1: {
                return new DatasetData();
            }
            case 3: {
                return new ScreenData();
            }
            case 2: {
                return new TagAnnotationData("foo");
            }
            case 6: {
                return new TagAnnotationData("foo", true);
            }
            case 4: {
                return new PlateData();
            }
            case 5: {
                return new ImageData();
            }
            case 7: {
                return new GroupData();
            }
            case 8: {
                return new ExperimenterData();
            }
        }
        throw new IllegalArgumentException("Type not supported");
    }

    public CreateCmd(TreeViewer model, int type) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.userObject = this.checkNodeType(type);
        this.model = model;
        this.withParent = true;
    }

    public void setWithParent(boolean withParent) {
        this.withParent = withParent;
    }

    @Override
    public void execute() {
        if (this.userObject == null) {
            return;
        }
        if (this.userObject instanceof ImageData) {
            ExperimenterData exp;
            Browser browser = this.model.getDefaultBrowser();
            if (this.withParent) {
                browser = this.model.getSelectedBrowser();
            } else {
                Browser selectedBrowser = this.model.getSelectedBrowser();
                if (selectedBrowser != null) {
                    switch (selectedBrowser.getBrowserType()) {
                        case 0: 
                        case 1: {
                            browser = selectedBrowser;
                        }
                    }
                }
            }
            TreeImageDisplay display = null;
            long userId = -1L;
            if (this.withParent && (exp = browser.getNodeOwner(display = browser.getLastSelectedDisplay())) != null) {
                userId = exp.getId();
            }
            LoadImporter event = null;
            int type = 0;
            switch (browser.getBrowserType()) {
                case 1: {
                    type = 1;
                }
            }
            event = new LoadImporter(display, type);
            event.setGroup(browser.getSecurityContext(browser.getLastSelectedDisplay()).getGroupID());
            event.setUser(userId);
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            bus.post(event);
        } else {
            this.model.createDataObject(this.userObject, this.withParent);
        }
    }
}

