/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;

public class DataNode {
    static final String DEFAULT_SCREEN = "--No Screen--";
    static final String DEFAULT_DATASET = "--New From Folder--";
    private static final String DEFAULT_PROJECT = "--No Project--";
    private static final String NO_DATASET = "--No Dataset--";
    private DataObject data;
    private TreeImageDisplay refNode;
    private boolean orphanParent;
    private List<DataNode> children;
    private List<DataNode> uiChildren;
    private DataNode parent;
    private List<DataNode> newNodes;

    public static DatasetData createNoDataset() {
        DatasetData d = new DatasetData();
        d.setName(NO_DATASET);
        return d;
    }

    public static DatasetData createDefaultDataset() {
        DatasetData d = new DatasetData();
        d.setName(DEFAULT_DATASET);
        return d;
    }

    public static ProjectData createDefaultProject() {
        ProjectData d = new ProjectData();
        d.setName(DEFAULT_PROJECT);
        return d;
    }

    public static ScreenData createDefaultScreen() {
        ScreenData d = new ScreenData();
        d.setName(DEFAULT_SCREEN);
        return d;
    }

    public DataNode(DataObject data) {
        if (data == null) {
            throw new IllegalArgumentException("No Object specified.");
        }
        this.data = data;
    }

    public DataNode(DataObject data, DataNode parent) {
        if (data == null) {
            throw new IllegalArgumentException("No Object specified.");
        }
        this.data = data;
        this.parent = parent;
    }

    public DataNode(List<DataNode> children) {
        this.orphanParent = true;
        this.data = DataNode.createDefaultProject();
        this.children = children;
    }

    public void setParent(DataNode parent) {
        this.parent = parent;
    }

    public void setData(DataObject data) {
        this.data = data;
    }

    public void setRefNode(TreeImageDisplay refNode) {
        this.refNode = refNode;
    }

    public TreeImageDisplay getRefNode() {
        return this.refNode;
    }

    public DataObject getDataObject() {
        return this.data;
    }

    public ExperimenterData getOwner() {
        if (this.data.getId() < 0L) {
            return null;
        }
        if (this.data instanceof GroupData || this.data instanceof ExperimenterData) {
            return null;
        }
        return this.data.getOwner();
    }

    public boolean isNewDataObject(String name) {
        if (this.orphanParent) {
            return false;
        }
        return this.toString().equals(name) && this.data.getId() <= 0L;
    }

    public List<DataNode> getNewNodes() {
        return this.newNodes;
    }

    public void addNewNode(DataNode node) {
        if (this.newNodes == null) {
            this.newNodes = new ArrayList<DataNode>();
        }
        if (node != null) {
            if (!this.isDefaultNode() && this.children != null) {
                Iterator<DataNode> i = this.children.iterator();
                DataNode toRemove = null;
                while (i.hasNext()) {
                    DataNode child = i.next();
                    if (!child.isDefaultNode()) continue;
                    toRemove = child;
                    break;
                }
                if (toRemove != null) {
                    this.children.remove(toRemove);
                }
            }
            this.newNodes.add(node);
        }
    }

    public List<DataNode> getDatasetNodes() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new ArrayList<DataNode>();
        if (this.data instanceof ProjectData && this.refNode != null) {
            List l = this.refNode.getChildrenDisplay();
            if (CollectionUtils.isNotEmpty((Collection)l)) {
                for (TreeImageDisplay node : l) {
                    DataNode n = new DataNode((DataObject)node.getUserObject());
                    n.setRefNode(node);
                    n.parent = this;
                    this.children.add(n);
                }
                this.children.add(new DataNode(DataNode.createDefaultDataset(), this));
            } else {
                this.children.add(new DataNode(DataNode.createDefaultDataset(), this));
            }
        }
        return this.children;
    }

    public List<DataNode> getUIDatasetNodes() {
        if (this.orphanParent) {
            return this.children;
        }
        if (this.uiChildren != null) {
            return this.uiChildren;
        }
        this.uiChildren = new ArrayList<DataNode>();
        if (this.data instanceof ProjectData) {
            ProjectData project = (ProjectData)this.data;
            Set<DatasetData> datasets = project.getDatasets();
            Iterator<DatasetData> i = datasets.iterator();
            while (i.hasNext()) {
                DataNode n = new DataNode(i.next());
                this.uiChildren.add(n);
                n.parent = this;
            }
        }
        return this.uiChildren;
    }

    public void addNode(DataNode node) {
        if (node == null) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList<DataNode>();
        }
        node.parent = this;
        this.children.add(node);
    }

    public boolean isDefaultNode() {
        return this.isDefaultProject() || this.isDefaultScreen() || this.isDefaultDataset() || this.isNoDataset();
    }

    public boolean isNoDataset() {
        return NO_DATASET.equals(this.toString().trim());
    }

    public boolean isDefaultProject() {
        return DEFAULT_PROJECT.equals(this.toString().trim());
    }

    public boolean isDefaultScreen() {
        return DEFAULT_SCREEN.equals(this.toString().trim());
    }

    public boolean isDefaultDataset() {
        return DEFAULT_DATASET.equals(this.toString().trim());
    }

    public DataNode getParent() {
        return this.parent;
    }

    public String toString() {
        return EditorUtil.truncate(this.getFullName(), 48);
    }

    public String getFullName() {
        if (this.data instanceof DatasetData) {
            return ((DatasetData)this.data).getName() + " ";
        }
        if (this.data instanceof ProjectData) {
            return ((ProjectData)this.data).getName() + " ";
        }
        if (this.data instanceof ScreenData) {
            return ((ScreenData)this.data).getName() + " ";
        }
        if (this.data instanceof GroupData) {
            return ((GroupData)this.data).getName() + " ";
        }
        return "";
    }
}

