/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.FileAnnotationData;
import omero.model.FileAnnotation;
import omero.model.OriginalFile;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.util.file.IOUtil;

public class FilesLoader
extends BatchCallTree {
    public static final int ORIGINAL_FILE = 0;
    public static final int FILE_ANNOTATION = 1;
    public static final int METADATA_FROM_IMAGE = 2;
    private BatchCall loadCall;
    private Object result;
    private Object currentFile;
    private Map<FileAnnotationData, File> files;
    private SecurityContext ctx;
    private Set<String> directories;

    private BatchCall makeBatchCall(final File file, final long fileID) {
        return new BatchCall("Downloading files."){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FilesLoader.this.result = service.downloadFile(FilesLoader.this.ctx, file, fileID);
            }
        };
    }

    private BatchCall makeFileBatchCall(final File file, final long id) {
        return new BatchCall("Downloading files."){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FileAnnotationData fa = (FileAnnotationData)service.loadAnnotation(FilesLoader.this.ctx, id);
                FilesLoader.this.result = service.downloadFile(FilesLoader.this.ctx, file, fa.getFileID());
            }
        };
    }

    private BatchCall makeFromImageBatchCall(final File file, final long id) {
        return new BatchCall("Downloading original metadata."){

            @Override
            public void doCall() throws Exception {
                FilesLoader.this.result = null;
                OmeroMetadataService svc = FilesLoader.this.context.getMetadataService();
                RequestCallback cb = svc.downloadMetadataFile(FilesLoader.this.ctx, file, id);
                FilesLoader.this.currentFile = cb == null ? Boolean.valueOf(false) : cb;
            }
        };
    }

    private BatchCall makeBatchCall(final long fileAnnotationID) {
        return new BatchCall("Downloading files."){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FileAnnotationData fa = (FileAnnotationData)service.loadAnnotation(FilesLoader.this.ctx, fileAnnotationID);
                HashMap<FileAnnotationData, File> m = new HashMap<FileAnnotationData, File>();
                File f = service.downloadFile(FilesLoader.this.ctx, new File(fa.getFileName()), fa.getFileID());
                m.put(fa, f);
                FilesLoader.this.result = m;
            }
        };
    }

    private void loadFile(FileAnnotationData fa, File f, boolean zip) {
        OmeroMetadataService service = this.context.getMetadataService();
        HashMap<FileAnnotationData, File> m = new HashMap<FileAnnotationData, File>();
        OriginalFile of = ((FileAnnotation)fa.asAnnotation()).getFile();
        try {
            service.downloadFile(this.ctx, f, of.getId().getValue());
            m.put(fa, f);
        }
        catch (Exception e) {
            m.put(fa, null);
            this.context.getLogger().error((Object)this, "Cannot retrieve file: " + e.getMessage());
        }
        if (zip && !CollectionUtils.isEmpty(this.directories)) {
            Iterator<String> i = this.directories.iterator();
            while (i.hasNext()) {
                try {
                    IOUtil.zipDirectory(new File(i.next()), false);
                }
                catch (Exception e) {
                    this.context.getLogger().error((Object)this, "Cannot zip parent: " + e.getMessage());
                }
            }
        }
        this.currentFile = m;
    }

    private BatchCall makeLoadFilesBatchCall(final int type, final long userID) {
        return new BatchCall("Downloading files."){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService service = FilesLoader.this.context.getMetadataService();
                FilesLoader.this.result = service.loadFiles(FilesLoader.this.ctx, type, userID);
            }
        };
    }

    @Override
    protected void buildTree() {
        if (this.files == null && this.loadCall != null) {
            this.add(this.loadCall);
        } else if (this.files != null) {
            this.result = null;
            Iterator<Map.Entry<FileAnnotationData, File>> i = this.files.entrySet().iterator();
            String description = "Loading file";
            int count = 1;
            int size = this.files.size();
            while (i.hasNext()) {
                Map.Entry<FileAnnotationData, File> entry = i.next();
                final FileAnnotationData fa = entry.getKey();
                final File f = entry.getValue();
                this.directories.add(f.getParent());
                final boolean b = count == size;
                this.add(new BatchCall(description){

                    @Override
                    public void doCall() {
                        FilesLoader.this.loadFile(fa, f, b);
                    }
                });
                ++count;
            }
        }
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    @Override
    protected Object getPartialResult() {
        return this.currentFile;
    }

    public FilesLoader(SecurityContext ctx, File file, long fileID) {
        this.ctx = ctx;
        this.loadCall = file == null ? this.makeBatchCall(fileID) : this.makeBatchCall(file, fileID);
    }

    public FilesLoader(SecurityContext ctx, File file, long fileID, int index) {
        this.ctx = ctx;
        this.loadCall = file == null || index == 1 ? this.makeFileBatchCall(file, fileID) : (index == 2 ? this.makeFromImageBatchCall(file, fileID) : this.makeBatchCall(file, fileID));
    }

    public FilesLoader(SecurityContext ctx, Map<FileAnnotationData, File> files, boolean zipDirectory) {
        this.ctx = ctx;
        if (files == null) {
            throw new IllegalArgumentException("No files to load.");
        }
        this.files = files;
        if (zipDirectory) {
            this.directories = new HashSet<String>();
        }
    }

    public FilesLoader(SecurityContext ctx, int type, long userID) {
        this.ctx = ctx;
        this.loadCall = this.makeLoadFilesBatchCall(type, userID);
    }
}

