/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.RenderingServiceException;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ImageCheckerResult;
import org.openmicroscopy.shoola.env.data.model.MIFResultObject;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ImageSplitChecker
extends BatchCallTree {
    private ImageCheckerResult result = new ImageCheckerResult();
    private BatchCall loadCall;
    private OmeroImageService service;

    private List<ThumbnailData> loadThumbails(SecurityContext ctx, List<ImageData> images) {
        ArrayList<ThumbnailData> thumbnails = new ArrayList<ThumbnailData>();
        try {
            HashMap<Long, ImageData> map = new HashMap<Long, ImageData>();
            for (ImageData img : images) {
                map.put(img.getDefaultPixels().getId(), img);
            }
            Map<Long, BufferedImage> m = this.service.getThumbnailSet(ctx, map.keySet(), 96);
            Iterator<Long> j = m.keySet().iterator();
            long imageID = -1L;
            while (j.hasNext()) {
                long pixelsID = j.next();
                ImageData obj = (ImageData)map.get(pixelsID);
                imageID = obj.getId();
                BufferedImage thumbPix = m.get(pixelsID);
                if (thumbPix == null) continue;
                thumbnails.add(new ThumbnailData(imageID, (Image)thumbPix, true));
            }
        }
        catch (RenderingServiceException e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve thumbnail: " + e.getExtendedMessage());
        }
        return thumbnails;
    }

    private BatchCall makeBatchCall(final Map<SecurityContext, List<DataObject>> objects) {
        return new BatchCall("Checking for split MIF "){

            @Override
            public void doCall() throws Exception {
                OmeroDataService svc = ImageSplitChecker.this.context.getDataService();
                Iterator i = objects.entrySet().iterator();
                ArrayList<ImageData> linkCheckImages = new ArrayList<ImageData>();
                while (i.hasNext()) {
                    linkCheckImages.clear();
                    Map.Entry e = i.next();
                    Iterator j = ((List)e.getValue()).iterator();
                    ArrayList<Long> ids = new ArrayList<Long>();
                    Class<?> klass = null;
                    while (j.hasNext()) {
                        DataObject uo = (DataObject)j.next();
                        klass = uo.getClass();
                        ids.add(uo.getId());
                        if (!(uo instanceof ImageData)) continue;
                        ImageData img = (ImageData)uo;
                        linkCheckImages.add(img);
                    }
                    Map<Long, Map<Boolean, List<ImageData>>> r = svc.getImagesBySplitFilesets((SecurityContext)e.getKey(), klass, ids);
                    if (r != null && r.size() > 0) {
                        MIFResultObject mif = new MIFResultObject((SecurityContext)e.getKey(), r);
                        List<ImageData> images = mif.getImages();
                        mif.setThumbnails(ImageSplitChecker.this.loadThumbails((SecurityContext)e.getKey(), images));
                        ImageSplitChecker.this.result.getMifResults().add(mif);
                    }
                    if (linkCheckImages.isEmpty()) continue;
                    ImageSplitChecker.this.loadDatasetLinks((SecurityContext)e.getKey(), linkCheckImages);
                }
            }
        };
    }

    private void loadDatasetLinks(SecurityContext ctx, List<ImageData> imgs) {
        try {
            ArrayList<Long> imgIds = new ArrayList<Long>();
            for (ImageData img : imgs) {
                imgIds.add(img.getId());
            }
            OmeroDataService svc = this.context.getDataService();
            Map<Long, List<DatasetData>> queryResult = svc.findDatasetsByImageId(ctx, imgIds);
            for (Long imgId : queryResult.keySet()) {
                List<DatasetData> ds = queryResult.get(imgId);
                ImageData img = null;
                for (ImageData tmp : imgs) {
                    if (tmp.getId() != imgId.longValue()) continue;
                    img = tmp;
                    break;
                }
                if (img == null) continue;
                this.result.addDatasets(img, ds);
            }
        }
        catch (DSOutOfServiceException e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve datasets: " + e.getMessage());
        }
        catch (DSAccessException e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve datasets: " + e.getMessage());
        }
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ImageSplitChecker(Map<SecurityContext, List<DataObject>> objects) {
        if (objects == null || objects.size() == 0) {
            throw new IllegalArgumentException("No object to check.");
        }
        this.service = this.context.getImageService();
        this.loadCall = this.makeBatchCall(objects);
    }
}

