/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.Iterator;
import omero.gateway.SecurityContext;
import omero.romio.PlaneDef;
import omero.romio.RegionDef;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.data.Region;
import org.openmicroscopy.shoola.env.rnd.data.Tile;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class TileLoader
extends BatchCallTree {
    private Object currentTile;
    private Collection<Tile> tiles;
    private PlaneDef pDef;
    private RenderingControl proxy;

    private void loadTile(Tile tile) {
        Region rt = tile.getRegion();
        try {
            PlaneDef def = new PlaneDef();
            def.slice = this.pDef.slice;
            def.stride = this.pDef.stride;
            def.x = this.pDef.x;
            def.y = this.pDef.y;
            def.z = this.pDef.z;
            def.t = this.pDef.t;
            def.region = new RegionDef(rt.getX(), rt.getY(), rt.getWidth(), rt.getHeight());
            tile.setImage(this.proxy.render(def));
        }
        catch (Exception e) {
            tile.setImage(Factory.createDefaultImageThumbnail(rt.getWidth(), rt.getHeight()));
        }
        this.currentTile = tile;
    }

    @Override
    protected Object getPartialResult() {
        return this.currentTile;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    @Override
    protected void buildTree() {
        Iterator<Tile> i = this.tiles.iterator();
        String description = "Loading tiles";
        while (i.hasNext()) {
            Tile tile;
            final Tile t = tile = i.next();
            this.add(new BatchCall(description){

                @Override
                public void doCall() {
                    TileLoader.this.loadTile(t);
                }
            });
        }
    }

    public TileLoader(SecurityContext ctx, long pixelsID, PlaneDef pDef, RenderingControl proxy, Collection<Tile> tiles) {
        if (proxy == null) {
            throw new IllegalArgumentException("No rendering control.");
        }
        if (pixelsID != proxy.getPixelsID()) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        if (tiles == null || tiles.size() == 0) {
            throw new IllegalArgumentException("No tiles to load.");
        }
        if (pDef == null) {
            throw new IllegalArgumentException("No plane to render.");
        }
        this.tiles = tiles;
        this.pDef = pDef;
        this.proxy = proxy;
    }
}

