/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.MovieActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.MovieCreator;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MovieActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Creating movie for";
    private static final String DESCRIPTION_CREATED = "Movie created for";
    private static final String DESCRIPTION_CANCEL = "Movie creation cancelled for";
    private MovieActivityParam parameters;

    public MovieActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, MovieActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.initialize(DESCRIPTION_CREATION, parameters.getIcon());
        String name = parameters.getImage().getName();
        this.messageLabel.setText(UIUtilities.getPartialName(name));
        this.messageLabel.setToolTipText(name);
    }

    @Override
    protected UserNotifierLoader createLoader() {
        this.loader = new MovieCreator(this.viewer, this.registry, this.ctx, this.parameters.getParameters(), this.parameters.getChannels(), this.parameters.getImage(), this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }
}

